/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.InputConstants;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.ui.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class PonderTooltipHandler {
    public static boolean enable = true;
    static LerpedFloat holdWProgress = LerpedFloat.linear().startWithValue(0.0);
    static ItemStack hoveredStack = ItemStack.f_41583_;
    static ItemStack trackingStack = ItemStack.f_41583_;
    static boolean subject = false;
    static boolean deferTick = false;
    public static final String HOLD_TO_PONDER = "ponder.hold_to_ponder";
    public static final String SUBJECT = "ponder.subject";

    public static void tick() {
        deferTick = true;
    }

    public static void deferredTick() {
        deferTick = false;
        Minecraft instance = Minecraft.m_91087_();
        Screen currentScreen = instance.f_91080_;
        if (hoveredStack.m_41619_() || trackingStack.m_41619_()) {
            trackingStack = ItemStack.f_41583_;
            holdWProgress.startWithValue(0.0);
            return;
        }
        float value = holdWProgress.getValue();
        int keyCode = PonderTooltipHandler.ponderKeybind().getKey().m_84873_();
        long window = instance.m_91268_().m_85439_();
        if (!subject && InputConstants.m_84830_((long)window, (int)keyCode)) {
            if (value >= 1.0f) {
                if (currentScreen instanceof NavigatableSimiScreen) {
                    ((NavigatableSimiScreen)currentScreen).centerScalingOnMouse();
                }
                ScreenOpener.transitionTo(PonderUI.of(trackingStack));
                holdWProgress.startWithValue(0.0);
                return;
            }
            holdWProgress.setValue(Math.min(1.0f, value + Math.max(0.25f, value) * 0.25f));
        } else {
            holdWProgress.setValue(Math.max(0.0f, value - 0.05f));
        }
        hoveredStack = ItemStack.f_41583_;
    }

    public static void addToTooltip(ItemTooltipEvent event) {
        if (!enable) {
            return;
        }
        ItemStack stack = event.getItemStack();
        PonderTooltipHandler.updateHovered(stack);
        if (deferTick) {
            PonderTooltipHandler.deferredTick();
        }
        if (trackingStack != stack) {
            return;
        }
        float renderPartialTicks = Minecraft.m_91087_().m_91296_();
        MutableComponent component = subject ? Lang.translateDirect(SUBJECT, new Object[0]).m_130940_(ChatFormatting.GREEN) : PonderTooltipHandler.makeProgressBar(Math.min(1.0f, holdWProgress.getValue(renderPartialTicks) * 8.0f / 7.0f));
        List tooltip = event.getToolTip();
        if (tooltip.size() < 2) {
            tooltip.add(component);
        } else {
            tooltip.add(1, component);
        }
    }

    protected static void updateHovered(ItemStack stack) {
        PonderUI ponderUI;
        Minecraft instance = Minecraft.m_91087_();
        Screen currentScreen = instance.f_91080_;
        boolean inPonderUI = currentScreen instanceof PonderUI;
        ItemStack prevStack = trackingStack;
        hoveredStack = ItemStack.f_41583_;
        subject = false;
        if (inPonderUI && stack.m_41656_((ponderUI = (PonderUI)currentScreen).getSubject())) {
            subject = true;
        }
        if (stack.m_41619_()) {
            return;
        }
        if (!PonderRegistry.ALL.containsKey(RegisteredObjects.getKeyOrThrow(stack.m_41720_()))) {
            return;
        }
        if (prevStack.m_41619_() || !prevStack.m_41656_(stack)) {
            holdWProgress.startWithValue(0.0);
        }
        hoveredStack = stack;
        trackingStack = stack;
    }

    public static void handleTooltipColor(RenderTooltipEvent.Color event) {
        if (trackingStack != event.getItemStack()) {
            return;
        }
        if (holdWProgress.getValue() == 0.0f) {
            return;
        }
        float renderPartialTicks = Minecraft.m_91087_().m_91296_();
        int start = event.getOriginalBorderStart();
        int end = event.getOriginalBorderEnd();
        float progress = Math.min(1.0f, holdWProgress.getValue(renderPartialTicks) * 8.0f / 7.0f);
        start = PonderTooltipHandler.getSmoothColorForProgress(progress);
        end = PonderTooltipHandler.getSmoothColorForProgress(progress);
        event.setBorderStart(start | 0xA0000000);
        event.setBorderEnd(end | 0xA0000000);
    }

    private static int getSmoothColorForProgress(float progress) {
        if (progress < 0.5f) {
            return Color.mixColors(0x5000FF, 0x5555FF, progress * 2.0f);
        }
        return Color.mixColors(0x5555FF, 0xFFFFFF, (progress - 0.5f) * 2.0f);
    }

    private static Component makeProgressBar(float progress) {
        MutableComponent holdW = Lang.translateDirect(HOLD_TO_PONDER, ((MutableComponent)PonderTooltipHandler.ponderKeybind().m_90863_()).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        float charWidth = fontRenderer.m_92895_("|");
        float tipWidth = fontRenderer.m_92852_((FormattedText)holdW);
        int total = (int)(tipWidth / charWidth);
        int current = (int)(progress * (float)total);
        if (progress > 0.0f) {
            Object bars = "";
            bars = (String)bars + ChatFormatting.GRAY + Strings.repeat((String)"|", (int)current);
            if (progress < 1.0f) {
                bars = (String)bars + ChatFormatting.DARK_GRAY + Strings.repeat((String)"|", (int)(total - current));
            }
            return Components.literal((String)bars);
        }
        return holdW;
    }

    protected static KeyMapping ponderKeybind() {
        return Minecraft.m_91087_().f_91066_.f_92085_;
    }
}

