/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.generator;

import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.generator.BlockResourceGenerator;
import net.devtech.arrp.json.blockstate.JBlockStates;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.recipe.JResult;
import net.devtech.arrp.json.recipe.JShapedRecipe;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class BRRPStairsBlock
extends StairBlock
implements BlockResourceGenerator {
    @NotNull
    public final Block baseBlock;

    public BRRPStairsBlock(BlockState baseBlockState, BlockBehaviour.Properties settings) {
        super(baseBlockState, settings);
        this.baseBlock = baseBlockState.m_60734_();
    }

    public BRRPStairsBlock(@NotNull Block baseBlock, BlockBehaviour.Properties settings) {
        super(baseBlock.m_49966_(), settings);
        this.baseBlock = baseBlock;
    }

    public BRRPStairsBlock(Block baseBlock) {
        this(baseBlock, BlockBehaviour.Properties.m_60926_((BlockBehaviour)baseBlock));
    }

    @Override
    @NotNull
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public @UnknownNullability JBlockStates getBlockStates() {
        ResourceLocation blockModelId = this.getBlockModelId();
        return JBlockStates.delegate(BlockModelGenerators.m_124866_((Block)this, (ResourceLocation)blockModelId.brrp_append("_inner"), (ResourceLocation)blockModelId, (ResourceLocation)blockModelId.brrp_append("_outer")));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public @UnknownNullability JModel getBlockModel() {
        return new JModel("block/stairs").textures(JTextures.ofSides(this.getTextureId(TextureSlot.f_125872_), this.getTextureId(TextureSlot.f_125875_), this.getTextureId(TextureSlot.f_125871_)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void writeBlockModel(RuntimeResourcePack pack) {
        JModel blockModel = this.getBlockModel();
        ResourceLocation id = this.getBlockModelId();
        pack.addModel(blockModel, id);
        pack.addModel(blockModel.parent("block/inner_stairs"), id.brrp_append("_inner"));
        pack.addModel(blockModel.parent("block/outer_stairs"), id.brrp_append("_outer"));
    }

    @Override
    public @UnknownNullability JRecipe getCraftingRecipe() {
        return new JShapedRecipe(new JResult((ItemLike)this).count(4)).pattern("#  ", "## ", "###").addKey("#", (ItemLike)this.baseBlock).addInventoryChangedCriterion("has_the_ingredient", (ItemLike)this.baseBlock);
    }
}

