/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.generator;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class TextureRegistry {
    private static final Object2ObjectMap<@NotNull Block, TextureMapping> TEXTURE_MAPS = new Object2ObjectOpenHashMap();

    public static void register(Block block, ResourceLocation texture) {
        TextureRegistry.register(block, TextureSlot.f_125867_, texture);
    }

    public static void register(Block block, TextureSlot textureKey, ResourceLocation texture) {
        ((TextureMapping)TEXTURE_MAPS.computeIfAbsent((Object)block, b -> new TextureMapping())).m_125758_(textureKey, texture);
    }

    public static void registerAppended(Block block, TextureSlot textureKey, String suffix) {
        TextureRegistry.register(block, textureKey, Registry.f_122824_.m_7981_((Object)block).brrp_pend("block/", suffix));
    }

    public static void registerWithName(Block block, TextureSlot textureKey, String path) {
        ResourceLocation id = Registry.f_122824_.m_7981_((Object)block);
        TextureRegistry.register(block, textureKey, new ResourceLocation(id.m_135827_(), "block/" + path));
    }

    public static ResourceLocation getTexture(@NotNull Block block, @NotNull TextureSlot textureKey) {
        @Nullable TextureMapping textureMap = (TextureMapping)TEXTURE_MAPS.getOrDefault((Object)block, null);
        if (textureMap == null) {
            return null;
        }
        try {
            return textureMap.m_125756_(textureKey);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static ResourceLocation getTexture(@NotNull Block block) {
        return TextureRegistry.getTexture(block, TextureSlot.f_125867_);
    }

    public static @UnmodifiableView Map<Block, TextureMapping> getTextureMaps() {
        return Collections.unmodifiableMap(TEXTURE_MAPS);
    }
}

