/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.lang;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Contract;

public class JLang
extends HashMap<String, String>
implements Cloneable {
    public JLang() {
    }

    public JLang(Map<? extends String, ? extends String> map) {
        this();
        this.putAll(map);
    }

    @Deprecated
    @Contract(value="-> new")
    public static JLang lang() {
        return new JLang();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public JLang translate(String in, String out) {
        this.put(in, out);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    private <T> JLang object(Registry<T> registry, String str, T t, String name) {
        return this.object(str, Objects.requireNonNull(registry.m_7981_(t), "register your item before calling this"), name);
    }

    @Deprecated
    @Contract(value="_, _, _ -> this", mutates="this")
    @CanIgnoreReturnValue
    private JLang object(String type, ResourceLocation identifier, String translation) {
        this.put(type + "." + identifier.m_135827_() + "." + identifier.m_135815_(), translation);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_,_ -> this", mutates="this")
    public JLang registryEntry(String type, ResourceLocation identifier, String translation) {
        this.put(Util.m_137492_((String)type, (ResourceLocation)identifier), translation);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_,_,_ -> this", mutates="this")
    public <T> JLang registryEntry(Registry<T> registry, String type, T t, String translation) {
        ResourceKey registryKey = (ResourceKey)registry.m_7854_(t).orElseThrow(() -> new RuntimeException("Please register it first!"));
        return this.registryEntry(type, registryKey.m_135782_(), translation);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang entry(String entry, String translation) {
        this.put(entry, translation);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang itemRespect(Item item, String translation) {
        this.put(item.m_5524_(), translation);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang item(ItemStack stack, String translation) {
        this.put(stack.m_41778_(), translation);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang item(Item item, String translation) {
        return this.registryEntry((Registry)Registry.f_122827_, "item", (Object)item, translation);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang blockRespect(Block block, String translation) {
        this.put(block.m_7705_(), translation);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang block(Block block, String translation) {
        return this.registryEntry((Registry)Registry.f_122824_, "block", (Object)block, translation);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang fluid(Fluid fluid, String translation) {
        return this.registryEntry((Registry)Registry.f_122822_, "fluid", (Object)fluid, translation);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang entityRespect(EntityType<?> type, String translation) {
        this.put(type.m_20675_(), translation);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang entity(EntityType<?> type, String translation) {
        return this.object((Registry)Registry.f_122826_, "entity_type", (Object)type, translation);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang enchantmentRespect(Enchantment enchantment, String translation) {
        this.put(enchantment.m_44704_(), translation);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang enchantment(Enchantment enchantment, String translation) {
        return this.object(Registry.f_122825_, "enchantment", enchantment, translation);
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang item(ResourceLocation item, String translation) {
        return this.registryEntry("item", item, translation);
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang block(ResourceLocation block, String translation) {
        return this.registryEntry("block", block, translation);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang fluid(ResourceLocation id, String translation) {
        return this.registryEntry("fluid", id, translation);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang entity(ResourceLocation id, String translation) {
        return this.registryEntry("entity_type", id, translation);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang enchantment(ResourceLocation id, String translation) {
        return this.registryEntry("enchantment", id, translation);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang itemGroup(ResourceLocation id, String translation) {
        return this.registryEntry("itemGroup", id, translation);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang sound(ResourceLocation id, String translation) {
        return this.registryEntry("sound_event", id, translation);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang status(ResourceLocation id, String translation) {
        return this.registryEntry("mob_effect", id, translation);
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang allPotionOf(ResourceLocation id, String effectTranslation) {
        this.allPotion(id, "Potion of " + effectTranslation, "Splash Potion of " + effectTranslation, "Lingering Potion of " + effectTranslation, "Tipped Arrow of " + effectTranslation);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_,_,_,_ -> this", mutates="this")
    public JLang allPotion(ResourceLocation id, String drinkablePotionName, String splashPotionName, String lingeringPotionName, String tippedArrowName) {
        return this.drinkablePotion(id, drinkablePotionName).splashPotion(id, splashPotionName).lingeringPotion(id, lingeringPotionName).tippedArrow(id, tippedArrowName);
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang tippedArrow(ResourceLocation id, String translation) {
        this.put("item.minecraft.tipped_arrow.effect." + id.m_135815_(), translation);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang lingeringPotion(ResourceLocation id, String name) {
        this.put("item.minecraft.lingering_potion.effect." + id.m_135815_(), name);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang splashPotion(ResourceLocation id, String name) {
        this.put("item.minecraft.splash_potion.effect." + id.m_135815_(), name);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang drinkablePotion(ResourceLocation id, String name) {
        this.put("item.minecraft.potion.effect." + id.m_135815_(), "Potion of " + name);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang drinkablePotionOf(ResourceLocation id, String effectName) {
        this.put("item.minecraft.potion.effect." + id.m_135815_(), "Potion of " + effectName);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang splashPotionOf(ResourceLocation id, String effectName) {
        this.put("item.minecraft.splash_potion.effect." + id.m_135815_(), "Splash Potion of " + effectName);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang lingeringPotionOf(ResourceLocation id, String effectName) {
        this.put("item.minecraft.lingering_potion.effect." + id.m_135815_(), "Lingering Potion of " + effectName);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @Contract(value="_,_ -> this", mutates="this")
    public JLang tippedArrowOf(ResourceLocation id, String effectName) {
        this.put("item.minecraft.tipped_arrow.effect." + id.m_135815_(), "Tipped Arrow of " + effectName);
        return this;
    }

    @CanIgnoreReturnValue
    public JLang biome(ResourceLocation id, String translation) {
        return this.registryEntry("biome", id, translation);
    }

    @Deprecated
    public Map<String, String> getLang() {
        return this;
    }

    @Override
    public JLang clone() {
        return (JLang)super.clone();
    }
}

