/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.models;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.function.Function;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.models.JFace;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@PreferredEnvironment(value=Dist.CLIENT)
public class JFaces
extends EnumMap<Direction, JFace>
implements Cloneable,
JsonSerializable {
    public JFaces() {
        super(Direction.class);
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JFaces set(Direction direction, JFace face) {
        this.put(direction, face);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JFaces setAllFaces(JFace face) {
        for (Direction direction : Direction.values()) {
            this.put(direction, face);
        }
        return this;
    }

    @ApiStatus.AvailableSince(value="0.6.2")
    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JFaces setAllFaces(@NotNull JFace face, boolean cullface) {
        for (Direction direction : Direction.values()) {
            this.put(direction, face.clone().cullface((Direction)(cullface ? direction : null)));
        }
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JFaces setAllFaces(Function<Direction, JFace> faces) {
        for (Direction direction : Direction.values()) {
            this.put(direction, faces.apply(direction));
        }
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JFaces up(JFace face) {
        this.put(Direction.UP, face);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JFaces down(JFace face) {
        this.put(Direction.DOWN, face);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JFaces north(JFace face) {
        this.put(Direction.NORTH, face);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JFaces south(JFace face) {
        this.put(Direction.SOUTH, face);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JFaces east(JFace face) {
        this.put(Direction.EAST, face);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JFaces west(JFace face) {
        this.put(Direction.WEST, face);
        return this;
    }

    @Override
    public JFaces clone() {
        return (JFaces)super.clone();
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.forEach((direction, jFace) -> object.add(direction.m_7912_(), context.serialize(jFace)));
        return object;
    }
}

