/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.tags;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.tags.JTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;

public class IdentifiedTag
extends JTag {
    public final transient String type;
    public final transient ResourceLocation identifier;
    public final transient ResourceLocation fullIdentifier;

    public IdentifiedTag(String type, ResourceLocation identifier) {
        this.type = type;
        this.identifier = identifier;
        this.fullIdentifier = new ResourceLocation(identifier.m_135827_(), this.type + "/" + identifier.m_135815_());
    }

    public IdentifiedTag(TagKey<?> tagKey) {
        this(StringUtils.removeStart((String)TagManager.m_203918_((ResourceKey)tagKey.f_203867_()), (String)"tags/"), tagKey.f_203868_());
    }

    public IdentifiedTag(String namespace, String type, String path) {
        this(type, new ResourceLocation(namespace, path));
    }

    @Contract(value="_ -> new")
    public IdentifiedTag identified(String type) {
        return this.identified(type, this.identifier);
    }

    @CanIgnoreReturnValue
    @Contract(mutates="param1")
    public byte[] write(RuntimeResourcePack pack) {
        return pack.addTag(this.fullIdentifier, this);
    }

    @Override
    public IdentifiedTag clone() {
        return (IdentifiedTag)super.clone();
    }
}

