/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.model;

import com.github.alexthe666.alexsmobs.entity.EntityFarseer;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.world.phys.Vec3;

public class ModelFarseer
extends AdvancedEntityModel<EntityFarseer> {
    public final AdvancedModelBox eye;
    private final AdvancedModelBox root;
    private final AdvancedModelBox bodyCube1;
    private final AdvancedModelBox head;
    private final AdvancedModelBox leftUpperMask;
    private final AdvancedModelBox rightUpperMask;
    private final AdvancedModelBox leftLowerMask;
    private final AdvancedModelBox rightLowerMask;
    private final AdvancedModelBox bodyCube2;
    private final AdvancedModelBox leftArm;
    private final AdvancedModelBox leftElbow;
    private final AdvancedModelBox leftHand;
    private final AdvancedModelBox leftUpperRFinger;
    private final AdvancedModelBox leftLowerRFinger;
    private final AdvancedModelBox leftLowerLFinger;
    private final AdvancedModelBox leftUpperLFinger;
    private final AdvancedModelBox leftArm2;
    private final AdvancedModelBox leftElbow2;
    private final AdvancedModelBox leftHand2;
    private final AdvancedModelBox leftUpperRFinger2;
    private final AdvancedModelBox leftLowerRFinger2;
    private final AdvancedModelBox leftLowerLFinger2;
    private final AdvancedModelBox leftUpperLFinger2;
    private final AdvancedModelBox rightArm;
    private final AdvancedModelBox rightElbow;
    private final AdvancedModelBox rightHand;
    private final AdvancedModelBox rightUpperRFinger;
    private final AdvancedModelBox rightLowerRFinger2;
    private final AdvancedModelBox rightLowerLFinger;
    private final AdvancedModelBox rightUpperLFinger;
    private final AdvancedModelBox rightArm2;
    private final AdvancedModelBox rightElbow2;
    private final AdvancedModelBox rightHand2;
    private final AdvancedModelBox rightUpperRFinger2;
    private final AdvancedModelBox rightLowerRFinger3;
    private final AdvancedModelBox rightLowerLFinger2;
    private final AdvancedModelBox rightUpperLFinger2;
    private final ModelAnimator animator;

    public ModelFarseer(float scale) {
        this.texWidth = 128;
        this.texHeight = 128;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this, "root");
        this.root.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.bodyCube1 = new AdvancedModelBox((AdvancedEntityModel)this, "bodyCube1");
        this.bodyCube1.setRotationPoint(2.0f, -8.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.bodyCube1);
        this.bodyCube1.setTextureOffset(0, 56).addBox(-5.0f, -2.0f, -3.0f, 10.0f, 4.0f, 5.0f, scale, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this, "head");
        this.head.setRotationPoint(0.0f, -15.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(0, 0).addBox(-10.5f, -5.0f, -6.0f, 21.0f, 9.0f, 13.0f, scale, false);
        this.leftUpperMask = new AdvancedModelBox((AdvancedEntityModel)this, "leftUpperMask");
        this.leftUpperMask.setRotationPoint(0.0f, -5.0f, 1.0f);
        this.head.addChild((BasicModelPart)this.leftUpperMask);
        this.leftUpperMask.setTextureOffset(0, 23).addBox(0.0f, -0.5f, -7.9f, 11.0f, 7.0f, 8.0f, scale, false);
        this.rightUpperMask = new AdvancedModelBox((AdvancedEntityModel)this, "rightUpperMask");
        this.rightUpperMask.setRotationPoint(0.0f, -5.0f, 1.0f);
        this.head.addChild((BasicModelPart)this.rightUpperMask);
        this.rightUpperMask.setTextureOffset(0, 23).addBox(-11.0f, -0.5f, -7.9f, 11.0f, 7.0f, 8.0f, scale, true);
        this.leftLowerMask = new AdvancedModelBox((AdvancedEntityModel)this, "leftLowerMask");
        this.leftLowerMask.setRotationPoint(0.0f, 3.0f, 1.0f);
        this.head.addChild((BasicModelPart)this.leftLowerMask);
        this.leftLowerMask.setTextureOffset(31, 31).addBox(0.0f, -2.5f, -7.9f, 11.0f, 4.0f, 8.0f, scale, false);
        this.rightLowerMask = new AdvancedModelBox((AdvancedEntityModel)this, "rightLowerMask");
        this.rightLowerMask.setRotationPoint(0.0f, 3.0f, 1.0f);
        this.head.addChild((BasicModelPart)this.rightLowerMask);
        this.rightLowerMask.setTextureOffset(31, 31).addBox(-11.0f, -2.5f, -7.9f, 11.0f, 4.0f, 8.0f, scale, true);
        this.eye = new AdvancedModelBox((AdvancedEntityModel)this, "eye");
        this.eye.setRotationPoint(0.0f, 4.0f, -1.0f);
        this.head.addChild((BasicModelPart)this.eye);
        this.eye.setTextureOffset(56, 0).addBox(-4.5f, -8.0f, -6.0f, 9.0f, 4.0f, 2.0f, scale, false);
        this.bodyCube2 = new AdvancedModelBox((AdvancedEntityModel)this, "bodyCube2");
        this.bodyCube2.setRotationPoint(1.0f, -2.0f, 1.0f);
        this.root.addChild((BasicModelPart)this.bodyCube2);
        this.bodyCube2.setTextureOffset(33, 44).addBox(-6.0f, -3.0f, -3.0f, 10.0f, 5.0f, 6.0f, scale, false);
        this.leftArm = new AdvancedModelBox((AdvancedEntityModel)this, "leftArm");
        this.leftArm.setRotationPoint(9.0f, -16.5f, 9.0f);
        this.root.addChild((BasicModelPart)this.leftArm);
        this.setRotationAngle(this.leftArm, 0.0f, 0.0f, -0.7854f);
        this.leftArm.setTextureOffset(31, 23).addBox(-1.0f, -1.5f, -2.0f, 16.0f, 3.0f, 4.0f, scale, false);
        this.leftElbow = new AdvancedModelBox((AdvancedEntityModel)this, "leftElbow");
        this.leftElbow.setRotationPoint(15.0f, 0.0f, 0.0f);
        this.leftArm.addChild((BasicModelPart)this.leftElbow);
        this.leftElbow.setTextureOffset(0, 39).addBox(-1.0f, -1.0f, -13.0f, 2.0f, 2.0f, 14.0f, scale, false);
        this.leftHand = new AdvancedModelBox((AdvancedEntityModel)this, "leftHand");
        this.leftHand.setRotationPoint(0.0f, 0.0f, -12.0f);
        this.leftElbow.addChild((BasicModelPart)this.leftHand);
        this.leftUpperRFinger = new AdvancedModelBox((AdvancedEntityModel)this, "leftUpperRFinger");
        this.leftUpperRFinger.setRotationPoint(-1.4f, -1.4f, 0.0f);
        this.leftHand.addChild((BasicModelPart)this.leftUpperRFinger);
        this.setRotationAngle(this.leftUpperRFinger, 0.0f, 0.0f, -0.7854f);
        this.leftUpperRFinger.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, false);
        this.leftLowerRFinger = new AdvancedModelBox((AdvancedEntityModel)this, "leftLowerRFinger");
        this.leftLowerRFinger.setRotationPoint(-1.4f, 1.4f, 0.0f);
        this.leftHand.addChild((BasicModelPart)this.leftLowerRFinger);
        this.setRotationAngle(this.leftLowerRFinger, 0.0f, 0.0f, -2.3562f);
        this.leftLowerRFinger.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, false);
        this.leftLowerLFinger = new AdvancedModelBox((AdvancedEntityModel)this, "leftLowerLFinger");
        this.leftLowerLFinger.setRotationPoint(1.4f, 1.4f, 0.0f);
        this.leftHand.addChild((BasicModelPart)this.leftLowerLFinger);
        this.setRotationAngle(this.leftLowerLFinger, 0.0f, 0.0f, 2.3562f);
        this.leftLowerLFinger.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, false);
        this.leftUpperLFinger = new AdvancedModelBox((AdvancedEntityModel)this, "leftUpperLFinger");
        this.leftUpperLFinger.setRotationPoint(1.4f, -1.4f, 0.0f);
        this.leftHand.addChild((BasicModelPart)this.leftUpperLFinger);
        this.setRotationAngle(this.leftUpperLFinger, 0.0f, 0.0f, 0.7854f);
        this.leftUpperLFinger.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, false);
        this.leftArm2 = new AdvancedModelBox((AdvancedEntityModel)this, "leftArm2");
        this.leftArm2.setRotationPoint(6.0f, -13.5f, 9.0f);
        this.root.addChild((BasicModelPart)this.leftArm2);
        this.setRotationAngle(this.leftArm2, 0.0f, 0.0f, 0.6545f);
        this.leftArm2.setTextureOffset(31, 23).addBox(-1.0f, -1.5f, -2.0f, 16.0f, 3.0f, 4.0f, scale, false);
        this.leftElbow2 = new AdvancedModelBox((AdvancedEntityModel)this, "leftElbow2");
        this.leftElbow2.setRotationPoint(15.0f, 0.0f, 0.0f);
        this.leftArm2.addChild((BasicModelPart)this.leftElbow2);
        this.leftElbow2.setTextureOffset(0, 39).addBox(-1.0f, -1.0f, -13.0f, 2.0f, 2.0f, 14.0f, scale, false);
        this.leftHand2 = new AdvancedModelBox((AdvancedEntityModel)this, "leftHand2");
        this.leftHand2.setRotationPoint(0.0f, 0.0f, -12.0f);
        this.leftElbow2.addChild((BasicModelPart)this.leftHand2);
        this.leftUpperRFinger2 = new AdvancedModelBox((AdvancedEntityModel)this, "leftUpperRFinger2");
        this.leftUpperRFinger2.setRotationPoint(-1.4f, -1.4f, 0.0f);
        this.leftHand2.addChild((BasicModelPart)this.leftUpperRFinger2);
        this.setRotationAngle(this.leftUpperRFinger2, 0.0f, 0.0f, -0.7854f);
        this.leftUpperRFinger2.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, false);
        this.leftLowerRFinger2 = new AdvancedModelBox((AdvancedEntityModel)this, "leftLowerRFinger2");
        this.leftLowerRFinger2.setRotationPoint(-1.4f, 1.4f, 0.0f);
        this.leftHand2.addChild((BasicModelPart)this.leftLowerRFinger2);
        this.setRotationAngle(this.leftLowerRFinger2, 0.0f, 0.0f, -2.3562f);
        this.leftLowerRFinger2.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, false);
        this.leftLowerLFinger2 = new AdvancedModelBox((AdvancedEntityModel)this, "leftLowerLFinger2");
        this.leftLowerLFinger2.setRotationPoint(1.4f, 1.4f, 0.0f);
        this.leftHand2.addChild((BasicModelPart)this.leftLowerLFinger2);
        this.setRotationAngle(this.leftLowerLFinger2, 0.0f, 0.0f, 2.3562f);
        this.leftLowerLFinger2.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, false);
        this.leftUpperLFinger2 = new AdvancedModelBox((AdvancedEntityModel)this, "leftUpperLFinger2");
        this.leftUpperLFinger2.setRotationPoint(1.4f, -1.4f, 0.0f);
        this.leftHand2.addChild((BasicModelPart)this.leftUpperLFinger2);
        this.setRotationAngle(this.leftUpperLFinger2, 0.0f, 0.0f, 0.7854f);
        this.leftUpperLFinger2.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, false);
        this.rightArm = new AdvancedModelBox((AdvancedEntityModel)this, "rightArm");
        this.rightArm.setRotationPoint(-9.0f, -16.5f, 9.0f);
        this.root.addChild((BasicModelPart)this.rightArm);
        this.setRotationAngle(this.rightArm, 0.0f, 0.0f, 0.7854f);
        this.rightArm.setTextureOffset(31, 23).addBox(-15.0f, -1.5f, -2.0f, 16.0f, 3.0f, 4.0f, scale, true);
        this.rightElbow = new AdvancedModelBox((AdvancedEntityModel)this, "rightElbow");
        this.rightElbow.setRotationPoint(-15.0f, 0.0f, 0.0f);
        this.rightArm.addChild((BasicModelPart)this.rightElbow);
        this.rightElbow.setTextureOffset(0, 39).addBox(-1.0f, -1.0f, -13.0f, 2.0f, 2.0f, 14.0f, scale, true);
        this.rightHand = new AdvancedModelBox((AdvancedEntityModel)this, "rightHand");
        this.rightHand.setRotationPoint(0.0f, 0.0f, -12.0f);
        this.rightElbow.addChild((BasicModelPart)this.rightHand);
        this.rightUpperRFinger = new AdvancedModelBox((AdvancedEntityModel)this, "rightUpperRFinger");
        this.rightUpperRFinger.setRotationPoint(1.4f, -1.4f, 0.0f);
        this.rightHand.addChild((BasicModelPart)this.rightUpperRFinger);
        this.setRotationAngle(this.rightUpperRFinger, 0.0f, 0.0f, 0.7854f);
        this.rightUpperRFinger.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, true);
        this.rightLowerRFinger2 = new AdvancedModelBox((AdvancedEntityModel)this, "rightLowerRFinger2");
        this.rightLowerRFinger2.setRotationPoint(1.4f, 1.4f, 0.0f);
        this.rightHand.addChild((BasicModelPart)this.rightLowerRFinger2);
        this.setRotationAngle(this.rightLowerRFinger2, 0.0f, 0.0f, 2.3562f);
        this.rightLowerRFinger2.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, true);
        this.rightLowerLFinger = new AdvancedModelBox((AdvancedEntityModel)this, "rightLowerLFinger");
        this.rightLowerLFinger.setRotationPoint(-1.4f, 1.4f, 0.0f);
        this.rightHand.addChild((BasicModelPart)this.rightLowerLFinger);
        this.setRotationAngle(this.rightLowerLFinger, 0.0f, 0.0f, -2.3562f);
        this.rightLowerLFinger.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, true);
        this.rightUpperLFinger = new AdvancedModelBox((AdvancedEntityModel)this, "rightUpperLFinger");
        this.rightUpperLFinger.setRotationPoint(-1.4f, -1.4f, 0.0f);
        this.rightHand.addChild((BasicModelPart)this.rightUpperLFinger);
        this.setRotationAngle(this.rightUpperLFinger, 0.0f, 0.0f, -0.7854f);
        this.rightUpperLFinger.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, true);
        this.rightArm2 = new AdvancedModelBox((AdvancedEntityModel)this, "rightArm2");
        this.rightArm2.setRotationPoint(-6.0f, -13.5f, 9.0f);
        this.root.addChild((BasicModelPart)this.rightArm2);
        this.setRotationAngle(this.rightArm2, 0.0f, 0.0f, -0.6545f);
        this.rightArm2.setTextureOffset(31, 23).addBox(-15.0f, -1.5f, -2.0f, 16.0f, 3.0f, 4.0f, scale, true);
        this.rightElbow2 = new AdvancedModelBox((AdvancedEntityModel)this, "rightElbow2");
        this.rightElbow2.setRotationPoint(-15.0f, 0.0f, 0.0f);
        this.rightArm2.addChild((BasicModelPart)this.rightElbow2);
        this.rightElbow2.setTextureOffset(0, 39).addBox(-1.0f, -1.0f, -13.0f, 2.0f, 2.0f, 14.0f, scale, true);
        this.rightHand2 = new AdvancedModelBox((AdvancedEntityModel)this, "rightHand2");
        this.rightHand2.setRotationPoint(0.0f, 0.0f, -12.0f);
        this.rightElbow2.addChild((BasicModelPart)this.rightHand2);
        this.rightUpperRFinger2 = new AdvancedModelBox((AdvancedEntityModel)this, "rightUpperRFinger2");
        this.rightUpperRFinger2.setRotationPoint(1.4f, -1.4f, 0.0f);
        this.rightHand2.addChild((BasicModelPart)this.rightUpperRFinger2);
        this.setRotationAngle(this.rightUpperRFinger2, 0.0f, 0.0f, 0.7854f);
        this.rightUpperRFinger2.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, true);
        this.rightLowerRFinger3 = new AdvancedModelBox((AdvancedEntityModel)this, "rightLowerRFinger3");
        this.rightLowerRFinger3.setRotationPoint(1.4f, 1.4f, 0.0f);
        this.rightHand2.addChild((BasicModelPart)this.rightLowerRFinger3);
        this.setRotationAngle(this.rightLowerRFinger3, 0.0f, 0.0f, 2.3562f);
        this.rightLowerRFinger3.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, true);
        this.rightLowerLFinger2 = new AdvancedModelBox((AdvancedEntityModel)this, "rightLowerLFinger2");
        this.rightLowerLFinger2.setRotationPoint(-1.4f, 1.4f, 0.0f);
        this.rightHand2.addChild((BasicModelPart)this.rightLowerLFinger2);
        this.setRotationAngle(this.rightLowerLFinger2, 0.0f, 0.0f, -2.3562f);
        this.rightLowerLFinger2.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, true);
        this.rightUpperLFinger2 = new AdvancedModelBox((AdvancedEntityModel)this, "rightUpperLFinger2");
        this.rightUpperLFinger2.setRotationPoint(-1.4f, -1.4f, 0.0f);
        this.rightHand2.addChild((BasicModelPart)this.rightUpperLFinger2);
        this.setRotationAngle(this.rightUpperLFinger2, 0.0f, 0.0f, -0.7854f);
        this.rightUpperLFinger2.setTextureOffset(0, 0).addBox(-1.0f, -6.0f, -3.0f, 2.0f, 7.0f, 4.0f, scale, true);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public void animate(IAnimatedEntity entity, float f, float f1, float f2, float f3, float f4) {
        this.animator.update(entity);
        this.animator.setAnimation(EntityFarseer.ANIMATION_EMERGE);
        this.animator.startKeyframe(0);
        this.animator.move(this.root, 0.0f, 0.0f, 20.0f);
        this.animator.rotate(this.leftArm, 0.0f, (float)Math.toRadians(80.0), 0.0f);
        this.animator.rotate(this.leftElbow, (float)Math.toRadians(-20.0), (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.leftHand, (float)Math.toRadians(-35.0), (float)Math.toRadians(40.0), 0.0f);
        this.animator.move(this.leftArm, -1.0f, -5.0f, -6.0f);
        this.animator.rotate(this.rightArm, 0.0f, (float)Math.toRadians(-80.0), 0.0f);
        this.animator.rotate(this.rightElbow, (float)Math.toRadians(-40.0), (float)Math.toRadians(70.0), 0.0f);
        this.animator.rotate(this.rightHand, (float)Math.toRadians(5.0), (float)Math.toRadians(-60.0), 0.0f);
        this.animator.move(this.rightArm, 1.0f, -5.0f, -6.0f);
        this.animator.rotate(this.leftArm2, 0.0f, (float)Math.toRadians(60.0), 0.0f);
        this.animator.rotate(this.leftElbow2, (float)Math.toRadians(40.0), (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.leftHand2, (float)Math.toRadians(-15.0), (float)Math.toRadians(40.0), 0.0f);
        this.animator.move(this.leftArm2, 2.0f, 6.0f, -6.0f);
        this.animator.rotate(this.rightArm2, 0.0f, (float)Math.toRadians(-80.0), 0.0f);
        this.animator.rotate(this.rightElbow2, (float)Math.toRadians(20.0), (float)Math.toRadians(50.0), 0.0f);
        this.animator.rotate(this.rightHand2, (float)Math.toRadians(25.0), (float)Math.toRadians(-60.0), 0.0f);
        this.animator.move(this.rightArm2, -2.0f, 5.0f, -4.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(10);
        this.animator.startKeyframe(10);
        this.animator.move(this.root, 0.0f, 0.0f, 15.0f);
        this.animator.rotate(this.leftArm, 0.0f, (float)Math.toRadians(70.0), 0.0f);
        this.animator.rotate(this.leftElbow, (float)Math.toRadians(-20.0), (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.leftHand, (float)Math.toRadians(-5.0), (float)Math.toRadians(50.0), 0.0f);
        this.animator.move(this.leftArm, 1.0f, -5.0f, -1.0f);
        this.animator.rotate(this.rightArm, 0.0f, (float)Math.toRadians(-80.0), 0.0f);
        this.animator.rotate(this.rightElbow, (float)Math.toRadians(-40.0), (float)Math.toRadians(60.0), 0.0f);
        this.animator.rotate(this.rightHand, (float)Math.toRadians(5.0), (float)Math.toRadians(-70.0), 0.0f);
        this.animator.move(this.rightArm, -1.0f, -5.0f, -1.0f);
        this.animator.rotate(this.leftArm2, 0.0f, (float)Math.toRadians(60.0), 0.0f);
        this.animator.rotate(this.leftElbow2, (float)Math.toRadians(30.0), (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.leftHand2, (float)Math.toRadians(-5.0), (float)Math.toRadians(40.0), 0.0f);
        this.animator.move(this.leftArm2, 3.0f, 6.0f, -1.0f);
        this.animator.rotate(this.rightArm2, 0.0f, (float)Math.toRadians(-70.0), 0.0f);
        this.animator.rotate(this.rightElbow2, (float)Math.toRadians(20.0), (float)Math.toRadians(50.0), 0.0f);
        this.animator.rotate(this.rightHand2, (float)Math.toRadians(25.0), (float)Math.toRadians(-60.0), 0.0f);
        this.animator.move(this.rightArm2, -3.0f, 5.0f, 1.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(10);
        this.animator.move(this.root, 0.0f, 0.0f, 10.0f);
        this.animator.rotate(this.leftArm, 0.0f, (float)Math.toRadians(60.0), 0.0f);
        this.animator.rotate(this.leftElbow, (float)Math.toRadians(-20.0), (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.leftHand, (float)Math.toRadians(-15.0), (float)Math.toRadians(50.0), 0.0f);
        this.animator.move(this.leftArm, 2.0f, -5.0f, 4.0f);
        this.animator.rotate(this.rightArm, 0.0f, (float)Math.toRadians(-72.0), 0.0f);
        this.animator.rotate(this.rightElbow, (float)Math.toRadians(-40.0), (float)Math.toRadians(60.0), 0.0f);
        this.animator.rotate(this.rightHand, (float)Math.toRadians(-5.0), (float)Math.toRadians(-75.0), 0.0f);
        this.animator.move(this.rightArm, -1.0f, -3.0f, 4.0f);
        this.animator.rotate(this.leftArm2, 0.0f, (float)Math.toRadians(55.0), 0.0f);
        this.animator.rotate(this.leftElbow2, (float)Math.toRadians(30.0), (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.leftHand2, (float)Math.toRadians(-15.0), (float)Math.toRadians(50.0), 0.0f);
        this.animator.move(this.leftArm2, 5.0f, 6.0f, 4.0f);
        this.animator.rotate(this.rightArm2, 0.0f, (float)Math.toRadians(-60.0), 0.0f);
        this.animator.rotate(this.rightElbow2, (float)Math.toRadians(20.0), (float)Math.toRadians(50.0), 0.0f);
        this.animator.rotate(this.rightHand2, (float)Math.toRadians(5.0), (float)Math.toRadians(-60.0), 0.0f);
        this.animator.move(this.rightArm2, -5.0f, 5.0f, 6.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(10);
        this.animator.move(this.root, 0.0f, 0.0f, 5.0f);
        this.animator.rotate(this.leftArm, 0.0f, (float)Math.toRadians(60.0), 0.0f);
        this.animator.rotate(this.leftElbow, (float)Math.toRadians(-20.0), (float)Math.toRadians(-40.0), 0.0f);
        this.animator.rotate(this.leftHand, (float)Math.toRadians(-15.0), (float)Math.toRadians(85.0), 0.0f);
        this.animator.move(this.leftArm, 3.0f, -5.0f, 9.0f);
        this.animator.rotate(this.rightArm, 0.0f, (float)Math.toRadians(-72.0), 0.0f);
        this.animator.rotate(this.rightElbow, (float)Math.toRadians(-40.0), (float)Math.toRadians(60.0), 0.0f);
        this.animator.rotate(this.rightHand, (float)Math.toRadians(15.0), (float)Math.toRadians(-85.0), 0.0f);
        this.animator.move(this.rightArm, -5.0f, -4.0f, 9.0f);
        this.animator.rotate(this.leftArm2, 0.0f, (float)Math.toRadians(45.0), 0.0f);
        this.animator.rotate(this.leftElbow2, (float)Math.toRadians(30.0), (float)Math.toRadians(-40.0), 0.0f);
        this.animator.rotate(this.leftHand2, (float)Math.toRadians(-5.0), (float)Math.toRadians(70.0), 0.0f);
        this.animator.move(this.leftArm2, 8.0f, 4.0f, 7.0f);
        this.animator.rotate(this.rightArm2, 0.0f, (float)Math.toRadians(-50.0), 0.0f);
        this.animator.rotate(this.rightElbow2, (float)Math.toRadians(20.0), (float)Math.toRadians(50.0), 0.0f);
        this.animator.rotate(this.rightHand2, (float)Math.toRadians(25.0), (float)Math.toRadians(-70.0), 0.0f);
        this.animator.move(this.rightArm2, -5.0f, 5.0f, 11.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(10);
    }

    public void setupAnim(EntityFarseer entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float invPortalDegree;
        this.resetToDefaultPose();
        this.animate(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float idleSpeed = 0.15f;
        float idleDegree = invPortalDegree = 1.0f - entity.getFacingCameraAmount(partialTick);
        float angryProgress = entity.prevAngryProgress + (entity.angryProgress - entity.prevAngryProgress) * partialTick;
        float strike1Progress = (entity.prevStrikeProgress[0] + (entity.strikeProgress[0] - entity.prevStrikeProgress[0]) * partialTick) * invPortalDegree;
        float strike2Progress = (entity.prevStrikeProgress[1] + (entity.strikeProgress[1] - entity.prevStrikeProgress[1]) * partialTick) * invPortalDegree;
        float strike3Progress = (entity.prevStrikeProgress[2] + (entity.strikeProgress[2] - entity.prevStrikeProgress[2]) * partialTick) * invPortalDegree;
        float strike4Progress = (entity.prevStrikeProgress[3] + (entity.strikeProgress[3] - entity.prevStrikeProgress[3]) * partialTick) * invPortalDegree;
        float clasp1Progress = Math.max(strike1Progress, (entity.prevClaspProgress[0] + (entity.claspProgress[0] - entity.prevClaspProgress[0]) * partialTick) * invPortalDegree);
        float clasp2Progress = Math.max(strike2Progress, (entity.prevClaspProgress[1] + (entity.claspProgress[1] - entity.prevClaspProgress[1]) * partialTick) * invPortalDegree);
        float clasp3Progress = Math.max(strike3Progress, (entity.prevClaspProgress[2] + (entity.claspProgress[2] - entity.prevClaspProgress[2]) * partialTick) * invPortalDegree);
        float clasp4Progress = Math.max(strike4Progress, (entity.prevClaspProgress[3] + (entity.claspProgress[3] - entity.prevClaspProgress[3]) * partialTick) * invPortalDegree);
        float armYaw = (float)Math.toRadians(entity.getLatencyVar(5, 3, partialTick) - entity.getLatencyVar(0, 3, partialTick));
        Vec3 topArmOffset = entity.getLatencyOffsetVec(4, partialTick).m_82490_(-4.0);
        Vec3 bottomArmOffset = entity.getLatencyOffsetVec(8, partialTick).m_82490_(-5.0);
        Vec3 body1Offset = entity.getLatencyOffsetVec(8, partialTick).m_82490_(-3.0);
        Vec3 body2Offset = entity.getLatencyOffsetVec(12, partialTick).m_82490_(-5.0);
        Vec3 angryShake = entity.angryShakeVec.m_82490_((double)(angryProgress * 0.1f));
        this.progressRotationPrev(this.rightUpperMask, angryProgress, (float)Math.toRadians(-35.0), (float)Math.toRadians(13.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.leftUpperMask, angryProgress, (float)Math.toRadians(-35.0), (float)Math.toRadians(-13.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.rightLowerMask, angryProgress, (float)Math.toRadians(35.0), (float)Math.toRadians(13.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.leftLowerMask, angryProgress, (float)Math.toRadians(35.0), (float)Math.toRadians(-13.0), 0.0f, 5.0f);
        this.progressPositionPrev(this.bodyCube1, angryProgress, 0.0f, 0.0f, 4.0f, 5.0f);
        this.progressPositionPrev(this.bodyCube2, angryProgress, 0.0f, 0.0f, 2.0f, 5.0f);
        this.progressRotationPrev(this.leftUpperRFinger, clasp1Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leftLowerRFinger, clasp1Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leftLowerLFinger, clasp1Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leftUpperLFinger, clasp1Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.rightUpperRFinger, clasp2Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.rightLowerRFinger2, clasp2Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.rightLowerLFinger, clasp2Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.rightUpperLFinger, clasp2Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leftUpperRFinger2, clasp3Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leftLowerRFinger2, clasp3Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leftLowerLFinger2, clasp3Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.leftUpperLFinger2, clasp3Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.rightUpperRFinger2, clasp4Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.rightLowerRFinger3, clasp4Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.rightLowerLFinger2, clasp4Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressRotationPrev(this.rightUpperLFinger2, clasp4Progress, (float)Math.toRadians(45.0), 0.0f, 0.0f, 5.0f);
        this.progressPositionPrev(this.leftArm, strike1Progress, 4.0f, -4.0f, -9.0f, 5.0f);
        this.progressRotationPrev(this.leftArm, strike1Progress, 0.0f, (float)Math.toRadians(90.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.leftElbow, strike1Progress, 0.0f, (float)Math.toRadians(-70.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.leftHand, strike1Progress, 0.0f, (float)Math.toRadians(-10.0), 0.0f, 5.0f);
        this.progressPositionPrev(this.rightArm, strike2Progress, -4.0f, -4.0f, -9.0f, 5.0f);
        this.progressRotationPrev(this.rightArm, strike2Progress, 0.0f, (float)Math.toRadians(-90.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.rightElbow, strike2Progress, 0.0f, (float)Math.toRadians(70.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.rightHand, strike2Progress, 0.0f, (float)Math.toRadians(10.0), 0.0f, 5.0f);
        this.progressPositionPrev(this.leftArm2, strike3Progress, 6.0f, 4.0f, -9.0f, 5.0f);
        this.progressRotationPrev(this.leftArm2, strike3Progress, 0.0f, (float)Math.toRadians(90.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.leftElbow2, strike3Progress, 0.0f, (float)Math.toRadians(-70.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.leftHand2, strike3Progress, 0.0f, (float)Math.toRadians(-10.0), 0.0f, 5.0f);
        this.progressPositionPrev(this.rightArm2, strike4Progress, -6.0f, 4.0f, -9.0f, 5.0f);
        this.progressRotationPrev(this.rightArm2, strike4Progress, 0.0f, (float)Math.toRadians(-90.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.rightElbow2, strike4Progress, 0.0f, (float)Math.toRadians(70.0), 0.0f, 5.0f);
        this.progressRotationPrev(this.rightHand2, strike4Progress, 0.0f, (float)Math.toRadians(10.0), 0.0f, 5.0f);
        this.leftArm.rotationPointX = (float)((double)this.leftArm.rotationPointX + (topArmOffset.f_82479_ + Math.sin(ageInTicks * idleSpeed + 1.3f)) * (double)idleDegree);
        this.leftArm.rotationPointY = (float)((double)this.leftArm.rotationPointY + (topArmOffset.f_82480_ + Math.sin(ageInTicks * idleSpeed + 1.6f)) * (double)idleDegree);
        this.leftArm.rotationPointZ = (float)((double)this.leftArm.rotationPointZ + (topArmOffset.f_82481_ + Math.cos(ageInTicks * idleSpeed + 1.9f)) * (double)idleDegree);
        this.leftArm.rotateAngleY += armYaw;
        this.leftArm2.rotationPointX = (float)((double)this.leftArm2.rotationPointX + (bottomArmOffset.f_82479_ + Math.sin(ageInTicks * idleSpeed + 2.3f)) * (double)idleDegree);
        this.leftArm2.rotationPointY = (float)((double)this.leftArm2.rotationPointY + (bottomArmOffset.f_82480_ + Math.sin(ageInTicks * idleSpeed + 2.6f)) * (double)idleDegree);
        this.leftArm2.rotationPointZ = (float)((double)this.leftArm2.rotationPointZ + (bottomArmOffset.f_82481_ + Math.cos(ageInTicks * idleSpeed + 2.9f)) * (double)idleDegree);
        this.leftArm2.rotateAngleY += armYaw;
        this.rightArm.rotationPointX = (float)((double)this.rightArm.rotationPointX + (topArmOffset.f_82479_ + Math.sin(ageInTicks * idleSpeed + 3.3f)) * (double)idleDegree);
        this.rightArm.rotationPointY = (float)((double)this.rightArm.rotationPointY + (topArmOffset.f_82480_ + Math.sin(ageInTicks * idleSpeed + 3.6f)) * (double)idleDegree);
        this.rightArm.rotationPointZ = (float)((double)this.rightArm.rotationPointZ + (topArmOffset.f_82481_ + Math.cos(ageInTicks * idleSpeed + 3.9f)) * (double)idleDegree);
        this.rightArm.rotateAngleY += armYaw;
        this.rightArm2.rotationPointX = (float)((double)this.rightArm2.rotationPointX + (bottomArmOffset.f_82479_ + Math.sin(ageInTicks * idleSpeed + 4.3f)) * (double)idleDegree);
        this.rightArm2.rotationPointY = (float)((double)this.rightArm2.rotationPointY + (bottomArmOffset.f_82480_ + Math.sin(ageInTicks * idleSpeed + 4.6f)) * (double)idleDegree);
        this.rightArm2.rotationPointZ = (float)((double)this.rightArm2.rotationPointZ + (bottomArmOffset.f_82481_ + Math.cos(ageInTicks * idleSpeed + 4.9f)) * (double)idleDegree);
        this.rightArm2.rotateAngleY += armYaw;
        this.bodyCube1.rotationPointX = (float)((double)this.bodyCube1.rotationPointX + (body1Offset.f_82479_ + Math.sin(ageInTicks * idleSpeed + 7.3f)) * (double)idleDegree);
        this.bodyCube1.rotationPointY = (float)((double)this.bodyCube1.rotationPointY + (body1Offset.f_82480_ + Math.sin(ageInTicks * idleSpeed + 7.6f)) * (double)idleDegree);
        this.bodyCube1.rotationPointZ = (float)((double)this.bodyCube1.rotationPointZ + (body1Offset.f_82481_ + Math.cos(ageInTicks * idleSpeed + 7.9f)) * (double)idleDegree);
        this.bodyCube2.rotationPointX = (float)((double)this.bodyCube2.rotationPointX + (body2Offset.f_82479_ + Math.sin(ageInTicks * idleSpeed + 5.3f)) * (double)idleDegree);
        this.bodyCube2.rotationPointY = (float)((double)this.bodyCube2.rotationPointY + (body2Offset.f_82480_ + Math.sin(ageInTicks * idleSpeed + 5.6f)) * (double)idleDegree);
        this.bodyCube2.rotationPointZ = (float)((double)this.bodyCube2.rotationPointZ + (body2Offset.f_82481_ + Math.cos(ageInTicks * idleSpeed + 5.9f)) * (double)idleDegree);
        this.head.rotationPointX = (float)((double)this.head.rotationPointX + angryShake.f_82479_);
        this.head.rotationPointY = (float)((double)this.head.rotationPointY + angryShake.f_82480_);
        this.head.rotationPointZ = (float)((double)this.head.rotationPointZ + angryShake.f_82481_);
        this.bob(this.root, idleSpeed, idleDegree, false, ageInTicks, 1.0f);
        this.swing(this.leftArm, idleSpeed, idleDegree * 0.2f, true, 1.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.rightArm, idleSpeed, idleDegree * 0.2f, false, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.leftArm2, idleSpeed, idleDegree * 0.2f, true, 3.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.rightArm2, idleSpeed, idleDegree * 0.2f, false, 4.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.leftUpperMask, idleSpeed * 8.0f, 0.05f, true, 1.0f, 0.2f, ageInTicks, angryProgress * 0.2f);
        this.walk(this.rightUpperMask, idleSpeed * 8.0f, 0.05f, true, 2.0f, 0.2f, ageInTicks, angryProgress * 0.2f);
        this.walk(this.rightLowerMask, idleSpeed * 8.0f, 0.05f, false, 3.0f, 0.2f, ageInTicks, angryProgress * 0.2f);
        this.walk(this.leftLowerMask, idleSpeed * 8.0f, 0.05f, false, 4.0f, 0.2f, ageInTicks, angryProgress * 0.2f);
        float headY = netHeadYaw * invPortalDegree * ((float)Math.PI / 180);
        float headZ = headPitch * invPortalDegree * ((float)Math.PI / 180);
        this.head.rotateAngleY += headY;
        this.head.rotateAngleX += headZ;
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.bodyCube1, (Object)this.head, (Object)this.leftUpperMask, (Object)this.rightUpperMask, (Object)this.leftLowerMask, (Object)this.rightLowerMask, (Object)this.eye, (Object)this.bodyCube2, (Object)this.leftArm, (Object)this.leftElbow, (Object)this.leftHand, (Object[])new AdvancedModelBox[]{this.leftUpperRFinger, this.leftLowerRFinger, this.leftLowerLFinger, this.leftUpperLFinger, this.leftArm2, this.leftElbow2, this.leftHand2, this.leftUpperRFinger2, this.leftLowerRFinger2, this.leftLowerLFinger2, this.leftUpperLFinger2, this.rightArm, this.rightElbow, this.rightHand, this.rightUpperRFinger, this.rightLowerRFinger2, this.rightLowerLFinger, this.rightUpperLFinger, this.rightArm2, this.rightElbow2, this.rightHand2, this.rightUpperRFinger2, this.rightLowerRFinger3, this.rightLowerLFinger2, this.rightUpperLFinger2});
    }

    public void setRotationAngle(AdvancedModelBox advancedModelBox, float x, float y, float z) {
        advancedModelBox.rotateAngleX = x;
        advancedModelBox.rotateAngleY = y;
        advancedModelBox.rotateAngleZ = z;
    }
}

