/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.fastload.init;

import com.abdelaziz.fastload.client.FLClientEvents;
import com.abdelaziz.fastload.client.FLClientHandler;
import com.abdelaziz.fastload.config.init.DefaultConfig;
import com.abdelaziz.fastload.config.init.FLConfig;
import com.abdelaziz.fastload.config.init.FLMath;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="fastload")
public class Fastload {
    public static final String MOD_ID = "fastload";
    public static final String NAMESPACE = "Fastload";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Fastload");

    public Fastload() {
        MinecraftForge.EVENT_BUS.addListener(this::clientSetup);
        FLConfig.init();
        if (FMLLoader.getDist() == Dist.CLIENT) {
            LOGGER.info(Fastload.loggableString(DefaultConfig.propertyKeys.tryLimit()) + FLMath.getChunkTryLimit());
            LOGGER.info(Fastload.loggableString(DefaultConfig.propertyKeys.unsafeClose()) + FLMath.getCloseUnsafe().toString().toUpperCase());
            LOGGER.info(Fastload.loggableString(DefaultConfig.propertyKeys.render(true), "radius") + FLMath.getPreRenderRadius());
            LOGGER.info(Fastload.loggableString(DefaultConfig.propertyKeys.render(true), "area") + FLMath.getPreRenderArea());
        }
        LOGGER.info(Fastload.loggableString(DefaultConfig.propertyKeys.debug()) + FLMath.getDebug().toString().toUpperCase());
        LOGGER.info(Fastload.loggableString(DefaultConfig.propertyKeys.pregen(true), "radius") + FLMath.getPregenRadius(true));
        LOGGER.info(Fastload.loggableString(DefaultConfig.propertyKeys.pregen(true), "area") + FLMath.getPregenArea());
    }

    private static String loggableString(String key) {
        return key.toUpperCase() + ": ";
    }

    private static String loggableString(String key, String extra) {
        return key.toUpperCase() + "_" + extra.toUpperCase() + ": ";
    }

    private void clientSetup(FMLClientSetupEvent event) {
        FLClientEvents.init();
        FLClientHandler.init();
    }
}

