/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge;

import juuxel.adorn.CommonEventHandlers;
import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.block.SneakClickHandler;
import juuxel.adorn.block.SofaBlock;
import juuxel.adorn.entity.AdornEntities;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.lib.AdornGameRules;
import juuxel.adorn.lib.AdornSounds;
import juuxel.adorn.lib.AdornTags;
import juuxel.adorn.platform.Registrar;
import juuxel.adorn.platform.forge.registrar.ForgeRegistrar;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

final class EventsImplementedInJava {
    EventsImplementedInJava() {
    }

    void register(IEventBus modBus, IEventBus forgeBus) {
        this.register(AdornSounds.SOUNDS, modBus);
        this.register(AdornBlocks.INSTANCE.getBlocks(), modBus);
        this.register(AdornBlocks.INSTANCE.getItems(), modBus);
        this.register(AdornItems.ITEMS, modBus);
        this.register(AdornEntities.ENTITIES, modBus);
        this.register(AdornBlockEntities.BLOCK_ENTITIES, modBus);
        modBus.addListener(this::init);
        forgeBus.addListener(this::handleCarpetedBlocks);
        forgeBus.addListener(this::handleSneakClicks);
        forgeBus.addListener(this::handleSofaSleepTime);
        forgeBus.addListener(this::preventSofaSpawns);
    }

    private void init(FMLCommonSetupEvent event) {
        AdornGameRules.init();
        AdornTags.init();
    }

    private void register(Registrar<?> registrar, IEventBus modBus) {
        ((ForgeRegistrar)registrar).hook(modBus);
    }

    private void handleCarpetedBlocks(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result = CommonEventHandlers.handleCarpets(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        if (result != InteractionResult.PASS) {
            event.setCancellationResult(result);
            event.setCanceled(true);
        }
    }

    private void handleSneakClicks(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        BlockState state = event.getLevel().m_8055_(event.getPos());
        Block block = state.m_60734_();
        if (block instanceof SneakClickHandler) {
            InteractionResult result;
            SneakClickHandler clickHandler = (SneakClickHandler)block;
            if (player.m_6144_() && player.m_21120_(event.getHand()).m_41619_() && (result = clickHandler.onSneakClick(state, event.getLevel(), event.getPos(), player, event.getHand(), event.getHitVec())) != InteractionResult.PASS) {
                event.setCancellationResult(result);
                event.setCanceled(true);
            }
        }
    }

    private void handleSofaSleepTime(SleepingTimeCheckEvent event) {
        BlockPos sleepingPos = event.getSleepingLocation().orElse(null);
        if (sleepingPos == null) {
            return;
        }
        Level world = event.getEntity().f_19853_;
        if (world.m_46461_() && world.m_8055_(sleepingPos).m_60734_() instanceof SofaBlock) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    private void preventSofaSpawns(PlayerSetSpawnEvent event) {
        BlockPos pos = event.getNewSpawn();
        if (pos != null && !event.isForced() && event.getEntity().f_19853_.m_8055_(pos).m_60734_() instanceof SofaBlock) {
            event.setCanceled(true);
        }
    }
}

