/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities;

import foundationgames.enhancedblockentities.EBESetup;
import foundationgames.enhancedblockentities.EnhancedBlockEntityRegistry;
import foundationgames.enhancedblockentities.ReloadType;
import foundationgames.enhancedblockentities.client.model.ModelIdentifiers;
import foundationgames.enhancedblockentities.config.EBEConfig;
import foundationgames.enhancedblockentities.util.DateUtil;
import foundationgames.enhancedblockentities.util.ResourceUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enhancedblockentities")
public final class EnhancedBlockEntities {
    public static final String ID = "enhancedblockentities";
    public static final Logger LOG = LogManager.getLogger((String)"Enhanced Block Entities");
    public static final EBEConfig CONFIG = new EBEConfig();

    public EnhancedBlockEntities() {
        ModelIdentifiers.init();
        EBESetup.setupResourceProviders();
        ItemProperties.register((Item)Items.f_42009_, (ResourceLocation)new ResourceLocation("is_christmas"), (stack, world, entity, seed) -> DateUtil.isChristmas() ? 1.0f : 0.0f);
        EnhancedBlockEntities.load();
    }

    public static void reload(ReloadType type) {
        EnhancedBlockEntities.load();
        if (type == ReloadType.WORLD) {
            Minecraft.m_91087_().f_91060_.m_109818_();
        } else if (type == ReloadType.RESOURCES) {
            Minecraft.m_91087_().m_91391_();
        }
    }

    public static void load() {
        CONFIG.load();
        EnhancedBlockEntityRegistry.clear();
        ResourceUtil.resetPack();
        if (EnhancedBlockEntities.CONFIG.renderEnhancedChests) {
            EBESetup.setupChests();
            EBESetup.setupRRPChests();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedSigns) {
            EBESetup.setupSigns();
            EBESetup.setupRRPSigns();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedBells) {
            EBESetup.setupBells();
            EBESetup.setupRRPBells();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedBeds) {
            EBESetup.setupBeds();
            EBESetup.setupRRPBeds();
        }
        if (EnhancedBlockEntities.CONFIG.renderEnhancedShulkerBoxes) {
            EBESetup.setupShulkerBoxes();
            EBESetup.setupRRPShulkerBoxes();
        }
    }
}

