/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class TextureImage
implements AutoCloseable {
    @Nullable
    private final AnimationMetadataSection metadata;
    private final NativeImage image;
    private final int frameW;
    private final int frameH;
    private final int maxFrames;
    private final int frameScale;

    private TextureImage(NativeImage image, @Nullable AnimationMetadataSection metadata) {
        this.image = image;
        this.metadata = metadata;
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        this.frameW = metadata == null ? imgWidth : metadata.m_119031_(imgWidth);
        this.frameH = metadata == null ? imgHeight : metadata.m_119026_(imgWidth);
        this.frameScale = imgWidth / this.frameW;
        int frameScaleHeight = imgHeight / this.frameH;
        this.maxFrames = this.frameScale * frameScaleHeight;
    }

    public void forEachFrame(FramePixelConsumer framePixelConsumer) {
        for (int ind = 0; ind < this.maxFrames; ++ind) {
            int xOff = this.getFrameX(ind);
            int yOff = this.getFrameY(ind);
            for (int x = 0; x < this.frameW; ++x) {
                for (int y = 0; y < this.frameH; ++y) {
                    framePixelConsumer.accept(ind, x + xOff, y + yOff);
                }
            }
        }
    }

    public void toGrayscale() {
        SpriteUtils.grayscaleImage(this.image);
    }

    public RGBColor getAverageColor() {
        return SpriteUtils.averageColor(this.image);
    }

    public int frameWidth() {
        return this.frameW;
    }

    public int frameHeight() {
        return this.frameH;
    }

    public int getFrameX(int frameIndex) {
        return frameIndex % this.frameScale * this.frameW;
    }

    public int getFrameY(int frameIndex) {
        return frameIndex / this.frameScale * this.frameH;
    }

    public NativeImage getImage() {
        return this.image;
    }

    public int framesSize() {
        return this.maxFrames;
    }

    @Nullable
    public AnimationMetadataSection getMetadata() {
        return this.metadata;
    }

    public TextureImage makeCopy() {
        NativeImage im = new NativeImage(this.imageWidth(), this.imageHeight(), false);
        im.m_85054_(this.image);
        return new TextureImage(im, this.metadata);
    }

    public TextureImage createAnimationTemplate(int length, AnimationMetadataSection useDataFrom) {
        ArrayList<AnimationFrame> frameData = new ArrayList<AnimationFrame>();
        useDataFrom.m_174861_((i, t) -> frameData.add(new AnimationFrame(i, t)));
        return this.createAnimationTemplate(length, frameData, useDataFrom.m_119030_(), useDataFrom.m_119036_());
    }

    public TextureImage createAnimationTemplate(int length, List<AnimationFrame> frameData, int frameTime, boolean interpolate) {
        NativeImage im = new NativeImage(this.frameWidth(), this.frameHeight() * length, false);
        TextureImage t = new TextureImage(im, new AnimationMetadataSection(frameData, this.frameW, this.frameH, frameTime, interpolate));
        t.forEachFrame((i, x, y) -> {
            int xo = x - t.getFrameX(i);
            int yo = y - t.getFrameY(i);
            t.image.m_84988_(x.intValue(), y.intValue(), this.image.m_84985_(xo, yo));
        });
        return t;
    }

    public static TextureImage open(ResourceManager manager, ResourceLocation relativePath) throws IOException {
        ResourceLocation textureLoc = ResType.TEXTURES.getPath(relativePath);
        NativeImage i = SpriteUtils.readImage(manager, textureLoc);
        ResourceLocation metadataLoc = ResType.MCMETA.getPath(relativePath);
        AnimationMetadataSection metadata = null;
        Optional res = manager.m_213713_(metadataLoc);
        if (res.isPresent()) {
            try (InputStream metadataStream = ((Resource)res.get()).m_215507_();){
                metadata = (AnimationMetadataSection)AbstractPackResources.m_10214_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_, (InputStream)metadataStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new TextureImage(i, metadata);
    }

    public static TextureImage createNew(int width, int height, @Nullable AnimationMetadataSection animation) {
        return new TextureImage(new NativeImage(width, height, false), animation);
    }

    public static TextureImage of(NativeImage image, @Nullable AnimationMetadataSection animation) {
        return new TextureImage(image, animation);
    }

    @Override
    public void close() {
        this.image.close();
    }

    public int imageWidth() {
        return this.image.m_84982_();
    }

    public int imageHeight() {
        return this.image.m_85084_();
    }

    public ImmutableList<NativeImage> splitFrames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.metadata == null) {
            builder.add((Object)this.image);
            return builder.build();
        }
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        int frameW = this.metadata.m_119031_(imgWidth);
        int frameH = this.metadata.m_119026_(imgWidth);
        int frameScaleWidth = imgWidth / frameW;
        int frameScaleHeight = imgHeight / frameH;
        int maxFrames = frameScaleWidth * frameScaleHeight;
        ArrayList indexList = Lists.newArrayList();
        this.metadata.m_174861_((index, time) -> indexList.add(index));
        if (indexList.isEmpty()) {
            for (int l = 0; l < maxFrames; ++l) {
                indexList.add(l);
            }
        }
        if (indexList.size() <= 1) {
            builder.add((Object)this.image);
        } else {
            Iterator iterator = indexList.iterator();
            while (iterator.hasNext()) {
                int index2 = (Integer)iterator.next();
                int xOffset = index2 % frameScaleWidth * frameW;
                int yOffset = index2 / frameScaleWidth * frameH;
                if (index2 < 0 || xOffset + frameW >= imgWidth || yOffset + frameH >= imgHeight) continue;
                NativeImage f = new NativeImage(frameW, frameH, false);
                for (int x = 0; x < frameW; ++x) {
                    for (int y = 0; y < frameH; ++y) {
                        f.m_84988_(x, y, this.image.m_84985_(x + xOffset, y + yOffset));
                    }
                }
                builder.add((Object)f);
            }
        }
        return builder.build();
    }

    @Nullable
    public JsonObject serializeMcMeta() {
        if (this.metadata == null) {
            return null;
        }
        JsonObject obj = new JsonObject();
        JsonObject animation = new JsonObject();
        animation.addProperty("frametime", (Number)this.metadata.m_119030_());
        animation.addProperty("interpolate", Boolean.valueOf(this.metadata.m_119036_()));
        animation.addProperty("height", (Number)this.metadata.m_119026_(this.frameHeight()));
        animation.addProperty("width", (Number)this.metadata.m_119031_(this.frameWidth()));
        JsonArray frames = new JsonArray();
        this.metadata.m_174861_((i, t) -> {
            if (t != -1) {
                JsonObject o = new JsonObject();
                o.addProperty("time", (Number)t);
                o.addProperty("index", (Number)i);
                frames.add((JsonElement)o);
            } else {
                frames.add((Number)i);
            }
        });
        animation.add("frames", (JsonElement)frames);
        obj.add("animation", (JsonElement)animation);
        return obj;
    }

    public void applyOverlay(TextureImage ... overlays) throws IllegalStateException {
        int width = this.imageWidth();
        int height = this.imageHeight();
        if (Arrays.stream(overlays).anyMatch(n -> n.imageHeight() < height || n.imageWidth() < width)) {
            throw new IllegalStateException("Could not merge images because they had different dimensions");
        }
        for (TextureImage o : overlays) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    this.image.m_166411_(x, y, o.image.m_84985_(x, y));
                }
            }
            o.close();
        }
    }

    public void applyOverlayOnExisting(TextureImage ... overlays) throws IllegalStateException {
        int width = this.imageWidth();
        int height = this.imageHeight();
        if (Arrays.stream(overlays).anyMatch(n -> n.imageHeight() < height || n.imageWidth() < width)) {
            throw new IllegalStateException("Could not merge images because they had different dimensions");
        }
        for (TextureImage o : overlays) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (NativeImage.m_84983_((int)this.image.m_84985_(x, y)) == 0) continue;
                    this.image.m_166411_(x, y, o.image.m_84985_(x, y));
                }
            }
            o.close();
        }
    }

    public void removeAlpha(int backgroundColor) {
        for (int x = 0; x < this.image.m_84982_(); ++x) {
            for (int y = 0; y < this.image.m_85084_(); ++y) {
                int oldValue = this.image.m_84985_(x, y);
                int a = NativeImage.m_84983_((int)oldValue);
                if (a == 0) {
                    this.image.m_84988_(x, y, backgroundColor);
                    continue;
                }
                this.image.m_84988_(x, y, NativeImage.m_84992_((int)255, (int)NativeImage.m_85119_((int)oldValue), (int)NativeImage.m_85103_((int)oldValue), (int)NativeImage.m_85085_((int)oldValue)));
            }
        }
    }

    public void crop(TextureImage mask) {
        this.crop(mask, true);
    }

    public void crop(TextureImage mask, boolean inner) {
        int width = this.imageWidth();
        int height = this.imageHeight();
        if (mask.imageHeight() < height || mask.imageWidth() < width) {
            throw new IllegalStateException("Could not merge images because they had different dimensions");
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (NativeImage.m_84983_((int)mask.image.m_84985_(x, y)) != 0 != inner) continue;
                this.image.m_84988_(x, y, 0);
            }
        }
        mask.close();
    }

    @FunctionalInterface
    public static interface FramePixelConsumer
    extends TriConsumer<Integer, Integer, Integer> {
        public void accept(Integer var1, Integer var2, Integer var3);
    }
}

