/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;

public class HangingColumnWithBaseConfig
implements FeatureConfiguration {
    public static final Codec<HangingColumnWithBaseConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.f_68747_.fieldOf("base_block_provider").forGetter(config -> config.baseBlockProvider), (App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)BlockStateProvider.f_68747_.fieldOf("end_block_provider").forGetter(config -> config.endBlockProvider), (App)Codec.INT.fieldOf("min_length").forGetter(config -> config.minLength), (App)Codec.INT.fieldOf("max_length").forGetter(config -> config.maxLength), (App)BlockPredicate.f_190392_.fieldOf("placement_filter").forGetter(HangingColumnWithBaseConfig::getPlacementFilter)).apply((Applicative)codecRecorder, HangingColumnWithBaseConfig::new));
    private final BlockStateProvider baseBlockProvider;
    private final BlockStateProvider blockProvider;
    private final BlockStateProvider endBlockProvider;
    private final int minLength;
    private final int maxLength;
    private final BlockPredicate placementFilter;

    HangingColumnWithBaseConfig(BlockStateProvider baseBlockProvider, BlockStateProvider blockProvider, BlockStateProvider endBlockProvider, int minLength, int maxLength, BlockPredicate placementFilter) {
        this.baseBlockProvider = baseBlockProvider;
        this.blockProvider = blockProvider;
        this.endBlockProvider = endBlockProvider;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.placementFilter = placementFilter;
    }

    public BlockStateProvider getBaseBlockProvider() {
        return this.baseBlockProvider;
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    public BlockStateProvider getEndBlockProvider() {
        return this.endBlockProvider;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxPossibleLength() {
        int returnValue = this.minLength - this.maxLength;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public BlockPredicate getPlacementFilter() {
        return this.placementFilter;
    }

    public static class Builder {
        private BlockStateProvider baseBlockProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
        private BlockStateProvider blockProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
        private BlockStateProvider endBlockProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50016_.m_49966_());
        private BlockPredicate placementFilter = BlockPredicate.m_204677_((TagKey)BlockTags.f_144274_);
        private int minLength = 1;
        private int maxLength = 9;

        public Builder setBaseBlock(Block block) {
            this.baseBlockProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setBaseBlock(BlockState state) {
            this.baseBlockProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setBaseBlock(BlockStateProvider provider) {
            this.baseBlockProvider = provider != null ? provider : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setBlock(Block block) {
            this.blockProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setBlock(BlockState state) {
            this.blockProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setBlock(BlockStateProvider provider) {
            this.blockProvider = provider != null ? provider : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setEndBlock(Block block) {
            this.endBlockProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : this.blockProvider;
            return this;
        }

        public Builder setEndBlock(BlockState state) {
            this.endBlockProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : this.blockProvider;
            return this;
        }

        public Builder setEndBlock(BlockStateProvider provider) {
            this.endBlockProvider = provider != null ? provider : this.blockProvider;
            return this;
        }

        public Builder setMinLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder setMaxLength(int maxPossibleHeight) {
            this.maxLength = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder setPlacementFilter(BlockPredicate placementFilter) {
            this.placementFilter = placementFilter;
            return this;
        }

        public Builder copy(HangingColumnWithBaseConfig config) {
            this.baseBlockProvider = config.baseBlockProvider;
            this.blockProvider = config.blockProvider;
            this.endBlockProvider = config.endBlockProvider;
            this.minLength = config.minLength;
            this.maxLength = config.maxLength;
            this.placementFilter = config.placementFilter;
            return this;
        }

        public HangingColumnWithBaseConfig build() {
            return new HangingColumnWithBaseConfig(this.baseBlockProvider, this.blockProvider, this.endBlockProvider, this.minLength, this.maxLength, this.placementFilter);
        }
    }
}

