/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.feature.config.RadiusMatcher;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class NoiseSphere
extends Feature<NoisySphereConfig> {
    protected static FastNoise fastNoise;
    protected long seed;

    public NoiseSphere(Codec<NoisySphereConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoisySphereConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (NoisySphereConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, RandomSource random, BlockPos position, NoisySphereConfig config) {
        this.setSeed(world.m_7328_(), config.noiseFrequency());
        boolean use2D = random.m_188500_() < config.noise2DChance();
        RadiusMatcher radiusMatcher = config.radiusMatcher();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position);
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable);
        NoisySphereConfig.RadiusSettings radiusSettings = config.radiusSettings();
        int xRadius = radiusSettings.xRadius().m_214085_(random) / 2;
        int yRadius = radiusMatcher == RadiusMatcher.ALL ? xRadius : radiusSettings.yRadius().m_214085_(random);
        int zRadius = radiusMatcher == RadiusMatcher.ALL || radiusMatcher == RadiusMatcher.XZ ? xRadius : radiusSettings.zRadius().m_214085_(random) / 2;
        int lowestX = position.m_123341_();
        int lowestY = position.m_123342_();
        int lowestZ = position.m_123343_();
        int stackHeight = config.stackHeight().m_214085_(random);
        for (int stackIDX = 0; stackIDX < stackHeight; ++stackIDX) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                float xFract = (float)x / (float)xRadius;
                for (int z = -zRadius; z <= zRadius; ++z) {
                    float zFract = (float)z / (float)zRadius;
                    for (int y = -yRadius; y <= yRadius + radiusSettings.upperHalfAdditional(); ++y) {
                        float yFract = (float)y / (float)yRadius;
                        mutable2.m_122190_((Vec3i)mutable).m_122184_(x, y, z);
                        float distanceSquaredFromCenter = xFract * xFract + yFract * yFract + zFract * zFract;
                        float yDistSquared = yFract * yFract;
                        float noise = use2D ? fastNoise.GetNoise(mutable2.m_123341_(), mutable2.m_123343_()) : fastNoise.GetNoise(mutable2.m_123341_(), mutable2.m_123342_(), mutable2.m_123343_());
                        float threshold = 1.0f + 0.7f * noise;
                        float factor = yDistSquared / threshold;
                        if (factor >= 1.0f) {
                            distanceSquaredFromCenter /= factor;
                            distanceSquaredFromCenter = (float)((double)distanceSquaredFromCenter - Math.copySign((double)noise * 0.2, (double)distanceSquaredFromCenter));
                        }
                        if (distanceSquaredFromCenter >= threshold) continue;
                        int squaredDistance = x * x + y * y + z * z;
                        if (config.checkSquareDistance() && squaredDistance >= xRadius * zRadius) continue;
                        world.m_7731_((BlockPos)mutable2, config.topBlockProvider().m_213972_(random, (BlockPos)mutable2), 2);
                        world.m_7731_((BlockPos)mutable2.m_122173_(Direction.DOWN), config.blockProvider().m_213972_(random, (BlockPos)mutable2), 2);
                        lowestX = Math.min(lowestX, mutable2.m_123341_());
                        lowestY = Math.min(lowestY, mutable2.m_123342_());
                        lowestZ = Math.min(lowestZ, mutable2.m_123343_());
                    }
                }
            }
            xRadius = (int)((double)xRadius / config.radiusDivisorPerStack());
            yRadius = (int)((float)yRadius * 0.1f);
            mutable.m_142448_(mutable.m_123342_() + yRadius);
            zRadius = (int)((double)zRadius / config.radiusDivisorPerStack());
        }
        for (Holder spawningFeature : config.spawningFeatures()) {
            ((PlacedFeature)spawningFeature.m_203334_()).m_226357_(world, chunkGenerator, random, new BlockPos(lowestX, lowestY, lowestZ));
        }
        return true;
    }

    public void setSeed(long seed, float noiseFreq) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Cellular);
            this.seed = seed;
        }
        fastNoise.SetFrequency(noiseFreq);
    }
}

