/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.caffeinemc.phosphor.common.util.collections.DoubleBufferedLong2ObjectHashMap;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={DataLayerStorageMap.class})
public abstract class MixinChunkToNibbleArrayMap {
    @Shadow
    private boolean f_75521_;
    @Shadow
    @Final
    private long[] f_75519_;
    @Shadow
    @Final
    private DataLayer[] f_75520_;
    @Shadow
    @Final
    protected Long2ObjectOpenHashMap<DataLayer> f_75518_;
    @Unique
    private DoubleBufferedLong2ObjectHashMap<DataLayer> queue;
    @Unique
    private boolean isShared;
    @Unique
    private boolean init;

    @Shadow
    public abstract void m_75531_();

    @Unique
    protected boolean isShared() {
        return this.isShared;
    }

    @Unique
    protected boolean isInitialized() {
        return this.init;
    }

    @Overwrite
    public void m_75524_(long pos) {
        this.checkExclusiveOwner();
        this.queue.putSync(pos, this.queue.getSync(pos).m_62569_());
        this.m_75531_();
    }

    @Overwrite
    public DataLayer m_75532_(long pos) {
        if (this.f_75521_) {
            long[] cachePositions = this.f_75519_;
            for (int i = 0; i < cachePositions.length; ++i) {
                if (pos != cachePositions[i]) continue;
                return this.f_75520_[i];
            }
        }
        return this.getUncached(pos);
    }

    @Unique
    private DataLayer getUncached(long pos) {
        DataLayer array = this.isShared ? this.queue.getAsync(pos) : this.queue.getSync(pos);
        if (array == null) {
            return null;
        }
        if (this.f_75521_) {
            long[] cachePositions = this.f_75519_;
            DataLayer[] cacheArrays = this.f_75520_;
            for (int i = cacheArrays.length - 1; i > 0; --i) {
                cachePositions[i] = cachePositions[i - 1];
                cacheArrays[i] = cacheArrays[i - 1];
            }
            cachePositions[0] = pos;
            cacheArrays[0] = array;
        }
        return array;
    }

    @Overwrite
    public void m_75526_(long pos, DataLayer data) {
        this.checkExclusiveOwner();
        this.queue.putSync(pos, data);
    }

    @Overwrite
    public DataLayer m_75535_(long chunkPos) {
        this.checkExclusiveOwner();
        return this.queue.removeSync(chunkPos);
    }

    @Overwrite
    public boolean m_75529_(long chunkPos) {
        if (this.isShared) {
            return this.queue.getAsync(chunkPos) != null;
        }
        return this.queue.containsSync(chunkPos);
    }

    @Unique
    protected void checkExclusiveOwner() {
        if (this.isShared) {
            throw new IllegalStateException("Tried to synchronously write to light data array table after it was made shareable");
        }
    }

    @Unique
    protected DoubleBufferedLong2ObjectHashMap<DataLayer> getUpdateQueue() {
        return this.queue;
    }

    protected void makeSharedCopy(DoubleBufferedLong2ObjectHashMap<DataLayer> queue) {
        this.queue = queue;
        this.isShared = true;
        this.queue.flushChangesSync();
        this.init = true;
    }

    @Unique
    protected void init() {
        if (this.init) {
            throw new IllegalStateException("Map already initialized");
        }
        this.queue = new DoubleBufferedLong2ObjectHashMap();
        this.init = true;
    }
}

