/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractMeshConsumer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.TerrainFallbackConsumer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class BlockRenderContext
extends AbstractRenderContext {
    private final BlockRenderInfo blockInfo = new BlockRenderInfo();
    private final AoCalculator aoCalc = new AoCalculator(this.blockInfo){

        @Override
        public int light(BlockPos pos, BlockState state) {
            return LevelRenderer.m_109537_((BlockAndTintGetter)this.blockInfo.blockView, (BlockState)state, (BlockPos)pos);
        }

        @Override
        public float ao(BlockPos pos, BlockState state) {
            return AoLuminanceFix.INSTANCE.apply((BlockGetter)this.blockInfo.blockView, pos, state);
        }
    };
    private VertexConsumer bufferBuilder;
    private RandomSource random;
    private long seed;
    private final Supplier<RandomSource> randomSupplier = () -> {
        this.random.m_188584_(this.seed);
        return this.random;
    };
    private final AbstractMeshConsumer meshConsumer = new AbstractMeshConsumer(this.blockInfo, this::outputBuffer, this.aoCalc, this::transform){

        @Override
        protected Matrix4f matrix() {
            return BlockRenderContext.this.matrix;
        }

        @Override
        protected Matrix3f normalMatrix() {
            return BlockRenderContext.this.normalMatrix;
        }

        @Override
        protected int overlay() {
            return BlockRenderContext.this.overlay;
        }
    };
    private final TerrainFallbackConsumer fallbackConsumer = new TerrainFallbackConsumer(this.blockInfo, this::outputBuffer, this.aoCalc, this::transform){

        @Override
        protected Matrix4f matrix() {
            return BlockRenderContext.this.matrix;
        }

        @Override
        protected Matrix3f normalMatrix() {
            return BlockRenderContext.this.normalMatrix;
        }

        @Override
        protected int overlay() {
            return BlockRenderContext.this.overlay;
        }
    };

    private VertexConsumer outputBuffer(RenderType renderLayer) {
        return this.bufferBuilder;
    }

    public void render(BlockAndTintGetter blockView, BakedModel model, BlockState state, BlockPos pos, PoseStack matrixStack, VertexConsumer buffer, boolean cull, RandomSource random, long seed, int overlay, ModelData modelData, RenderType renderType, boolean queryModelSpecificData) {
        this.bufferBuilder = buffer;
        this.matrix = matrixStack.m_85850_().m_85861_();
        this.normalMatrix = matrixStack.m_85850_().m_85864_();
        this.random = random;
        this.seed = seed;
        if (queryModelSpecificData) {
            modelData = model.getModelData(blockView, pos, state, modelData);
        }
        this.overlay = overlay;
        this.aoCalc.clear();
        this.blockInfo.prepareForWorld(blockView, cull);
        this.blockInfo.prepareForBlock(blockView, state, pos, model.m_7541_(), modelData, renderType);
        ((FabricBakedModel)model).emitBlockQuads(blockView, state, pos, this.randomSupplier, this);
        this.blockInfo.release();
        this.bufferBuilder = null;
        this.random = null;
        this.seed = seed;
    }

    @Override
    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    @Override
    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.fallbackConsumer;
    }

    @Override
    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }
}

