/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.culling;

import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IInWorldStateEntryInfo;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MCCullTest
implements ICullTest {
    private static SimpleMaxSizedCache<BlockStatePairKey, Boolean> CACHE = new SimpleMaxSizedCache(() -> IClientConfiguration.getInstance().getCullTestingCacheSize().get());

    @Override
    public boolean isVisible(IStateEntryInfo stateEntry, IBlockInformation neighbor, Direction offsetDirectory) {
        IBlockInformation aInfo = stateEntry.getBlockInformation();
        if (aInfo == neighbor) {
            return false;
        }
        if (stateEntry.getBlockInformation().getBlockState().m_60719_(neighbor.getBlockState(), offsetDirectory)) {
            return false;
        }
        if (!(aInfo instanceof IInWorldStateEntryInfo)) {
            return true;
        }
        IInWorldStateEntryInfo aBlockEntity = (IInWorldStateEntryInfo)((Object)aInfo);
        if (neighbor.getBlockState().m_60815_() && Minecraft.m_91087_().f_91073_ != null) {
            BlockPos position = new BlockPos((Vec3i)aBlockEntity.getBlockPos());
            return MCCullTest.shouldRenderFace(aInfo.getBlockState(), neighbor.getBlockState(), new BlockPos((Vec3i)aBlockEntity.getBlockPos()), offsetDirectory);
        }
        return true;
    }

    private static boolean shouldRenderFace(BlockState state, BlockState neighborState, BlockPos position, Direction offsetDirection) {
        BlockPos neighborPosition = position.m_121945_(offsetDirection);
        if (state.m_60719_(neighborState, offsetDirection)) {
            return false;
        }
        if (neighborState.m_60815_()) {
            BlockStatePairKey cacheKey = new BlockStatePairKey(state, neighborState, offsetDirection);
            return CACHE.get(cacheKey, () -> {
                VoxelShape voxelshape = state.m_60655_((BlockGetter)Minecraft.m_91087_().f_91073_, position, offsetDirection);
                if (voxelshape.m_83281_()) {
                    return true;
                }
                VoxelShape voxelshape1 = neighborState.m_60655_((BlockGetter)Minecraft.m_91087_().f_91073_, neighborPosition, offsetDirection.m_122424_());
                return Shapes.m_83157_((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (BooleanOp)BooleanOp.f_82685_);
            });
        }
        return true;
    }

    public record BlockStatePairKey(BlockState first, BlockState second, Direction direction) {
    }
}

