/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.materials;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.world.level.material.Material;

public class MaterialManager {
    private static final MaterialManager INSTANCE = new MaterialManager();
    private final Map<Material, String> materialNames = Maps.newHashMap();
    private final Multimap<String, Material> knownMaterials = HashMultimap.create();
    private final Map<Material, Material> materialRemapping = Maps.newHashMap();

    private MaterialManager() {
        this.registerMapping("wood", Material.f_76320_);
        this.registerMapping("rock", Material.f_76278_);
        this.registerMapping("iron", Material.f_76279_);
        this.registerMapping("cloth", Material.f_76299_);
        this.registerMapping("ice", Material.f_76276_);
        this.registerMapping("packed_ice", Material.f_76316_);
        this.registerMapping("clay", Material.f_76313_);
        this.registerMapping("glass", Material.f_76275_);
        this.registerMapping("sand", Material.f_76317_);
        this.registerMapping("ground", Material.f_76314_);
        this.registerMapping("grass", Material.f_76315_);
        this.registerMapping("snow", Material.f_76280_);
        this.registerMapping("fluid", Material.f_76305_);
        this.registerMapping("leaves", Material.f_76274_);
        this.registerMapping("plant", Material.f_76300_);
        this.registerMapping("wool", Material.f_76272_);
        this.registerMapping("nether_wood", Material.f_76321_);
        this.registerMapping("froglight", Material.f_230577_);
        this.registerMapping("amethyst", Material.f_164531_);
        this.registerRemapping(Material.f_76318_, Material.f_76313_);
        this.registerRemapping(Material.f_76281_, Material.f_76279_);
        this.registerRemapping(Material.f_76285_, Material.f_76300_);
        this.registerRemapping(Material.f_76277_, Material.f_76300_);
        this.registerRemapping(Material.f_76311_, Material.f_76300_);
        this.registerRemapping(Material.f_76273_, Material.f_76278_);
        this.registerRemapping(Material.f_76307_, Material.f_76305_);
        this.registerRemapping(Material.f_164530_, Material.f_76300_);
    }

    public void registerMapping(String name, Material material) {
        if (this.knownMaterials.containsKey((Object)name)) {
            throw new IllegalArgumentException(String.format("The material name: %s is already registered!", name));
        }
        this.knownMaterials.put((Object)name, (Object)material);
        this.materialNames.put(material, name);
    }

    public void registerRemapping(Material material, Material target) {
        if (this.materialRemapping.containsKey(material)) {
            throw new IllegalArgumentException("Can not remap a material twice!");
        }
        if (this.knownMaterials.containsValue((Object)material)) {
            throw new IllegalArgumentException("Can not remap a material which is registered as a working material.");
        }
        if (!this.knownMaterials.containsValue((Object)target)) {
            throw new IllegalArgumentException("Can not remap a material to a material which is not registered as a working material.");
        }
        this.materialRemapping.put(material, target);
    }

    public static MaterialManager getInstance() {
        return INSTANCE;
    }

    public Multimap<String, Material> getKnownMaterials() {
        return this.knownMaterials;
    }

    public Map<Material, String> getMaterialNames() {
        return this.materialNames;
    }

    public Material remapMaterialIfNeeded(Material material) {
        return this.materialRemapping.getOrDefault(material, material);
    }

    public Material getDefaultMaterial() {
        return Material.f_76278_;
    }
}

