/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.inventory.InventoryScannerMenu;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class InventoryScannerScreen
extends AbstractContainerScreen<InventoryScannerMenu> {
    private static final ResourceLocation REGULAR_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_gui.png");
    private static final ResourceLocation ENHANCED_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_enhanced_gui.png");
    public final InventoryScannerBlockEntity be;
    private boolean owns = false;
    private boolean hasRedstoneModule = false;
    private boolean hasStorageModule = false;
    private Component infoStringRedstone;
    private Component infoStringStorage;
    private static final Style UNDERLINE = Style.f_131099_.m_131157_(ChatFormatting.UNDERLINE);
    private final Component prohibitedItems = Utils.localize("gui.securitycraft:invScan.prohibitedItems", new Object[0]);
    private final Component adminMode = Utils.localize("gui.securitycraft:invScan.mode.admin", new Object[0]).m_6270_(UNDERLINE);
    private final Component viewMode = Utils.localize("gui.securitycraft:invScan.mode.view", new Object[0]).m_6270_(UNDERLINE);
    private final Component storage = Utils.localize("gui.securitycraft:invScan.storage", new Object[0]);
    private Component redstoneModuleTooltip = null;
    private Component storageModuleTooltip = null;

    public InventoryScannerScreen(InventoryScannerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.be = menu.be;
        this.owns = this.be.isOwnedBy(inv.f_35978_);
        this.hasRedstoneModule = this.be.isModuleEnabled(ModuleType.REDSTONE);
        this.hasStorageModule = this.be.isModuleEnabled(ModuleType.STORAGE);
        this.infoStringRedstone = Utils.localize("gui.securitycraft:invScan.emit_redstone", Utils.localize("gui.securitycraft:invScan." + (this.hasRedstoneModule ? "yes" : "no"), new Object[0]));
        this.infoStringStorage = Utils.localize("gui.securitycraft:invScan.check_inv", Utils.localize("gui.securitycraft:invScan." + (this.hasStorageModule ? "yes" : "no"), new Object[0]));
        if (!this.hasRedstoneModule) {
            this.redstoneModuleTooltip = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(((ModuleItem)((Object)SCContent.REDSTONE_MODULE.get())).m_5524_(), new Object[0]));
        }
        if (this.hasStorageModule) {
            this.f_97726_ = 246;
        } else {
            this.f_97726_ = 190;
            this.storageModuleTooltip = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(((ModuleItem)((Object)SCContent.STORAGE_MODULE.get())).m_5524_(), new Object[0]));
        }
        this.f_97727_ = 196;
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92857_((FormattedText)this.infoStringRedstone, this.f_97735_ + 28, this.f_97736_ + 45, 150, 0x404040);
        this.f_96547_.m_92857_((FormattedText)this.infoStringStorage, this.f_97735_ + 28, this.f_97736_ + 75, 150, 0x404040);
        ClientUtils.renderModuleInfo(pose, ModuleType.REDSTONE, this.redstoneModuleTooltip, this.hasRedstoneModule, this.f_97735_ + 8, this.f_97736_ + 45, this.f_96543_, this.f_96544_, mouseX, mouseY);
        ClientUtils.renderModuleInfo(pose, ModuleType.STORAGE, this.storageModuleTooltip, this.hasStorageModule, this.f_97735_ + 8, this.f_97736_ + 75, this.f_96543_, this.f_96544_, mouseX, mouseY);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().m_7993_().m_41619_()) {
            this.m_6057_(pose, this.getSlotUnderMouse().m_7993_(), mouseX, mouseY);
        }
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(pose, this.prohibitedItems, 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(pose, this.be.isOwnedBy((Player)this.f_96541_.f_91074_) ? this.adminMode : this.viewMode, 112.0f, 6.0f, 0x404040);
        if (this.hasStorageModule && this.owns) {
            this.f_96547_.m_92889_(pose, this.storage, 188.0f, 18.0f, 0x404040);
        }
        this.f_96547_.m_92889_(pose, Utils.INVENTORY_TEXT, 15.0f, (float)(this.f_97727_ - 93), 0x404040);
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)(this.hasStorageModule && this.owns ? ENHANCED_INVENTORY : REGULAR_INVENTORY));
        this.m_93228_(pose, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_ + 30);
    }
}

