/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.util;

import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5423;
import net.minecraft.class_7225;
import net.minecraft.class_7887;
import virtuoel.no_fog.NoFogClient;
import virtuoel.no_fog.util.FogToggles;
import virtuoel.no_fog.util.ReflectionUtils;
import virtuoel.no_fog.util.VersionUtils;

public class ConfigUtils {
    private static Object dimensionTypeRegistryWrapper = null;
    private static Object biomeRegistryWrapper = null;

    public static Map<String, FogToggles> populateDimensionToggles(Map<String, FogToggles> data) {
        LinkedList<String> ids = new LinkedList<String>();
        try {
            class_310 client = class_310.method_1551();
            if (client != null && client.field_1687 != null) {
                class_2378<class_2874> registry = ReflectionUtils.getDynamicRegistry((class_5423)client.field_1687, ReflectionUtils.DIMENSION_TYPE_KEY);
                ReflectionUtils.getIds(registry).stream().map(class_2960::toString).sorted().forEach(ids::add);
            }
        }
        catch (Throwable e) {
            NoFogClient.LOGGER.catching(e);
        }
        if (ids.isEmpty()) {
            try {
                if (VersionUtils.MINOR < 19 || VersionUtils.MINOR == 19 && VersionUtils.PATCH <= 2) {
                    ids.add(class_1937.field_25179.method_29177().toString());
                    ids.add(class_1937.field_25180.method_29177().toString());
                    ids.add(class_1937.field_25181.method_29177().toString());
                } else {
                    if (dimensionTypeRegistryWrapper == null) {
                        dimensionTypeRegistryWrapper = class_7887.method_46817().method_46762(ReflectionUtils.DIMENSION_TYPE_KEY);
                    }
                    ((class_7225)dimensionTypeRegistryWrapper).method_46754().map(class_5321::method_29177).map(class_2960::toString).sorted().forEach(ids::add);
                }
            }
            catch (Throwable e) {
                NoFogClient.LOGGER.catching(e);
            }
        }
        for (String id : ids) {
            data.computeIfAbsent(id, xva$0 -> new FogToggles(xva$0));
        }
        return data;
    }

    public static Map<String, FogToggles> populateBiomeToggles(Map<String, FogToggles> data) {
        LinkedList ids = new LinkedList();
        try {
            class_310 client = class_310.method_1551();
            if (client != null && client.field_1687 != null) {
                class_2378<class_1959> registry = ReflectionUtils.getDynamicRegistry((class_5423)client.field_1687, ReflectionUtils.BIOME_KEY);
                ids.addAll(ReflectionUtils.getIds(registry).stream().map(class_2960::toString).sorted().collect(Collectors.toList()));
            }
        }
        catch (Throwable e) {
            NoFogClient.LOGGER.catching(e);
        }
        if (ids.isEmpty()) {
            try {
                if (ReflectionUtils.BUILTIN_BIOME_REGISTRY != null) {
                    ReflectionUtils.getIds(ReflectionUtils.BUILTIN_BIOME_REGISTRY).stream().map(class_2960::toString).sorted().forEach(ids::add);
                } else {
                    if (biomeRegistryWrapper == null) {
                        biomeRegistryWrapper = class_7887.method_46817().method_46762(ReflectionUtils.BIOME_KEY);
                    }
                    ((class_7225)biomeRegistryWrapper).method_46754().map(class_5321::method_29177).map(class_2960::toString).sorted().forEach(ids::add);
                }
            }
            catch (Throwable e) {
                NoFogClient.LOGGER.catching(e);
            }
        }
        for (String id : ids) {
            data.computeIfAbsent(id, xva$0 -> new FogToggles(xva$0));
        }
        return data;
    }
}

