/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.buffer_builder.intrinsics;

import me.jellysquid.mods.sodium.client.render.RenderGlobal;
import me.jellysquid.mods.sodium.client.render.vertex.VertexBufferWriter;
import me.jellysquid.mods.sodium.client.render.vertex.formats.ModelVertex;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.common.util.MatrixHelper;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_898;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={class_898.class})
public class MixinEntityRenderDispatcher {
    private static final int SHADOW_COLOR = ColorABGR.pack(1.0f, 1.0f, 1.0f);

    @Overwrite
    private static void method_23163(class_4587.class_4665 entry, class_4588 vertices, class_4538 world, class_2338 pos, double x, double y, double z, float radius, float opacity) {
        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_26217() == class_2464.field_11455 || !blockState.method_26234((class_1922)world, blockPos)) {
            return;
        }
        int light = world.method_22339(pos);
        if (light <= 3) {
            return;
        }
        class_265 voxelShape = blockState.method_26218((class_1922)world, blockPos);
        if (voxelShape.method_1110()) {
            return;
        }
        float brightness = class_765.method_23284((class_2874)world.method_8597(), (int)light);
        float alpha = (float)(((double)opacity - (y - (double)pos.method_10264()) / 2.0) * 0.5 * (double)brightness);
        if (alpha >= 0.0f) {
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            class_238 box = voxelShape.method_1107();
            float minX = (float)((double)pos.method_10263() + box.field_1323 - x);
            float maxX = (float)((double)pos.method_10263() + box.field_1320 - x);
            float minY = (float)((double)pos.method_10264() + box.field_1322 - y);
            float minZ = (float)((double)pos.method_10260() + box.field_1321 - z);
            float maxZ = (float)((double)pos.method_10260() + box.field_1324 - z);
            MixinEntityRenderDispatcher.renderShadowPart(entry, vertices, radius, alpha, minX, maxX, minY, minZ, maxZ);
        }
    }

    private static void renderShadowPart(class_4587.class_4665 matrices, class_4588 vertices, float radius, float alpha, float minX, float maxX, float minY, float minZ, float maxZ) {
        float size = 0.5f * (1.0f / radius);
        float u1 = -minX * size + 0.5f;
        float u2 = -maxX * size + 0.5f;
        float v1 = -minZ * size + 0.5f;
        float v2 = -maxZ * size + 0.5f;
        Matrix3f matNormal = matrices.method_23762();
        Matrix4f matPosition = matrices.method_23761();
        int color = ColorABGR.withAlpha(SHADOW_COLOR, alpha);
        int normal = MatrixHelper.transformNormal(matNormal, 0.0f, 1.0f, 0.0f);
        try (MemoryStack stack = RenderGlobal.VERTEX_DATA.push();){
            long buffer;
            long ptr = buffer = stack.nmalloc(144);
            MixinEntityRenderDispatcher.writeShadowVertex(ptr, matPosition, minX, minY, minZ, u1, v1, color, normal);
            MixinEntityRenderDispatcher.writeShadowVertex(ptr += 36L, matPosition, minX, minY, maxZ, u1, v2, color, normal);
            MixinEntityRenderDispatcher.writeShadowVertex(ptr += 36L, matPosition, maxX, minY, maxZ, u2, v2, color, normal);
            MixinEntityRenderDispatcher.writeShadowVertex(ptr += 36L, matPosition, maxX, minY, minZ, u2, v1, color, normal);
            ptr += 36L;
            VertexBufferWriter.of(vertices).push(stack, buffer, 4, ModelVertex.FORMAT);
        }
    }

    private static void writeShadowVertex(long ptr, Matrix4f matPosition, float x, float y, float z, float u, float v, int color, int normal) {
        float xt = MatrixHelper.transformPositionX(matPosition, x, y, z);
        float yt = MatrixHelper.transformPositionY(matPosition, x, y, z);
        float zt = MatrixHelper.transformPositionZ(matPosition, x, y, z);
        ModelVertex.write(ptr, xt, yt, zt, color, u, v, class_4608.field_21444, 0xF000F0, normal);
    }
}

