/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.villager;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class VillagerData {
    private final UUID uuid;
    private final IntArrayList favorites = new IntArrayList();
    private int tradeListPosition;

    VillagerData(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getTradeListPosition() {
        return this.tradeListPosition;
    }

    void setTradeListPosition(int position) {
        this.tradeListPosition = position;
    }

    void toggleFavorite(int tradeIndex) {
        if (this.favorites.contains(tradeIndex)) {
            this.favorites.rem(tradeIndex);
        } else {
            this.favorites.add(tradeIndex);
        }
    }

    IntArrayList getFavorites() {
        return this.favorites;
    }

    public class_2487 toNBT() {
        class_2487 tag = new class_2487();
        tag.method_10544("UUIDM", this.uuid.getMostSignificantBits());
        tag.method_10544("UUIDL", this.uuid.getLeastSignificantBits());
        tag.method_10569("ListPosition", this.tradeListPosition);
        class_2499 tagList = new class_2499();
        for (Integer val : this.favorites) {
            tagList.add((Object)class_2497.method_23247((int)val));
        }
        tag.method_10566("Favorites", (class_2520)tagList);
        return tag;
    }

    @Nullable
    public static VillagerData fromNBT(class_2487 tag) {
        if (tag.method_10573("UUIDM", 4) && tag.method_10573("UUIDL", 4)) {
            VillagerData data = new VillagerData(new UUID(tag.method_10537("UUIDM"), tag.method_10537("UUIDL")));
            class_2499 tagList = tag.method_10554("Favorites", 3);
            int count = tagList.size();
            data.favorites.clear();
            data.tradeListPosition = tag.method_10550("ListPosition");
            for (int i = 0; i < count; ++i) {
                data.favorites.add(tagList.method_10600(i));
            }
            return data;
        }
        return null;
    }
}

