/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl;

import java.io.PrintStream;
import java.util.function.Consumer;
import net.coderbot.iris.Iris;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageAMDCallback;
import org.lwjgl.opengl.GLDebugMessageAMDCallbackI;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.APIUtil;

public final class GLDebug {
    private static DebugState debugState;

    public static int setupDebugMessageCallback() {
        return GLDebug.setupDebugMessageCallback(APIUtil.DEBUG_STREAM);
    }

    private static void trace(Consumer<String> consumer) {
        StackTraceElement[] stackTraceElementArray;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = GLDebug.filterStackTrace(new Throwable(), 4).getStackTrace()) {
            consumer.accept(stackTraceElement.toString());
        }
    }

    public static Throwable filterStackTrace(Throwable throwable, int n) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length];
        int n2 = 0;
        for (int i = n; i < stackTraceElementArray.length; ++i) {
            String string = stackTraceElementArray[i].getClassName();
            if (string == null) {
                string = "";
            }
            stackTraceElementArray2[n2++] = stackTraceElementArray[i];
        }
        StackTraceElement[] stackTraceElementArray3 = new StackTraceElement[n2];
        System.arraycopy(stackTraceElementArray2, 0, stackTraceElementArray3, 0, n2);
        throwable.setStackTrace(stackTraceElementArray3);
        return throwable;
    }

    private static void printTrace(final PrintStream printStream) {
        GLDebug.trace(new Consumer<String>(){
            boolean first = true;

            @Override
            public void accept(String string) {
                if (this.first) {
                    GLDebug.printDetail(printStream, "Stacktrace", string);
                    this.first = false;
                } else {
                    GLDebug.printDetailLine(printStream, "Stacktrace", string);
                }
            }
        });
    }

    public static int setupDebugMessageCallback(PrintStream printStream) {
        GLCapabilities gLCapabilities = GL.getCapabilities();
        if (gLCapabilities.OpenGL43) {
            Iris.logger.info("[GL] Using OpenGL 4.3 for error logging.");
            GLDebugMessageCallback gLDebugMessageCallback = GLDebugMessageCallback.create((n, n2, n3, n4, n5, l, l2) -> {
                printStream.println("[LWJGL] OpenGL debug message");
                GLDebug.printDetail(printStream, "ID", String.format("0x%X", n3));
                GLDebug.printDetail(printStream, "Source", GLDebug.getDebugSource(n));
                GLDebug.printDetail(printStream, "Type", GLDebug.getDebugType(n2));
                GLDebug.printDetail(printStream, "Severity", GLDebug.getDebugSeverity(n4));
                GLDebug.printDetail(printStream, "Message", GLDebugMessageCallback.getMessage((int)n5, (long)l));
                GLDebug.printTrace(printStream);
            });
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)37190, (int[])null, (boolean)true);
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)37191, (int[])null, (boolean)false);
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)37192, (int[])null, (boolean)false);
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)33387, (int[])null, (boolean)false);
            GL43C.glDebugMessageCallback((GLDebugMessageCallbackI)gLDebugMessageCallback, (long)0L);
            if ((GL43C.glGetInteger((int)33310) & 2) == 0) {
                Iris.logger.warn("[GL] Warning: A non-debug context may not produce any debug output.");
                GL43C.glEnable((int)37600);
                return 2;
            }
            return 1;
        }
        if (gLCapabilities.GL_KHR_debug) {
            Iris.logger.info("[GL] Using KHR_debug for error logging.");
            GLDebugMessageCallback gLDebugMessageCallback = GLDebugMessageCallback.create((n, n2, n3, n4, n5, l, l2) -> {
                printStream.println("[LWJGL] OpenGL debug message");
                GLDebug.printDetail(printStream, "ID", String.format("0x%X", n3));
                GLDebug.printDetail(printStream, "Source", GLDebug.getDebugSource(n));
                GLDebug.printDetail(printStream, "Type", GLDebug.getDebugType(n2));
                GLDebug.printDetail(printStream, "Severity", GLDebug.getDebugSeverity(n4));
                GLDebug.printDetail(printStream, "Message", GLDebugMessageCallback.getMessage((int)n5, (long)l));
                GLDebug.printTrace(printStream);
            });
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37190, (int[])null, (boolean)true);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37191, (int[])null, (boolean)false);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37192, (int[])null, (boolean)false);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)33387, (int[])null, (boolean)false);
            KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)gLDebugMessageCallback, (long)0L);
            if (gLCapabilities.OpenGL30 && (GL43C.glGetInteger((int)33310) & 2) == 0) {
                Iris.logger.warn("[GL] Warning: A non-debug context may not produce any debug output.");
                GL43C.glEnable((int)37600);
                return 2;
            }
            return 1;
        }
        if (gLCapabilities.GL_ARB_debug_output) {
            Iris.logger.info("[GL] Using ARB_debug_output for error logging.");
            GLDebugMessageARBCallback gLDebugMessageARBCallback = GLDebugMessageARBCallback.create((n, n2, n3, n4, n5, l, l2) -> {
                printStream.println("[LWJGL] ARB_debug_output message");
                GLDebug.printDetail(printStream, "ID", String.format("0x%X", n3));
                GLDebug.printDetail(printStream, "Source", GLDebug.getSourceARB(n));
                GLDebug.printDetail(printStream, "Type", GLDebug.getTypeARB(n2));
                GLDebug.printDetail(printStream, "Severity", GLDebug.getSeverityARB(n4));
                GLDebug.printDetail(printStream, "Message", GLDebugMessageARBCallback.getMessage((int)n5, (long)l));
                GLDebug.printTrace(printStream);
            });
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37190, (int[])null, (boolean)true);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37191, (int[])null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37192, (int[])null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)33387, (int[])null, (boolean)false);
            ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)gLDebugMessageARBCallback, (long)0L);
            return 1;
        }
        if (gLCapabilities.GL_AMD_debug_output) {
            Iris.logger.info("[GL] Using AMD_debug_output for error logging.");
            GLDebugMessageAMDCallback gLDebugMessageAMDCallback = GLDebugMessageAMDCallback.create((n, n2, n3, n4, l, l2) -> {
                printStream.println("[LWJGL] AMD_debug_output message");
                GLDebug.printDetail(printStream, "ID", String.format("0x%X", n));
                GLDebug.printDetail(printStream, "Category", GLDebug.getCategoryAMD(n2));
                GLDebug.printDetail(printStream, "Severity", GLDebug.getSeverityAMD(n3));
                GLDebug.printDetail(printStream, "Message", GLDebugMessageAMDCallback.getMessage((int)n4, (long)l));
                GLDebug.printTrace(printStream);
            });
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37190, (int[])null, (boolean)true);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37191, (int[])null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37192, (int[])null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)33387, (int[])null, (boolean)false);
            AMDDebugOutput.glDebugMessageCallbackAMD((GLDebugMessageAMDCallbackI)gLDebugMessageAMDCallback, (long)0L);
            return 1;
        }
        Iris.logger.info("[GL] No debug output implementation is available, cannot return debug info.");
        return 0;
    }

    public static int disableDebugMessages() {
        GLCapabilities gLCapabilities = GL.getCapabilities();
        if (gLCapabilities.OpenGL43) {
            GL43C.glDebugMessageCallback(null, (long)0L);
            return 1;
        }
        if (gLCapabilities.GL_KHR_debug) {
            KHRDebug.glDebugMessageCallback(null, (long)0L);
            if (gLCapabilities.OpenGL30 && (GL43C.glGetInteger((int)33310) & 2) == 0) {
                GL43C.glDisable((int)37600);
            }
            return 1;
        }
        if (gLCapabilities.GL_ARB_debug_output) {
            ARBDebugOutput.glDebugMessageCallbackARB(null, (long)0L);
            return 1;
        }
        if (gLCapabilities.GL_AMD_debug_output) {
            AMDDebugOutput.glDebugMessageCallbackAMD(null, (long)0L);
            return 1;
        }
        Iris.logger.info("[GL] No debug output implementation is available, cannot disable debug info.");
        return 0;
    }

    private static void printDetail(PrintStream printStream, String string, String string2) {
        printStream.printf("\t%s: %s\n", string, string2);
    }

    private static void printDetailLine(PrintStream printStream, String string, String string2) {
        printStream.append("    ");
        for (int i = 0; i < string.length(); ++i) {
            printStream.append(" ");
        }
        printStream.append(string2).append("\n");
    }

    private static String getDebugSource(int n) {
        switch (n) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken((int)n);
    }

    private static String getDebugType(int n) {
        switch (n) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return APIUtil.apiUnknownToken((int)n);
    }

    private static String getDebugSeverity(int n) {
        switch (n) {
            case 33387: {
                return "NOTIFICATION";
            }
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return APIUtil.apiUnknownToken((int)n);
    }

    private static String getSourceARB(int n) {
        switch (n) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken((int)n);
    }

    private static String getTypeARB(int n) {
        switch (n) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken((int)n);
    }

    private static String getSeverityARB(int n) {
        switch (n) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return APIUtil.apiUnknownToken((int)n);
    }

    private static String getCategoryAMD(int n) {
        switch (n) {
            case 37193: {
                return "API ERROR";
            }
            case 37194: {
                return "WINDOW SYSTEM";
            }
            case 37195: {
                return "DEPRECATION";
            }
            case 37196: {
                return "UNDEFINED BEHAVIOR";
            }
            case 37197: {
                return "PERFORMANCE";
            }
            case 37198: {
                return "SHADER COMPILER";
            }
            case 37199: {
                return "APPLICATION";
            }
            case 37200: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken((int)n);
    }

    private static String getSeverityAMD(int n) {
        switch (n) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return APIUtil.apiUnknownToken((int)n);
    }

    public static void initRenderer() {
        debugState = GL.getCapabilities().GL_KHR_debug || GL.getCapabilities().OpenGL43 ? new KHRDebugState() : new UnsupportedDebugState();
    }

    public static void nameObject(int n, int n2, String string) {
        debugState.nameObject(n, n2, string);
    }

    private static class KHRDebugState
    implements DebugState {
        private boolean hasGroup;

        private KHRDebugState() {
        }

        @Override
        public void nameObject(int n, int n2, String string) {
            KHRDebug.glObjectLabel((int)n, (int)n2, (CharSequence)string);
        }

        @Override
        public void pushGroup(int n, String string) {
            KHRDebug.glPushDebugGroup((int)33354, (int)n, (CharSequence)string);
            this.hasGroup = true;
        }

        @Override
        public void popGroup() {
            if (this.hasGroup) {
                KHRDebug.glPopDebugGroup();
                this.hasGroup = false;
            }
        }
    }

    private static interface DebugState {
        public void nameObject(int var1, int var2, String var3);

        public void pushGroup(int var1, String var2);

        public void popGroup();
    }

    private static class UnsupportedDebugState
    implements DebugState {
        private UnsupportedDebugState() {
        }

        @Override
        public void nameObject(int n, int n2, String string) {
        }

        @Override
        public void pushGroup(int n, String string) {
        }

        @Override
        public void popGroup() {
        }
    }
}

