/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.sampler;

import java.util.function.IntSupplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.texture.TextureType;

public class SamplerBinding {
    private final int textureUnit;
    private final IntSupplier texture;
    private final ValueUpdateNotifier notifier;
    private final TextureType textureType;

    public SamplerBinding(TextureType textureType, int n, IntSupplier intSupplier, ValueUpdateNotifier valueUpdateNotifier) {
        this.textureType = textureType;
        this.textureUnit = n;
        this.texture = intSupplier;
        this.notifier = valueUpdateNotifier;
    }

    public void update() {
        this.updateSampler();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateSampler);
        }
    }

    private void updateSampler() {
        IrisRenderSystem.bindTextureToUnit(this.textureType.getGlType(), this.textureUnit, this.texture.getAsInt());
    }
}

