/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform.transformer;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinFixedTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.shaderpack.texture.TextureStage;

public class TextureTransformer {
    public static void transform(ASTParser aSTParser, TranslationUnit translationUnit, Root root, TextureStage textureStage, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        object2ObjectMap.forEach((tri, string) -> {
            if (tri.getThird() == textureStage) {
                String string2 = (String)tri.getFirst();
                for (Identifier identifier : root.identifierIndex.get(string2)) {
                    TypeSpecifier typeSpecifier;
                    DeclarationExternalDeclaration declarationExternalDeclaration;
                    TypeAndInitDeclaration typeAndInitDeclaration = (TypeAndInitDeclaration)identifier.getAncestor(2, 0, TypeAndInitDeclaration.class::isInstance);
                    if (typeAndInitDeclaration == null || (declarationExternalDeclaration = (DeclarationExternalDeclaration)typeAndInitDeclaration.getAncestor(1, 0, DeclarationExternalDeclaration.class::isInstance)) == null || !((typeSpecifier = typeAndInitDeclaration.getType().getTypeSpecifier()) instanceof BuiltinFixedTypeSpecifier)) continue;
                    BuiltinFixedTypeSpecifier builtinFixedTypeSpecifier = (BuiltinFixedTypeSpecifier)typeSpecifier;
                    if (!TextureTransformer.isTypeValid((TextureType)((Object)((Object)tri.getSecond())), builtinFixedTypeSpecifier.type)) continue;
                    root.rename((String)tri.getFirst(), string);
                    break;
                }
            }
        });
    }

    private static boolean isTypeValid(TextureType textureType, BuiltinFixedTypeSpecifier.BuiltinType builtinType) {
        if (textureType == TextureType.TEXTURE_1D) {
            return builtinType == BuiltinFixedTypeSpecifier.BuiltinType.SAMPLER1D || builtinType == BuiltinFixedTypeSpecifier.BuiltinType.ISAMPLER1D || builtinType == BuiltinFixedTypeSpecifier.BuiltinType.USAMPLER1D;
        }
        if (textureType == TextureType.TEXTURE_2D) {
            return builtinType == BuiltinFixedTypeSpecifier.BuiltinType.SAMPLER2D || builtinType == BuiltinFixedTypeSpecifier.BuiltinType.ISAMPLER2D || builtinType == BuiltinFixedTypeSpecifier.BuiltinType.USAMPLER2D;
        }
        if (textureType == TextureType.TEXTURE_3D) {
            return builtinType == BuiltinFixedTypeSpecifier.BuiltinType.SAMPLER3D || builtinType == BuiltinFixedTypeSpecifier.BuiltinType.ISAMPLER3D || builtinType == BuiltinFixedTypeSpecifier.BuiltinType.USAMPLER3D;
        }
        throw new IllegalStateException("Unexpected enum! " + textureType);
    }
}

