/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collections;
import java.util.List;

public class GuiConfigs
extends GuiConfigsBase {
    private static ConfigGuiTab tab = ConfigGuiTab.GENERIC;

    public GuiConfigs() {
        super(10, 50, "itemscroller", null, "itemscroller.gui.title.configs", new Object[0]);
    }

    public void initGui() {
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        for (ConfigGuiTab tab : ConfigGuiTab.VALUES) {
            x += this.createButton(x, y, -1, tab);
        }
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(GuiConfigs.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListener(tab, this));
        return button.getWidth() + 2;
    }

    protected int getConfigWidth() {
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC || tab == ConfigGuiTab.TOGGLES) {
            return 100;
        }
        return super.getConfigWidth();
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        Object configs;
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            configs = Configs.Generic.OPTIONS;
        } else if (tab == ConfigGuiTab.TOGGLES) {
            configs = Configs.Toggles.OPTIONS;
        } else if (tab == ConfigGuiTab.HOTKEYS) {
            configs = Hotkeys.HOTKEY_LIST;
        } else {
            return Collections.emptyList();
        }
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    public static enum ConfigGuiTab {
        GENERIC("itemscroller.gui.button.config_gui.generic"),
        TOGGLES("itemscroller.gui.button.config_gui.toggles"),
        HOTKEYS("itemscroller.gui.button.config_gui.hotkeys");

        private final String translationKey;
        public static final ImmutableList<ConfigGuiTab> VALUES;

        private ConfigGuiTab(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])ConfigGuiTab.values());
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final GuiConfigs parent;
        private final ConfigGuiTab tab;

        public ButtonListener(ConfigGuiTab tab, GuiConfigs parent) {
            this.tab = tab;
            this.parent = parent;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            this.parent.reCreateListWidget();
            ((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
            this.parent.initGui();
        }
    }
}

