/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkEventFiringHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public class FMLEventChannel {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private EventBus eventBus;
    private static EventFactory factory = FMLCommonHandler.instance().getSide() == Side.CLIENT ? EventFactory.CLIENT : EventFactory.SERVER;

    FMLEventChannel(String name) {
        this.channels = NetworkRegistry.INSTANCE.newChannel(name, new ChannelHandler[]{new NetworkEventFiringHandler(this)});
        this.eventBus = new EventBus();
    }

    public void register(Object object) {
        this.eventBus.register(object);
    }

    public void unregister(Object object) {
        this.eventBus.unregister(object);
    }

    void fireRead(FMLProxyPacket msg, ChannelHandlerContext ctx) {
        FMLNetworkEvent.CustomPacketEvent<?> event = factory.make(msg);
        if (event != null) {
            this.eventBus.post(event);
            if (event.reply != null) {
                ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.REPLY);
                ctx.writeAndFlush((Object)event.reply).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            }
        }
    }

    public void fireUserEvent(Object evt, ChannelHandlerContext ctx) {
        FMLNetworkEvent.CustomNetworkEvent event = new FMLNetworkEvent.CustomNetworkEvent(evt);
        this.eventBus.post(event);
    }

    public void sendToAll(FMLProxyPacket pkt) {
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get((Object)Side.SERVER).writeAndFlush(pkt).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(FMLProxyPacket pkt, lf player) {
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get((Object)Side.SERVER).writeAndFlush(pkt).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(FMLProxyPacket pkt, NetworkRegistry.TargetPoint point) {
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get((Object)Side.SERVER).writeAndFlush(pkt).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(FMLProxyPacket pkt, int dimensionId) {
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get((Object)Side.SERVER).writeAndFlush(pkt).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(FMLProxyPacket pkt) {
        this.channels.get((Object)Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get((Object)Side.CLIENT).writeAndFlush(pkt).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    private static enum EventFactory {
        SERVER{

            @Override
            FMLNetworkEvent.CustomPacketEvent<?> make(FMLProxyPacket msg) {
                FMLNetworkEvent.ServerCustomPacketEvent event = null;
                if (msg.handler() instanceof lm) {
                    lm server = (lm)msg.handler();
                    event = new FMLNetworkEvent.ServerCustomPacketEvent(server.a(), msg);
                }
                return event;
            }
        }
        ,
        CLIENT{

            @Override
            FMLNetworkEvent.CustomPacketEvent<?> make(FMLProxyPacket msg) {
                FMLNetworkEvent.CustomPacketEvent event = null;
                if (msg.handler() instanceof bcy) {
                    bcy client = (bcy)msg.handler();
                    event = new FMLNetworkEvent.ClientCustomPacketEvent(client.a(), msg);
                } else if (msg.handler() instanceof lm) {
                    lm server = (lm)msg.handler();
                    event = new FMLNetworkEvent.ServerCustomPacketEvent(server.a(), msg);
                }
                return event;
            }
        };


        abstract FMLNetworkEvent.CustomPacketEvent<?> make(FMLProxyPacket var1);
    }
}

