/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.hooks;

import club.sk1er.patcher.config.PatcherConfig;
import com.google.common.collect.Queues;
import gg.essential.universal.ChatColor;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;

public class GuiNewChatHook {
    public static final Deque<IChatComponent> messageQueue = Queues.newArrayDeque();
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static long lastMessageAddedTime = 0L;

    public static void processMessageQueue() {
        long currentTime;
        if (!messageQueue.isEmpty() && (currentTime = System.currentTimeMillis()) - lastMessageAddedTime >= GuiNewChatHook.getChatDelayMillis()) {
            GuiNewChatHook.mc.field_71456_v.func_146158_b().func_146227_a(messageQueue.remove());
            lastMessageAddedTime = currentTime;
        }
    }

    public static void queueMessage(IChatComponent message) {
        if ((double)PatcherConfig.chatDelay <= 0.0) {
            GuiNewChatHook.mc.field_71456_v.func_146158_b().func_146227_a(message);
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastMessageAddedTime >= GuiNewChatHook.getChatDelayMillis()) {
                GuiNewChatHook.mc.field_71456_v.func_146158_b().func_146227_a(message);
                lastMessageAddedTime = currentTime;
            } else {
                messageQueue.add(message);
            }
        }
    }

    public static void drawMessageQueue() {
        int chatWidth = MathHelper.func_76123_f((float)((float)GuiNewChatHook.mc.field_71456_v.func_146158_b().func_146228_f() / GuiNewChatHook.mc.field_71456_v.func_146158_b().func_146244_h()));
        if (!messageQueue.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
            if (!PatcherConfig.transparentChat) {
                Gui.func_73734_a((int)0, (int)0, (int)(chatWidth + 4), (int)9, (int)0x7F000000);
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
            GuiNewChatHook.mc.field_71466_p.func_175063_a(ChatColor.GRAY + "[+" + messageQueue.size() + " pending lines]", 0.0f, 1.0f, -1);
            GlStateManager.func_179121_F();
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
        }
    }

    public static void mouseClicked() {
        if (!messageQueue.isEmpty()) {
            GuiNewChatHook.mc.field_71456_v.func_146158_b().func_146227_a(messageQueue.remove());
            lastMessageAddedTime = System.currentTimeMillis();
        }
    }

    public static void processChatMessage(S02PacketChat packet, IChatComponent message) {
        if (packet.func_179841_c() == 0) {
            GuiNewChatHook.queueMessage(message);
        } else if (packet.func_179841_c() == 1) {
            GuiNewChatHook.mc.field_71456_v.func_146158_b().func_146227_a(message);
        }
    }

    private static long getChatDelayMillis() {
        return (long)((double)PatcherConfig.chatDelay * 1000.0);
    }
}

