/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.minemark;

import dev.dediamondpro.minemark.MineMarkCore;
import dev.dediamondpro.minemark.elements.Elements;
import dev.dediamondpro.minemark.elements.creators.ElementCreator;
import dev.dediamondpro.minemark.elements.creators.TagBasedElementCreator;
import dev.dediamondpro.minemark.elements.creators.TextElementCreator;
import dev.dediamondpro.minemark.elements.formatting.FormattingElement;
import dev.dediamondpro.minemark.elements.formatting.impl.AlignmentElement;
import dev.dediamondpro.minemark.elements.formatting.impl.CssStyleElement;
import dev.dediamondpro.minemark.elements.formatting.impl.TextFormattingElement;
import dev.dediamondpro.minemark.elements.impl.LinkElement;
import dev.dediamondpro.minemark.elements.impl.ParagraphElement;
import dev.dediamondpro.minemark.elements.impl.list.ListHolderElement;
import dev.dediamondpro.minemark.elements.impl.table.TableHolderElement;
import dev.dediamondpro.minemark.elements.impl.table.TableRowElement;
import dev.dediamondpro.minemark.style.Style;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.commonmark.Extension;
import org.commonmark.renderer.html.UrlSanitizer;
import org.jetbrains.annotations.NotNull;

public class MineMarkCoreBuilder<S extends Style, R> {
    private final ArrayList<FormattingElement<S, R>> formattingElements = new ArrayList();
    private final ArrayList<ElementCreator<S, R>> elements = new ArrayList();
    private final ArrayList<Extension> extensions = new ArrayList();
    private boolean withDefaultFormattingElements = true;
    private TextElementCreator<S, R> textElement = null;
    private boolean withDefaultElements = true;
    private UrlSanitizer urlSanitizer = null;

    protected MineMarkCoreBuilder() {
    }

    public MineMarkCoreBuilder<S, R> setTextElement(@NotNull TextElementCreator<S, R> textElement) {
        this.textElement = textElement;
        return this;
    }

    public MineMarkCoreBuilder<S, R> addElement(@NotNull ElementCreator<S, R> element) {
        this.elements.add(element);
        return this;
    }

    public MineMarkCoreBuilder<S, R> addElement(@NotNull List<String> tags, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(new TagBasedElementCreator<S, R>(tags, element));
    }

    public MineMarkCoreBuilder<S, R> addElement(@NotNull String tag, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(Collections.singletonList(tag), element);
    }

    public MineMarkCoreBuilder<S, R> addElement(@NotNull Elements elementName, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(elementName.tags, element);
    }

    public MineMarkCoreBuilder<S, R> addElement(int position, @NotNull ElementCreator<S, R> element) {
        this.elements.add(position, element);
        return this;
    }

    public MineMarkCoreBuilder<S, R> addElement(int position, @NotNull List<String> tags, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(position, new TagBasedElementCreator<S, R>(tags, element));
    }

    public MineMarkCoreBuilder<S, R> addElement(int position, @NotNull String tag, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(position, Collections.singletonList(tag), element);
    }

    public MineMarkCoreBuilder<S, R> addElement(int position, @NotNull Elements elementName, @NotNull TagBasedElementCreator.BasicElementCreator<S, R> element) {
        return this.addElement(position, elementName.tags, element);
    }

    public MineMarkCoreBuilder<S, R> addElements(@NotNull List<ElementCreator<S, R>> elements) {
        for (ElementCreator<S, R> element : elements) {
            this.addElement(element);
        }
        return this;
    }

    public MineMarkCoreBuilder<S, R> addFormatingElement(@NotNull FormattingElement<S, R> element) {
        this.formattingElements.add(element);
        return this;
    }

    public MineMarkCoreBuilder<S, R> addFormatingElement(int position, @NotNull FormattingElement<S, R> element) {
        this.formattingElements.add(position, element);
        return this;
    }

    public MineMarkCoreBuilder<S, R> addFormatingElements(@NotNull List<FormattingElement<S, R>> elements) {
        for (FormattingElement<S, R> element : elements) {
            this.addFormatingElement(element);
        }
        return this;
    }

    public MineMarkCoreBuilder<S, R> addExtension(Extension extension) {
        this.extensions.add(extension);
        return this;
    }

    public MineMarkCoreBuilder<S, R> withoutDefaultElements() {
        this.withDefaultElements = false;
        return this;
    }

    public MineMarkCoreBuilder<S, R> withoutDefaultFormattingElements() {
        this.withDefaultFormattingElements = false;
        return this;
    }

    public MineMarkCoreBuilder<S, R> setUrlSanitizer(UrlSanitizer urlSanitizer) {
        this.urlSanitizer = urlSanitizer;
        return this;
    }

    public MineMarkCore<S, R> build() {
        if (this.textElement == null) {
            throw new IllegalArgumentException("A text element has to be provided by using \"setTextElement(textElement\"");
        }
        if (this.withDefaultElements) {
            this.addElement(Elements.PARAGRAPH, ParagraphElement::new);
            this.addElement(Elements.LINK, LinkElement::new);
            this.addElement(Elements.LIST_PARENT, ListHolderElement::new);
            this.addElement(Elements.TABLE, TableHolderElement::new);
            this.addElement(Elements.TABLE_ROW, TableRowElement::new);
        }
        if (this.withDefaultFormattingElements) {
            this.addFormatingElement(new AlignmentElement());
            this.addFormatingElement(new CssStyleElement());
            this.addFormatingElement(new TextFormattingElement());
        }
        return new MineMarkCore<S, R>(this.textElement, this.elements, this.formattingElements, this.extensions, this.urlSanitizer);
    }
}

