/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.asmhelper.dsl.code.modifiers;

import gg.skytils.asmhelper.printing.PrettyprintingKt;
import gg.skytils.asmhelper.printing.PrintingKt;
import java.util.ArrayDeque;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lgg/skytils/asmhelper/dsl/code/modifiers/Analyzer;", "", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "startInsn", "endInsn", "Ljava/util/Deque;", "Lorg/objectweb/asm/Type;", "analyze", "(Lorg/objectweb/asm/tree/AbstractInsnNode;Lorg/objectweb/asm/tree/AbstractInsnNode;)Ljava/util/Deque;", "Lorg/objectweb/asm/tree/InsnList;", "instructions", "Lorg/objectweb/asm/tree/InsnList;", "getInstructions", "()Lorg/objectweb/asm/tree/InsnList;", "Lorg/objectweb/asm/tree/MethodNode;", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "getMethodNode", "()Lorg/objectweb/asm/tree/MethodNode;", "<init>", "(Lorg/objectweb/asm/tree/InsnList;Lorg/objectweb/asm/tree/MethodNode;)V", "AsmHelper1.8.9"})
public final class Analyzer {
    @NotNull
    private final InsnList instructions;
    @NotNull
    private final MethodNode methodNode;

    public Analyzer(@NotNull InsnList instructions, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        this.instructions = instructions;
        this.methodNode = methodNode;
    }

    @NotNull
    public final InsnList getInstructions() {
        return this.instructions;
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    @NotNull
    public final Deque<Type> analyze(@NotNull AbstractInsnNode startInsn, @NotNull AbstractInsnNode endInsn) {
        Intrinsics.checkNotNullParameter((Object)startInsn, (String)"startInsn");
        Intrinsics.checkNotNullParameter((Object)endInsn, (String)"endInsn");
        ArrayDeque<Object> stack2 = new ArrayDeque<Object>();
        AbstractInsnNode node = startInsn;
        while (!Intrinsics.areEqual((Object)node, (Object)endInsn)) {
            PrintingKt.verbose(Intrinsics.stringPlus((String)"Analyzing ", (Object)PrettyprintingKt.prettyString(node)));
            AbstractInsnNode abstractInsnNode = node;
            if (abstractInsnNode instanceof MethodInsnNode) {
                Type returnType;
                int n = Type.getArgumentTypes((String)((MethodInsnNode)node).desc).length;
                boolean bl = false;
                int n2 = 0;
                n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    boolean bl2 = false;
                    PrintingKt.verbose("Popping " + stack2.poll() + " off the stack because it is an argument");
                }
                if (((MethodInsnNode)node).getOpcode() != 184) {
                    PrintingKt.verbose(Intrinsics.stringPlus((String)"Popping receiver ", stack2.poll()));
                }
                if (!Intrinsics.areEqual((Object)(returnType = Type.getReturnType((String)((MethodInsnNode)node).desc)), (Object)Type.VOID_TYPE)) {
                    stack2.push(returnType);
                }
                PrintingKt.verbose(Intrinsics.stringPlus((String)"Pushed return type ", (Object)returnType));
            } else if (abstractInsnNode instanceof VarInsnNode) {
                if (((VarInsnNode)node).getOpcode() <= 53) {
                    stack2.push(Type.getObjectType((String)((LocalVariableNode)this.methodNode.localVariables.get((int)((VarInsnNode)node).var)).desc));
                } else {
                    stack2.pop();
                }
            } else if (abstractInsnNode instanceof FieldInsnNode) {
                int n = ((FieldInsnNode)node).getOpcode();
                switch (n) {
                    case 178: {
                        stack2.push(Type.getType((String)((FieldInsnNode)node).desc));
                        break;
                    }
                    case 179: {
                        stack2.pop();
                        break;
                    }
                    case 180: {
                        stack2.poll();
                        stack2.push(Type.getType((String)((FieldInsnNode)node).desc));
                        break;
                    }
                    case 181: {
                        stack2.poll();
                        stack2.pop();
                    }
                }
            } else if (abstractInsnNode instanceof IntInsnNode) {
                stack2.push(Type.INT_TYPE);
            } else if (abstractInsnNode instanceof LdcInsnNode) {
                Object object = ((LdcInsnNode)node).cst;
                if (object instanceof String) {
                    String string = String.class.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
                    stack2.push(Type.getObjectType((String)StringsKt.replace$default((String)string, (String)".", (String)"/", (boolean)false, (int)4, null)));
                } else if (object instanceof Integer) {
                    stack2.push(Type.INT_TYPE);
                } else if (object instanceof Long) {
                    stack2.push(Type.LONG_TYPE);
                } else if (object instanceof Double) {
                    stack2.push(Type.DOUBLE_TYPE);
                } else if (object instanceof Float) {
                    stack2.push(Type.FLOAT_TYPE);
                } else if (object instanceof Type) {
                    Object object2 = ((LdcInsnNode)node).cst;
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.Type");
                    }
                    stack2.push((Type)object2);
                }
            } else if (abstractInsnNode instanceof InsnNode) {
                int n = ((InsnNode)node).getOpcode();
                boolean bl = 2 <= n ? n <= 8 : false;
                if (bl) {
                    stack2.push(Type.INT_TYPE);
                } else {
                    boolean bl3 = 9 <= n ? n <= 10 : false;
                    if (bl3) {
                        stack2.push(Type.LONG_TYPE);
                    } else {
                        boolean bl4 = 11 <= n ? n <= 13 : false;
                        if (bl4) {
                            stack2.push(Type.FLOAT_TYPE);
                        } else {
                            boolean bl5 = 14 <= n ? n <= 15 : false;
                            if (bl5) {
                                stack2.push(Type.DOUBLE_TYPE);
                            } else {
                                boolean bl6 = 96 <= n ? n <= 115 : false;
                                if (bl6) {
                                    stack2.pop();
                                } else if (n == 89) {
                                    stack2.push(stack2.peek());
                                }
                            }
                        }
                    }
                }
            } else if (abstractInsnNode instanceof TypeInsnNode) {
                int n = ((TypeInsnNode)node).getOpcode();
                switch (n) {
                    case 187: {
                        stack2.push(Type.getObjectType((String)((TypeInsnNode)node).desc));
                        break;
                    }
                    case 192: {
                        stack2.pop();
                        stack2.push(Type.getObjectType((String)((TypeInsnNode)node).desc));
                    }
                }
            }
            PrintingKt.verbose(Intrinsics.stringPlus((String)"Stack after analyzation frame looks like ", stack2));
            abstractInsnNode = node.getNext();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"node.next");
            node = abstractInsnNode;
        }
        return stack2;
    }
}

