/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.http;

import gg.skytils.ktor.http.ContentType;
import gg.skytils.ktor.http.ContentTypesKt;
import gg.skytils.ktor.http.FileContentTypeKt;
import gg.skytils.ktor.util.CharsetKt;
import gg.skytils.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\u0007\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\u0005\u001a\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0004\b\f\u0010\r\u001a\u001f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\b*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000e\u0010\r\u001aC\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u0013\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u0010*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00120\u0011H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0013\u0010\u0017\u001a\u00020\u0016*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a\u0019\u0010\u0019\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\bH\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a\u0013\u0010\u001b\u001a\u00020\u0003*\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0013\u0010\u001d\u001a\u00020\u0003*\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\"-\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"-\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010 \u001a\u0004\b%\u0010\"\u00a8\u0006'"}, d2={"Lgg/skytils/ktor/http/ContentType$Companion;", "", "extension", "Lgg/skytils/ktor/http/ContentType;", "defaultForFileExtension", "(Lgg/skytils/ktor/http/ContentType$Companion;Ljava/lang/String;)Lgg/skytils/ktor/http/ContentType;", "path", "defaultForFilePath", "", "fileExtensions", "(Lgg/skytils/ktor/http/ContentType;)Ljava/util/List;", "ext", "fromFileExtension", "(Lgg/skytils/ktor/http/ContentType$Companion;Ljava/lang/String;)Ljava/util/List;", "fromFilePath", "A", "B", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "groupByPairs", "(Lkotlin/sequences/Sequence;)Ljava/util/Map;", "", "matchApplicationTypeWithCharset", "(Lgg/skytils/ktor/http/ContentType;)Z", "selectDefault", "(Ljava/util/List;)Lgg/skytils/ktor/http/ContentType;", "toContentType", "(Ljava/lang/String;)Lgg/skytils/ktor/http/ContentType;", "withCharsetUTF8IfNeeded", "(Lgg/skytils/ktor/http/ContentType;)Lgg/skytils/ktor/http/ContentType;", "contentTypesByExtensions$delegate", "Lkotlin/Lazy;", "getContentTypesByExtensions", "()Ljava/util/Map;", "contentTypesByExtensions", "extensionsByContentType$delegate", "getExtensionsByContentType", "extensionsByContentType", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nFileContentType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContentType.kt\nio/ktor/http/FileContentTypeKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n970#2:105\n999#2,3:106\n1002#2,3:116\n361#3,7:109\n442#3:119\n392#3:120\n1238#4,2:121\n1549#4:123\n1620#4,3:124\n1241#4:127\n*S KotlinDebug\n*F\n+ 1 FileContentType.kt\nio/ktor/http/FileContentTypeKt\n*L\n96#1:105\n96#1:106,3\n96#1:116,3\n96#1:109,7\n97#1:119\n97#1:120\n97#1:121,2\n97#1:123\n97#1:124,3\n97#1:127\n*E\n"})
public final class FileContentTypeKt {
    @NotNull
    private static final Lazy contentTypesByExtensions$delegate = LazyKt.lazy((Function0)contentTypesByExtensions.2.INSTANCE);
    @NotNull
    private static final Lazy extensionsByContentType$delegate = LazyKt.lazy((Function0)extensionsByContentType.2.INSTANCE);

    @NotNull
    public static final ContentType defaultForFileExtension(@NotNull ContentType.Companion $this$defaultForFileExtension, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultForFileExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFileExtension(ContentType.Companion, extension));
    }

    @NotNull
    public static final ContentType defaultForFilePath(@NotNull ContentType.Companion $this$defaultForFilePath, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultForFilePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFilePath(ContentType.Companion, path));
    }

    @NotNull
    public static final List<ContentType> fromFilePath(@NotNull ContentType.Companion $this$fromFilePath, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$fromFilePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int slashIndex = StringsKt.lastIndexOfAny$default((CharSequence)path, (char[])CharsetKt.toCharArray("/\\"), (int)0, (boolean)false, (int)6, null);
        int index = StringsKt.indexOf$default((CharSequence)path, (char)'.', (int)(slashIndex + 1), (boolean)false, (int)4, null);
        if (index == -1) {
            return CollectionsKt.emptyList();
        }
        String string = path.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return FileContentTypeKt.fromFileExtension($this$fromFilePath, string);
    }

    @NotNull
    public static final List<ContentType> fromFileExtension(@NotNull ContentType.Companion $this$fromFileExtension, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)$this$fromFileExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        String current = TextKt.toLowerCasePreservingASCIIRules(StringsKt.removePrefix((String)ext, (CharSequence)"."));
        while (((CharSequence)current).length() > 0) {
            List<ContentType> type = FileContentTypeKt.getContentTypesByExtensions().get(current);
            if (type != null) {
                return type;
            }
            current = StringsKt.substringAfter((String)current, (String)".", (String)"");
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final List<String> fileExtensions(@NotNull ContentType $this$fileExtensions) {
        Intrinsics.checkNotNullParameter((Object)$this$fileExtensions, (String)"<this>");
        List list = FileContentTypeKt.getExtensionsByContentType().get($this$fileExtensions);
        if (list == null && (list = FileContentTypeKt.getExtensionsByContentType().get($this$fileExtensions.withoutParameters())) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Map<String, List<ContentType>> getContentTypesByExtensions() {
        Lazy lazy = contentTypesByExtensions$delegate;
        return (Map)lazy.getValue();
    }

    private static final Map<ContentType, List<String>> getExtensionsByContentType() {
        Lazy lazy = extensionsByContentType$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public static final ContentType selectDefault(@NotNull List<ContentType> $this$selectDefault) {
        Intrinsics.checkNotNullParameter($this$selectDefault, (String)"<this>");
        ContentType contentType2 = (ContentType)CollectionsKt.firstOrNull($this$selectDefault);
        if (contentType2 == null) {
            contentType2 = ContentType.Application.INSTANCE.getOctetStream();
        }
        ContentType contentType3 = contentType2;
        return contentType3.match(ContentType.Text.INSTANCE.getAny()) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType3) : (contentType3.match(ContentType.Image.INSTANCE.getSVG()) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType3) : (FileContentTypeKt.matchApplicationTypeWithCharset(contentType3) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType3) : contentType3));
    }

    private static final boolean matchApplicationTypeWithCharset(ContentType $this$matchApplicationTypeWithCharset) {
        if (!$this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getAny())) {
            return false;
        }
        return $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getAtom()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getJavaScript()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getRss()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getXml()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getXml_Dtd());
    }

    private static final ContentType withCharsetUTF8IfNeeded(ContentType $this$withCharsetUTF8IfNeeded) {
        if (ContentTypesKt.charset($this$withCharsetUTF8IfNeeded) != null) {
            return $this$withCharsetUTF8IfNeeded;
        }
        return ContentTypesKt.withCharset($this$withCharsetUTF8IfNeeded, Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <A, B> Map<A, List<B>> groupByPairs(@NotNull Sequence<? extends Pair<? extends A, ? extends B>> $this$groupByPairs) {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$groupByPairs, (String)"<this>");
        Sequence<? extends Pair<? extends A, ? extends B>> $this$groupBy$iv = $this$groupByPairs;
        boolean $i$f$groupBy = false;
        Sequence<? extends Pair<? extends A, ? extends B>> sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void e;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)e.getValue();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it.getSecond());
            }
            List list = (List)destination$iv$iv2;
            map3.put(k, list);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final ContentType toContentType(@NotNull String $this$toContentType) {
        ContentType contentType2;
        Intrinsics.checkNotNullParameter((Object)$this$toContentType, (String)"<this>");
        try {
            contentType2 = ContentType.Companion.parse($this$toContentType);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to parse " + $this$toContentType, e);
        }
        return contentType2;
    }
}

