/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.http.content;

import gg.skytils.ktor.http.CodecsKt;
import gg.skytils.ktor.http.ContentType;
import gg.skytils.ktor.http.content.OutgoingContent;
import gg.skytils.ktor.http.content.URIFileContent;
import gg.skytils.ktor.server.application.Application;
import gg.skytils.ktor.server.application.ApplicationCall;
import gg.skytils.ktor.server.http.content.JarFileContent;
import gg.skytils.ktor.server.http.content.LocalFileContent;
import gg.skytils.ktor.server.http.content.StaticContentResolutionKt;
import gg.skytils.ktor.server.plugins.BadRequestException;
import gg.skytils.ktor.server.util.PathsKt;
import gg.skytils.ktor.util.InternalAPI;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a!\u0010\u0007\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0006\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u001a5\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0001\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00002\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\nH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0013\u0010\u0010\u001a\u00020\u0000*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001aS\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r\u0018\u00010\u0015*\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00002\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\u0014\u001a\u00020\u00132\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001aG\u0010\u0016\u001a\u0004\u0018\u00010\r*\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00002\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\u0014\u001a\u00020\u00132\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\u0016\u0010\u0019\u00a8\u0006\u001a"}, d2={"", "url", "Ljava/io/File;", "findContainingJarFile", "(Ljava/lang/String;)Ljava/io/File;", "resourcePackage", "path", "normalisedPath", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "Ljava/net/URL;", "Lkotlin/Function1;", "Lgg/skytils/ktor/http/ContentType;", "mimeResolve", "Lgg/skytils/ktor/http/content/OutgoingContent$ReadChannelContent;", "resourceClasspathResource", "(Ljava/net/URL;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lgg/skytils/ktor/http/content/OutgoingContent$ReadChannelContent;", "extension", "(Ljava/lang/String;)Ljava/lang/String;", "Lgg/skytils/ktor/server/application/Application;", "Ljava/lang/ClassLoader;", "classLoader", "Lkotlin/Pair;", "resolveResource", "(Lgg/skytils/ktor/server/application/Application;Ljava/lang/String;Ljava/lang/String;Ljava/lang/ClassLoader;Lkotlin/jvm/functions/Function1;)Lkotlin/Pair;", "Lgg/skytils/ktor/server/application/ApplicationCall;", "(Lgg/skytils/ktor/server/application/ApplicationCall;Ljava/lang/String;Ljava/lang/String;Ljava/lang/ClassLoader;Lkotlin/jvm/functions/Function1;)Lgg/skytils/ktor/http/content/OutgoingContent$ReadChannelContent;", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nStaticContentResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StaticContentResolution.kt\nio/ktor/server/http/content/StaticContentResolutionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class StaticContentResolutionKt {
    @Nullable
    public static final OutgoingContent.ReadChannelContent resolveResource(@NotNull ApplicationCall $this$resolveResource, @NotNull String path, @Nullable String resourcePackage, @NotNull ClassLoader classLoader, @NotNull Function1<? super String, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(mimeResolve, (String)"mimeResolve");
        if (StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)"\\", (boolean)false, (int)2, null)) {
            return null;
        }
        String normalizedPath = StaticContentResolutionKt.normalisedPath(resourcePackage, path);
        Enumeration<URL> enumeration = classLoader.getResources(normalizedPath);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"classLoader.getResources(normalizedPath)");
        for (URL url2 : SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration))) {
            Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"url");
            OutgoingContent.ReadChannelContent readChannelContent = StaticContentResolutionKt.resourceClasspathResource(url2, normalizedPath, (Function1<? super URL, ContentType>)((Function1)new Function1<URL, ContentType>(mimeResolve){
                final /* synthetic */ Function1<String, ContentType> $mimeResolve;
                {
                    this.$mimeResolve = $mimeResolve;
                    super(1);
                }

                @NotNull
                public final ContentType invoke(@NotNull URL it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = it.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
                    return (ContentType)this.$mimeResolve.invoke((Object)StaticContentResolutionKt.extension(string));
                }
            }));
            if (readChannelContent == null) continue;
            OutgoingContent.ReadChannelContent content2 = readChannelContent;
            boolean bl = false;
            return content2;
        }
        return null;
    }

    public static /* synthetic */ OutgoingContent.ReadChannelContent resolveResource$default(ApplicationCall applicationCall, String string, String string2, ClassLoader classLoader, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            classLoader = applicationCall.getApplication().getEnvironment().getClassLoader();
        }
        if ((n & 8) != 0) {
            function1 = resolveResource.1.INSTANCE;
        }
        return StaticContentResolutionKt.resolveResource(applicationCall, string, string2, classLoader, (Function1<? super String, ContentType>)function1);
    }

    @Nullable
    public static final Pair<URL, OutgoingContent.ReadChannelContent> resolveResource(@NotNull Application $this$resolveResource, @NotNull String path, @Nullable String resourcePackage, @NotNull ClassLoader classLoader, @NotNull Function1<? super URL, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(mimeResolve, (String)"mimeResolve");
        if (StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)"\\", (boolean)false, (int)2, null)) {
            return null;
        }
        String normalizedPath = StaticContentResolutionKt.normalisedPath(resourcePackage, path);
        Enumeration<URL> enumeration = classLoader.getResources(normalizedPath);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"classLoader.getResources(normalizedPath)");
        for (URL url2 : SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration))) {
            Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"url");
            OutgoingContent.ReadChannelContent readChannelContent = StaticContentResolutionKt.resourceClasspathResource(url2, normalizedPath, mimeResolve);
            if (readChannelContent == null) continue;
            OutgoingContent.ReadChannelContent content2 = readChannelContent;
            boolean bl = false;
            return TuplesKt.to((Object)url2, (Object)content2);
        }
        return null;
    }

    public static /* synthetic */ Pair resolveResource$default(Application application, String string, String string2, ClassLoader classLoader, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            classLoader = application.getEnvironment().getClassLoader();
        }
        return StaticContentResolutionKt.resolveResource(application, string, string2, classLoader, (Function1<? super URL, ContentType>)function1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalAPI
    @Nullable
    public static final OutgoingContent.ReadChannelContent resourceClasspathResource(@NotNull URL url2, @NotNull String path, @NotNull Function1<? super URL, ContentType> mimeResolve) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(mimeResolve, (String)"mimeResolve");
        String string = url2.getProtocol();
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 3143036: {
                if (string.equals("file")) {
                    n = 1;
                }
                break;
            }
            case -341064690: {
                if (string.equals("resource")) {
                    n = 2;
                }
                break;
            }
            case 104987: {
                if (string.equals("jar")) {
                    n = 3;
                }
                break;
            }
            case 105516: {
                if (string.equals("jrt")) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                String string2 = url2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.path");
                File file2 = new File(CodecsKt.decodeURLPart$default(string2, 0, 0, null, 7, null));
                OutgoingContent.ReadChannelContent readChannelContent = file2.isFile() ? new LocalFileContent(file2, (ContentType)mimeResolve.invoke((Object)url2)) : null;
                return readChannelContent;
            }
            case 3: {
                JarFileContent jarFileContent;
                if (StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                    jarFileContent = null;
                } else {
                    String string3 = url2.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"url.toString()");
                    File zipFile = StaticContentResolutionKt.findContainingJarFile(string3);
                    JarFileContent content2 = new JarFileContent(zipFile, path, (ContentType)mimeResolve.invoke((Object)url2));
                    jarFileContent = content2.isFile() ? content2 : null;
                }
                OutgoingContent.ReadChannelContent readChannelContent = jarFileContent;
                return readChannelContent;
            }
            case 2: {
                OutgoingContent.ReadChannelContent readChannelContent = new URIFileContent(url2, (ContentType)mimeResolve.invoke((Object)url2));
                return readChannelContent;
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public static final File findContainingJarFile(@NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        if (StringsKt.startsWith$default((String)url2, (String)"jar:file:", (boolean)false, (int)2, null)) {
            int jarPathSeparator = StringsKt.indexOf$default((CharSequence)url2, (String)"!", (int)9, (boolean)false, (int)4, null);
            if (!(jarPathSeparator != -1)) {
                boolean bl = false;
                String string = "Jar path requires !/ separator but it is: " + url2;
                throw new IllegalArgumentException(string.toString());
            }
            String string = url2.substring(9, jarPathSeparator);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return new File(CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null));
        }
        throw new IllegalArgumentException("Only local jars are supported (jar:file:)");
    }

    @NotNull
    public static final String extension(@NotNull String $this$extension) {
        String string;
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$extension, (String)"<this>");
        Integer n2 = StringsKt.lastIndexOf$default((CharSequence)$this$extension, (char)'/', (int)0, (boolean)false, (int)6, null);
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it != -1 ? n2 : null;
        if (n3 != null) {
            n = n3;
        } else {
            Integer n4 = StringsKt.lastIndexOf$default((CharSequence)$this$extension, (char)'\\', (int)0, (boolean)false, (int)6, null);
            int it2 = ((Number)n4).intValue();
            boolean bl2 = false;
            Integer n5 = it2 != -1 ? n4 : null;
            n = n5 != null ? n5 : 0;
        }
        int indexOfName = n;
        int indexOfDot = StringsKt.indexOf$default((CharSequence)$this$extension, (char)'.', (int)indexOfName, (boolean)false, (int)4, null);
        if (indexOfDot >= 0) {
            String string2 = $this$extension.substring(indexOfDot);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = "";
        }
        return string;
    }

    private static final String normalisedPath(String resourcePackage, String path) {
        char[] cArray = new char[]{'/', '\\'};
        List pathComponents = StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (pathComponents.contains("..")) {
            throw new BadRequestException("Relative path should not contain path traversing characters: " + path, null, 2, null);
        }
        String string = resourcePackage;
        if (string == null) {
            string = "";
        }
        cArray = new char[]{'.', '/', '\\'};
        return CollectionsKt.joinToString$default((Iterable)PathsKt.normalizePathComponents(CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null), (Iterable)pathComponents)), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }
}

