/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.sessions;

import gg.skytils.ktor.http.Cookie;
import gg.skytils.ktor.http.CookieEncoding;
import gg.skytils.ktor.server.application.ApplicationCall;
import gg.skytils.ktor.server.sessions.CookieConfiguration;
import gg.skytils.ktor.server.sessions.SessionTransport;
import gg.skytils.ktor.server.sessions.SessionTransportTransformer;
import gg.skytils.ktor.server.sessions.SessionTransportTransformerKt;
import gg.skytils.ktor.util.date.DateJvmKt;
import gg.skytils.ktor.util.date.DateKt;
import gg.skytils.ktor.util.date.GMTDate;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0018\u001a\u00020\u000b\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\n\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0014\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u0012R\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lgg/skytils/ktor/server/sessions/SessionTransportCookie;", "Lgg/skytils/ktor/server/sessions/SessionTransport;", "Lgg/skytils/ktor/server/application/ApplicationCall;", "call", "", "clear", "(Lgg/skytils/ktor/server/application/ApplicationCall;)V", "Lgg/skytils/ktor/http/Cookie;", "clearCookie$ktor_server_sessions", "()Lgg/skytils/ktor/http/Cookie;", "clearCookie", "", "receive", "(Lgg/skytils/ktor/server/application/ApplicationCall;)Ljava/lang/String;", "value", "send", "(Lgg/skytils/ktor/server/application/ApplicationCall;Ljava/lang/String;)V", "toString", "()Ljava/lang/String;", "Lgg/skytils/ktor/server/sessions/CookieConfiguration;", "configuration", "Lgg/skytils/ktor/server/sessions/CookieConfiguration;", "getConfiguration", "()Lio/ktor/server/sessions/CookieConfiguration;", "name", "Ljava/lang/String;", "getName", "", "Lgg/skytils/ktor/server/sessions/SessionTransportTransformer;", "transformers", "Ljava/util/List;", "getTransformers", "()Ljava/util/List;", "<init>", "(Ljava/lang/String;Lio/ktor/server/sessions/CookieConfiguration;Ljava/util/List;)V", "ktor-server-sessions"})
public final class SessionTransportCookie
implements SessionTransport {
    @NotNull
    private final String name;
    @NotNull
    private final CookieConfiguration configuration;
    @NotNull
    private final List<SessionTransportTransformer> transformers;

    public SessionTransportCookie(@NotNull String name, @NotNull CookieConfiguration configuration, @NotNull List<? extends SessionTransportTransformer> transformers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(transformers, (String)"transformers");
        this.name = name;
        this.configuration = configuration;
        this.transformers = transformers;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final CookieConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final List<SessionTransportTransformer> getTransformers() {
        return this.transformers;
    }

    @Override
    @Nullable
    public String receive(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return SessionTransportTransformerKt.transformRead(this.transformers, call.getRequest().getCookies().get(this.name, this.configuration.getEncoding()));
    }

    @Override
    public void send(@NotNull ApplicationCall call, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        GMTDate now = DateJvmKt.GMTDate$default(null, 1, null);
        long maxAge = this.configuration.getMaxAgeInSeconds();
        GMTDate expires = maxAge == 0L ? null : DateKt.plus(now, maxAge * 1000L);
        Cookie cookie = new Cookie(this.name, SessionTransportTransformerKt.transformWrite(this.transformers, value), this.configuration.getEncoding(), (int)RangesKt.coerceAtMost((long)maxAge, (long)Integer.MAX_VALUE), expires, this.configuration.getDomain(), this.configuration.getPath(), this.configuration.getSecure(), this.configuration.getHttpOnly(), this.configuration.getExtensions());
        call.getResponse().getCookies().append(cookie);
    }

    @Override
    public void clear(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        call.getResponse().getCookies().append(this.clearCookie$ktor_server_sessions());
    }

    @NotNull
    public final Cookie clearCookie$ktor_server_sessions() {
        String string = this.name;
        CookieEncoding cookieEncoding = this.configuration.getEncoding();
        String string2 = this.configuration.getDomain();
        String string3 = this.configuration.getPath();
        boolean bl = this.configuration.getSecure();
        boolean bl2 = this.configuration.getHttpOnly();
        Map<String, String> map2 = this.configuration.getExtensions();
        GMTDate gMTDate = GMTDate.Companion.getSTART();
        return new Cookie(string, "", cookieEncoding, 0, gMTDate, string2, string3, bl, bl2, map2);
    }

    @NotNull
    public String toString() {
        return "SessionTransportCookie: " + this.name;
    }
}

