/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.utils.io.internal;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u001a\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u00100\u001a\u00020\u0002\u00a2\u0006\u0004\b2\u0010\u0006J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\u0006J\u001f\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0012J\r\u0010\u0016\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0016\u0010\u0012J\r\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0014J\r\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0014J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001c\u0010\u0012J\u0015\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u0015\u0010 \u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\"\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\"\u0010\u001eJ\u0015\u0010#\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b#\u0010\u001eJ\u0015\u0010$\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b$\u0010!R&\u0010)\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u00028\u00c6\u0002@\u00c2\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010\u0006R&\u0010,\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u00028\u00c6\u0002@\u00c2\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010'\"\u0004\b+\u0010\u0006R&\u0010/\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u00028\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010'\"\u0004\b.\u0010\u0006R\u0014\u00100\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00063"}, d2={"Lgg/skytils/ktor/utils/io/internal/RingBufferCapacity;", "", "", "n", "", "completeRead", "(I)V", "remaining", "update", "", "completeReadOverflow", "(III)Ljava/lang/Void;", "completeWrite", "pending", "completeWriteOverflow", "(II)Ljava/lang/Void;", "", "flush", "()Z", "forceLockForRelease", "()V", "isEmpty", "isFull", "resetForRead", "resetForWrite", "", "toString", "()Ljava/lang/String;", "tryLockForRelease", "tryReadAtLeast", "(I)I", "tryReadAtMost", "tryReadExact", "(I)Z", "tryWriteAtLeast", "tryWriteAtMost", "tryWriteExact", "value", "getAvailableForRead", "()I", "setAvailableForRead", "availableForRead", "getAvailableForWrite", "setAvailableForWrite", "availableForWrite", "getPendingToFlush", "setPendingToFlush", "pendingToFlush", "totalCapacity", "I", "<init>", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nRingBufferCapacity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RingBufferCapacity.kt\nio/ktor/utils/io/internal/RingBufferCapacity\n+ 2 AtomicFU.common.kt\nkotlinx/atomicfu/AtomicFU_commonKt\n*L\n1#1,152:1\n24#1:188\n12#1:189\n12#1,7:191\n24#1:198\n371#2,4:153\n360#2,4:157\n371#2,4:161\n371#2,4:165\n360#2,4:169\n371#2,4:173\n360#2,4:177\n360#2,4:181\n360#2,3:185\n363#2:190\n*S KotlinDebug\n*F\n+ 1 RingBufferCapacity.kt\nio/ktor/utils/io/internal/RingBufferCapacity\n*L\n130#1:188\n130#1:189\n149#1:191,7\n150#1:198\n43#1:153,4\n51#1:157,4\n59#1:161,4\n68#1:165,4\n76#1:169,4\n84#1:173,4\n93#1:177,4\n105#1:181,4\n129#1:185,3\n129#1:190\n*E\n"})
public final class RingBufferCapacity {
    private final int totalCapacity;
    @NotNull
    public volatile /* synthetic */ int _availableForRead$internal;
    public static final /* synthetic */ AtomicIntegerFieldUpdater _availableForRead$FU$internal;
    @NotNull
    public volatile /* synthetic */ int _availableForWrite$internal;
    public static final /* synthetic */ AtomicIntegerFieldUpdater _availableForWrite$FU$internal;
    @NotNull
    volatile /* synthetic */ int _pendingToFlush;
    static final /* synthetic */ AtomicIntegerFieldUpdater _pendingToFlush$FU;

    public RingBufferCapacity(int totalCapacity) {
        this.totalCapacity = totalCapacity;
        this._availableForRead$internal = 0;
        this._availableForWrite$internal = this.totalCapacity;
        this._pendingToFlush = 0;
    }

    public final int getAvailableForRead() {
        boolean $i$f$getAvailableForRead = false;
        return this._availableForRead$internal;
    }

    private final void setAvailableForRead(int value) {
        boolean $i$f$setAvailableForRead = false;
        this._availableForRead$internal = value;
    }

    public final int getAvailableForWrite() {
        boolean $i$f$getAvailableForWrite = false;
        return this._availableForWrite$internal;
    }

    private final void setAvailableForWrite(int value) {
        boolean $i$f$setAvailableForWrite = false;
        this._availableForWrite$internal = value;
    }

    public final int getPendingToFlush() {
        boolean $i$f$getPendingToFlush = false;
        return this._pendingToFlush;
    }

    public final void setPendingToFlush(int value) {
        boolean $i$f$setPendingToFlush = false;
        this._pendingToFlush = value;
    }

    public final void resetForWrite() {
        this._availableForRead$internal = 0;
        this._pendingToFlush = 0;
        this._availableForWrite$internal = this.totalCapacity;
    }

    public final void resetForRead() {
        this._availableForRead$internal = this.totalCapacity;
        this._availableForWrite$internal = 0;
        this._pendingToFlush = 0;
    }

    public final int tryReadAtLeast(int n) {
        int upd$iv;
        int cur$iv;
        RingBufferCapacity $this$getAndUpdate$iv = this;
        boolean $i$f$getAndUpdate = false;
        do {
            int remaining = cur$iv = $this$getAndUpdate$iv._availableForRead$internal;
            boolean bl = false;
            if (remaining >= n) continue;
            return 0;
        } while (!_availableForRead$FU$internal.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = 0));
        int available = cur$iv;
        return available;
    }

    public final boolean tryReadExact(int n) {
        int remaining;
        int upd$iv;
        int cur$iv;
        RingBufferCapacity $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            remaining = cur$iv = $this$update$iv._availableForRead$internal;
            boolean bl = false;
            if (remaining >= n) continue;
            return false;
        } while (!_availableForRead$FU$internal.compareAndSet($this$update$iv, cur$iv, upd$iv = remaining - n));
        return true;
    }

    public final int tryReadAtMost(int n) {
        int delta;
        int remaining;
        int upd$iv;
        int cur$iv;
        RingBufferCapacity $this$getAndUpdate$iv = this;
        boolean $i$f$getAndUpdate = false;
        do {
            remaining = cur$iv = $this$getAndUpdate$iv._availableForRead$internal;
            boolean bl = false;
            delta = Math.min(n, remaining);
            if (delta != 0) continue;
            return 0;
        } while (!_availableForRead$FU$internal.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = remaining - delta));
        int available = cur$iv;
        return Math.min(n, available);
    }

    public final int tryWriteAtLeast(int n) {
        int upd$iv;
        int cur$iv;
        RingBufferCapacity $this$getAndUpdate$iv = this;
        boolean $i$f$getAndUpdate = false;
        do {
            int remaining = cur$iv = $this$getAndUpdate$iv._availableForWrite$internal;
            boolean bl = false;
            if (remaining >= n) continue;
            return 0;
        } while (!_availableForWrite$FU$internal.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = 0));
        int available = cur$iv;
        return available;
    }

    public final boolean tryWriteExact(int n) {
        int remaining;
        int upd$iv;
        int cur$iv;
        RingBufferCapacity $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            remaining = cur$iv = $this$update$iv._availableForWrite$internal;
            boolean bl = false;
            if (remaining >= n) continue;
            return false;
        } while (!_availableForWrite$FU$internal.compareAndSet($this$update$iv, cur$iv, upd$iv = remaining - n));
        return true;
    }

    public final int tryWriteAtMost(int n) {
        int delta;
        int remaining;
        int upd$iv;
        int cur$iv;
        RingBufferCapacity $this$getAndUpdate$iv = this;
        boolean $i$f$getAndUpdate = false;
        do {
            remaining = cur$iv = $this$getAndUpdate$iv._availableForWrite$internal;
            boolean bl = false;
            delta = Math.min(n, remaining);
            if (delta != 0) continue;
            return 0;
        } while (!_availableForWrite$FU$internal.compareAndSet($this$getAndUpdate$iv, cur$iv, upd$iv = remaining - delta));
        int available = cur$iv;
        return Math.min(n, available);
    }

    public final void completeRead(int n) {
        int update2;
        int upd$iv;
        int cur$iv;
        RingBufferCapacity $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            int remaining = cur$iv = $this$update$iv._availableForWrite$internal;
            boolean bl = false;
            update2 = remaining + n;
            if (update2 <= this.totalCapacity) continue;
            this.completeReadOverflow(remaining, update2, n);
            throw new KotlinNothingValueException();
        } while (!_availableForWrite$FU$internal.compareAndSet($this$update$iv, cur$iv, upd$iv = update2));
    }

    private final Void completeReadOverflow(int remaining, int update2, int n) {
        throw new IllegalArgumentException("Completed read overflow: " + remaining + " + " + n + " = " + update2 + " > " + this.totalCapacity);
    }

    public final void completeWrite(int n) {
        int update2;
        int upd$iv;
        int cur$iv;
        RingBufferCapacity $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            int pending = cur$iv = $this$update$iv._pendingToFlush;
            boolean bl = false;
            update2 = pending + n;
            if (update2 <= this.totalCapacity) continue;
            this.completeWriteOverflow(pending, n);
            throw new KotlinNothingValueException();
        } while (!_pendingToFlush$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = update2));
    }

    private final Void completeWriteOverflow(int pending, int n) {
        throw new IllegalArgumentException("Complete write overflow: " + pending + " + " + n + " > " + this.totalCapacity);
    }

    public final boolean flush() {
        int pending = _pendingToFlush$FU.getAndSet(this, 0);
        if (pending == 0) {
        } else {
            return _availableForRead$FU$internal.addAndGet(this, pending) > 0;
        }
        return this._availableForRead$internal > 0;
    }

    public final boolean tryLockForRelease() {
        int upd$iv;
        int cur$iv;
        RingBufferCapacity $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            int remaining = cur$iv = $this$update$iv._availableForWrite$internal;
            boolean bl = false;
            RingBufferCapacity this_$iv = this;
            boolean $i$f$getPendingToFlush = false;
            if (this_$iv._pendingToFlush <= 0) {
                this_$iv = this;
                boolean $i$f$getAvailableForRead = false;
                if (this_$iv._availableForRead$internal <= 0 && remaining == this.totalCapacity) continue;
            }
            return false;
        } while (!_availableForWrite$FU$internal.compareAndSet($this$update$iv, cur$iv, upd$iv = 0));
        return true;
    }

    public final void forceLockForRelease() {
        _availableForWrite$FU$internal.getAndSet(this, 0);
    }

    public final boolean isEmpty() {
        return this._availableForWrite$internal == this.totalCapacity;
    }

    public final boolean isFull() {
        return this._availableForWrite$internal == 0;
    }

    @NotNull
    public String toString() {
        RingBufferCapacity this_$iv = this;
        boolean $i$f$getAvailableForRead = false;
        this_$iv = this;
        boolean $i$f$getAvailableForWrite = false;
        this_$iv = this;
        boolean $i$f$getPendingToFlush = false;
        return "RingBufferCapacity[read: " + this_$iv._availableForRead$internal + ", write: " + this_$iv._availableForWrite$internal + ", flush: " + this_$iv._pendingToFlush + ", capacity: " + this.totalCapacity + ']';
    }

    static {
        _availableForRead$FU$internal = AtomicIntegerFieldUpdater.newUpdater(RingBufferCapacity.class, "_availableForRead$internal");
        _availableForWrite$FU$internal = AtomicIntegerFieldUpdater.newUpdater(RingBufferCapacity.class, "_availableForWrite$internal");
        _pendingToFlush$FU = AtomicIntegerFieldUpdater.newUpdater(RingBufferCapacity.class, "_pendingToFlush");
    }
}

