/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.json;

import gg.skytils.ktx-serialization.DeserializationStrategy;
import gg.skytils.ktx-serialization.KSerializer;
import gg.skytils.ktx-serialization.SerializationException;
import gg.skytils.ktx-serialization.SerializationStrategy;
import gg.skytils.ktx-serialization.SerializersKt;
import gg.skytils.ktx-serialization.descriptors.PolymorphicKind;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptor;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptorsKt;
import gg.skytils.ktx-serialization.encoding.Decoder;
import gg.skytils.ktx-serialization.encoding.Encoder;
import gg.skytils.ktx-serialization.json.JsonDecoder;
import gg.skytils.ktx-serialization.json.JsonElement;
import gg.skytils.ktx-serialization.json.JsonElementSerializersKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0015\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\t\u001a\u00020\bH$\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0017\u001a\u00020\u00162\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0019R\u001a\u0010\u001b\u001a\u00020\u001a8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lgg/skytils/ktx-serialization/json/JsonContentPolymorphicSerializer;", "", "T", "Lgg/skytils/ktx-serialization/KSerializer;", "Lgg/skytils/ktx-serialization/encoding/Decoder;", "decoder", "deserialize", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "Lgg/skytils/ktx-serialization/json/JsonElement;", "element", "Lgg/skytils/ktx-serialization/DeserializationStrategy;", "selectDeserializer", "(Lgg/skytils/ktx-serialization/json/JsonElement;)Lgg/skytils/ktx-serialization/DeserializationStrategy;", "Lgg/skytils/ktx-serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "Lkotlin/reflect/KClass;", "subClass", "baseClass", "", "throwSubtypeNotRegistered", "(Lkotlin/reflect/KClass;Lkotlin/reflect/KClass;)Ljava/lang/Void;", "Lkotlin/reflect/KClass;", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "descriptor", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "(Lkotlin/reflect/KClass;)V", "kotlinx-serialization-json"})
public abstract class JsonContentPolymorphicSerializer<T>
implements KSerializer<T> {
    @NotNull
    private final KClass<T> baseClass;
    @NotNull
    private final SerialDescriptor descriptor;

    public JsonContentPolymorphicSerializer(@NotNull KClass<T> baseClass) {
        Intrinsics.checkNotNullParameter(baseClass, (String)"baseClass");
        this.baseClass = baseClass;
        this.descriptor = SerialDescriptorsKt.buildSerialDescriptor$default("JsonContentPolymorphicSerializer<" + this.baseClass.getSimpleName() + '>', PolymorphicKind.SEALED.INSTANCE, new SerialDescriptor[0], null, 8, null);
    }

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final void serialize(@NotNull Encoder encoder2, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)encoder2, (String)"encoder");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        SerializationStrategy serializationStrategy = encoder2.getSerializersModule().getPolymorphic(this.baseClass, value);
        if (serializationStrategy == null) {
            KSerializer kSerializer = SerializersKt.serializerOrNull(Reflection.getOrCreateKotlinClass(value.getClass()));
            if (kSerializer != null) {
                serializationStrategy = kSerializer;
            } else {
                this.throwSubtypeNotRegistered(Reflection.getOrCreateKotlinClass(value.getClass()), this.baseClass);
                throw new KotlinNothingValueException();
            }
        }
        SerializationStrategy actualSerializer = serializationStrategy;
        ((KSerializer)actualSerializer).serialize(encoder2, value);
    }

    @Override
    @NotNull
    public final T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonDecoder input2 = JsonElementSerializersKt.asJsonDecoder(decoder);
        JsonElement tree = input2.decodeJsonElement();
        DeserializationStrategy<T> deserializationStrategy = this.selectDeserializer(tree);
        Intrinsics.checkNotNull(deserializationStrategy, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.json.JsonContentPolymorphicSerializer>");
        KSerializer actualSerializer = (KSerializer)deserializationStrategy;
        return input2.getJson().decodeFromJsonElement(actualSerializer, tree);
    }

    @NotNull
    protected abstract DeserializationStrategy<T> selectDeserializer(@NotNull JsonElement var1);

    private final Void throwSubtypeNotRegistered(KClass<?> subClass, KClass<?> baseClass) {
        String string = subClass.getSimpleName();
        if (string == null) {
            string = String.valueOf(subClass);
        }
        String subClassName = string;
        String scope = "in the scope of '" + baseClass.getSimpleName() + '\'';
        throw new SerializationException("Class '" + subClassName + "' is not registered for polymorphic serialization " + scope + ".\nMark the base class as 'sealed' or register the serializer explicitly.");
    }
}

