/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.utils.graphics.colors;

import gg.skytils.skytilsmod.utils.RenderUtilKt;
import gg.skytils.skytilsmod.utils.Utils;
import gg.skytils.skytilsmod.utils.graphics.colors.CustomColor;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0017\u0018\u0000 .2\u00020\u0001:\u0001.B'\u0012\u0006\u0010\u001b\u001a\u00020\n\u0012\u0006\u0010 \u001a\u00020\n\u0012\u0006\u0010)\u001a\u00020\r\u0012\u0006\u0010#\u001a\u00020\r\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\b\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0013J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010\u001c\u001a\u0004\b!\u0010\f\"\u0004\b\"\u0010\u001fR\"\u0010#\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\"\u0010)\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010$\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(\u00a8\u0006/"}, d2={"Lgg/skytils/skytilsmod/utils/graphics/colors/CyclingTwoColorGradient;", "Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "", "applyColor", "()V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "Ljava/awt/Color;", "getCurrentColor", "()Ljava/awt/Color;", "", "p", "getGradient", "(D)Ljava/awt/Color;", "", "hashCode", "()I", "", "toHSV", "()[F", "toInt", "", "toString", "()Ljava/lang/String;", "color1", "Ljava/awt/Color;", "getColor1", "setColor1", "(Ljava/awt/Color;)V", "color2", "getColor2", "setColor2", "offset", "D", "getOffset", "()D", "setOffset", "(D)V", "speed", "getSpeed", "setSpeed", "<init>", "(Ljava/awt/Color;Ljava/awt/Color;DD)V", "Companion", "SkytilsMod"})
public final class CyclingTwoColorGradient
extends CustomColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Color color1;
    @NotNull
    private Color color2;
    private double speed;
    private double offset;

    public CyclingTwoColorGradient(@NotNull Color color1, @NotNull Color color2, double speed, double offset) {
        Intrinsics.checkNotNullParameter((Object)color1, (String)"color1");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color2");
        this.color1 = color1;
        this.color2 = color2;
        this.speed = speed;
        this.offset = offset;
    }

    @NotNull
    public final Color getColor1() {
        return this.color1;
    }

    public final void setColor1(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.color1 = color;
    }

    @NotNull
    public final Color getColor2() {
        return this.color2;
    }

    public final void setColor2(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.color2 = color;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final void setSpeed(double d) {
        this.speed = d;
    }

    public final double getOffset() {
        return this.offset;
    }

    public final void setOffset(double d) {
        this.offset = d;
    }

    @NotNull
    public final Color getCurrentColor() {
        double p = ((double)System.currentTimeMillis() + this.offset) / this.speed;
        if (p > 1.0) {
            double decimal = p % 1.0;
            int whole = (int)p;
            p = whole % 2 == 0 ? decimal : 1.0 - decimal;
        }
        return this.getGradient(p);
    }

    @NotNull
    public final Color getGradient(double p) {
        double complement = 1.0 - p;
        int r = (int)((double)this.color1.getRed() * p + (double)this.color2.getRed() * complement);
        int g2 = (int)((double)this.color1.getGreen() * p + (double)this.color2.getGreen() * complement);
        int b = (int)((double)this.color1.getBlue() * p + (double)this.color2.getBlue() * complement);
        int a = (int)((double)this.color1.getAlpha() * p + (double)this.color2.getAlpha() * complement);
        return new Color(r, g2, b, a);
    }

    @Override
    public void applyColor() {
        RenderUtilKt.bindColor(this.getCurrentColor());
    }

    @Override
    @NotNull
    public float[] toHSV() {
        Color color = this.getCurrentColor();
        float r = color.getRed();
        float g2 = color.getBlue();
        float b = color.getBlue();
        float a = color.getAlpha();
        float hue = 0.0f;
        float saturation = 0.0f;
        float value = 0.0f;
        float cmax = RangesKt.coerceAtLeast((float)RangesKt.coerceAtLeast((float)r, (float)g2), (float)b);
        float cmin = Math.min(RangesKt.coerceAtMost((float)r, (float)g2), b);
        value = cmax;
        saturation = cmax == 0.0f ? 0.0f : (cmax - cmin) / cmax;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - r) / (cmax - cmin);
            float greenc = (cmax - g2) / (cmax - cmin);
            float bluec = (cmax - b) / (cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g2 == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        float[] fArray = new float[]{hue, saturation, value, a};
        return fArray;
    }

    @Override
    public int toInt() {
        return this.getCurrentColor().getRGB();
    }

    @Override
    @NotNull
    public String toString() {
        return "cyclingtwocolorgradient(" + this.color1.getRGB() + ',' + this.color2.getRGB() + ',' + this.speed + ',' + this.offset + ')';
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CyclingTwoColorGradient) {
            return this.speed == ((CyclingTwoColorGradient)other).speed && Intrinsics.areEqual((Object)this.color1, (Object)((CyclingTwoColorGradient)other).color1) && Intrinsics.areEqual((Object)this.color2, (Object)((CyclingTwoColorGradient)other).color2) && this.offset == ((CyclingTwoColorGradient)other).offset;
        }
        return false;
    }

    @Override
    public int hashCode() {
        double[] dArray = new double[]{this.color1.getRGB(), this.color2.getRGB(), this.speed};
        return Arrays.hashCode(dArray);
    }

    @JvmStatic
    @NotNull
    public static final CyclingTwoColorGradient fromString(@Nullable String string) {
        return Companion.fromString(string);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lgg/skytils/skytilsmod/utils/graphics/colors/CyclingTwoColorGradient$Companion;", "", "", "string", "Lgg/skytils/skytilsmod/utils/graphics/colors/CyclingTwoColorGradient;", "fromString", "(Ljava/lang/String;)Lgg/skytils/skytilsmod/utils/graphics/colors/CyclingTwoColorGradient;", "<init>", "()V", "SkytilsMod"})
    @SourceDebugExtension(value={"SMAP\nCyclingTwoColorGradient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CyclingTwoColorGradient.kt\ngg/skytils/skytilsmod/utils/graphics/colors/CyclingTwoColorGradient$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CyclingTwoColorGradient fromString(@Nullable String string) {
            CyclingTwoColorGradient cyclingTwoColorGradient;
            if (string == null) {
                throw new NullPointerException("Argument cannot be null!");
            }
            if (!(StringsKt.startsWith$default((String)string, (String)"cyclingtwocolorgradient(", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)string, (String)")", (boolean)false, (int)2, null))) {
                boolean $i$a$-require-CyclingTwoColorGradient$Companion$fromString$22 = false;
                String $i$a$-require-CyclingTwoColorGradient$Companion$fromString$22 = "Invalid cycling two color gradient format";
                throw new IllegalArgumentException($i$a$-require-CyclingTwoColorGradient$Companion$fromString$22.toString());
            }
            try {
                String[] $i$a$-require-CyclingTwoColorGradient$Companion$fromString$22 = new String[]{","};
                List split2 = StringsKt.split$default((CharSequence)StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)string, (String)"cyclingtwocolorgradient(", null, (int)2, null), (char)')', null, (int)2, null), (String[])$i$a$-require-CyclingTwoColorGradient$Companion$fromString$22, (boolean)false, (int)0, (int)6, null);
                Color color1 = Utils.INSTANCE.colorFromString((String)split2.get(0));
                Color color2 = Utils.INSTANCE.colorFromString((String)split2.get(1));
                double speed = Double.parseDouble((String)split2.get(2));
                double offset = Double.parseDouble((String)split2.get(3));
                cyclingTwoColorGradient = new CyclingTwoColorGradient(color1, color2, speed, offset);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Invalid cycling two color gradient string");
            }
            catch (IndexOutOfBoundsException exception) {
                throw new IllegalArgumentException("Invalid cycling two color gradient string");
            }
            return cyclingTwoColorGradient;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

