/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.parser;

import org.commonmark.node.SourceSpan;

public class SourceLine {
    private final CharSequence content;
    private final SourceSpan sourceSpan;

    public static SourceLine of(CharSequence content2, SourceSpan sourceSpan) {
        return new SourceLine(content2, sourceSpan);
    }

    private SourceLine(CharSequence content2, SourceSpan sourceSpan) {
        if (content2 == null) {
            throw new NullPointerException("content must not be null");
        }
        this.content = content2;
        this.sourceSpan = sourceSpan;
    }

    public CharSequence getContent() {
        return this.content;
    }

    public SourceSpan getSourceSpan() {
        return this.sourceSpan;
    }

    public SourceLine substring(int beginIndex, int endIndex) {
        CharSequence newContent = this.content.subSequence(beginIndex, endIndex);
        SourceSpan newSourceSpan = null;
        if (this.sourceSpan != null) {
            int columnIndex = this.sourceSpan.getColumnIndex() + beginIndex;
            int length = endIndex - beginIndex;
            if (length != 0) {
                newSourceSpan = SourceSpan.of(this.sourceSpan.getLineIndex(), columnIndex, length);
            }
        }
        return SourceLine.of(newContent, newSourceSpan);
    }
}

