/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.key;

import java.util.function.Function;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.key.CloudKey;
import org.incendo.cloud.key.CloudKeyContainer;
import org.incendo.cloud.key.CloudKeyHolder;

@API(status=API.Status.STABLE)
public interface MutableCloudKeyContainer
extends CloudKeyContainer {
    public <V> void store(@NonNull CloudKey<V> var1, V var2);

    public <V> void store(@NonNull String var1, V var2);

    default public <V> void store(@NonNull CloudKeyHolder<V> keyHolder, V value) {
        this.store(keyHolder.key(), value);
    }

    public void remove(@NonNull CloudKey<?> var1);

    default public void remove(@NonNull String key2) {
        this.remove(CloudKey.of(key2));
    }

    default public void remove(@NonNull CloudKeyHolder<?> keyHolder) {
        this.remove(keyHolder.key());
    }

    default public <V> void set(@NonNull CloudKey<V> key2, @Nullable V value) {
        if (value == null) {
            this.remove(key2);
        } else {
            this.store(key2, value);
        }
    }

    default public <V> void set(@NonNull String key2, @Nullable V value) {
        if (value == null) {
            this.remove(key2);
        } else {
            this.store(key2, value);
        }
    }

    default public <V> void set(@NonNull CloudKeyHolder<V> keyHolder, @Nullable V value) {
        if (value == null) {
            this.remove(keyHolder);
        } else {
            this.store(keyHolder, value);
        }
    }

    public <V> V computeIfAbsent(@NonNull CloudKey<V> var1, @NonNull Function<@NonNull CloudKey<V>, V> var2);

    default public <V> V computeIfAbsent(@NonNull CloudKeyHolder<V> keyHolder, @NonNull Function<@NonNull CloudKey<V>, V> defaultFunction) {
        return this.computeIfAbsent(keyHolder.key(), defaultFunction);
    }
}

