/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner;

import info.bliki.htmlcleaner.SpecialEntities;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class Utils {
    public static String VAR_START = "${";
    public static String VAR_END = "}";

    public static String ltrim(String s) {
        int index;
        if (s == null) {
            return null;
        }
        int len2 = s.length();
        for (index = 0; index < len2 && Character.isWhitespace(s.charAt(index)); ++index) {
        }
        if (index == 0) {
            return s;
        }
        return index >= len2 ? "" : s.substring(index);
    }

    public static String rtrim(String s) {
        int len2;
        int index;
        if (s == null) {
            return null;
        }
        for (index = len2 = s.length(); index > 0 && Character.isWhitespace(s.charAt(index - 1)); --index) {
        }
        if (index == len2) {
            return s;
        }
        return index <= 0 ? "" : s.substring(0, index);
    }

    public static String ltrimNewline(String s) {
        int index;
        if (s == null) {
            return null;
        }
        int len2 = s.length();
        for (index = 0; index < len2 && Character.isWhitespace(s.charAt(index)) && s.charAt(index) != '\n'; ++index) {
        }
        if (index == 0) {
            return s;
        }
        return index >= len2 ? "" : s.substring(index);
    }

    public static String trimNewlineLeft(String s) {
        int rightIndex;
        int leftIndex;
        if (s == null) {
            return null;
        }
        int len2 = s.length();
        int lastIndex = -1;
        for (leftIndex = 0; leftIndex < len2 && Character.isWhitespace(s.charAt(leftIndex)); ++leftIndex) {
            if (s.charAt(leftIndex) != '\n') continue;
            lastIndex = leftIndex;
        }
        if (lastIndex >= 0) {
            leftIndex = lastIndex;
        }
        if (leftIndex >= len2) {
            return "";
        }
        for (rightIndex = len2; rightIndex > 0 && Character.isWhitespace(s.charAt(rightIndex - 1)); --rightIndex) {
        }
        if (rightIndex <= 0) {
            return "";
        }
        if (leftIndex == 0 && rightIndex == len2) {
            return s;
        }
        return s.substring(leftIndex, rightIndex);
    }

    public static String trimNewlineRight(String s) {
        int leftIndex;
        if (s == null) {
            return null;
        }
        int len2 = s.length();
        for (leftIndex = 0; leftIndex < len2 && Character.isWhitespace(s.charAt(leftIndex)); ++leftIndex) {
        }
        if (leftIndex >= len2) {
            return "";
        }
        int rightIndex = len2;
        int lastIndex = -1;
        while (rightIndex > 0 && Character.isWhitespace(s.charAt(rightIndex - 1))) {
            if (s.charAt(--rightIndex) != '\n') continue;
            lastIndex = rightIndex + 1;
        }
        if (lastIndex >= 0) {
            rightIndex = lastIndex;
        }
        if (rightIndex <= 0) {
            return "";
        }
        if (leftIndex == 0 && rightIndex == len2) {
            return s;
        }
        return s.substring(leftIndex, rightIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer readUrl(URL url, String charset) throws IOException {
        StringBuffer buffer = new StringBuffer(1024);
        Object content = url.getContent();
        if (content instanceof InputStream) {
            char[] charArray = new char[1024];
            try (InputStreamReader reader = new InputStreamReader((InputStream)content, charset);){
                int charsRead = 0;
                do {
                    if ((charsRead = reader.read(charArray)) < 0) continue;
                    buffer.append(charArray, 0, charsRead);
                } while (charsRead > 0);
            }
        }
        return buffer;
    }

    public static boolean isHexadecimalDigit(char ch) {
        return Character.isDigit(ch) || ch == 'A' || ch == 'a' || ch == 'B' || ch == 'b' || ch == 'C' || ch == 'c' || ch == 'D' || ch == 'd' || ch == 'E' || ch == 'e' || ch == 'F' || ch == 'f';
    }

    public static String escapeXml(String s, boolean advanced, boolean recognizeUnicodeChars, boolean translateSpecialEntities) {
        if (s != null && s.length() != 0) {
            int len2 = s.length();
            StringBuilder result2 = new StringBuilder(len2 + len2 / 10);
            try {
                Utils.escapeXmlToBuffer(s, result2, advanced, recognizeUnicodeChars, translateSpecialEntities);
            }
            catch (IOException e2) {
                return "Error in escapeXml: IOException";
            }
            return result2.toString();
        }
        return "";
    }

    public static void escapeXmlToBuffer(String s, Appendable result2, boolean advanced, boolean recognizeUnicodeChars, boolean translateSpecialEntities) throws IOException {
        Utils.escapeXmlToBuffer(s, result2, advanced, recognizeUnicodeChars, translateSpecialEntities, false);
    }

    public static void escapeXmlToBuffer(String s, Appendable result2, boolean advanced, boolean recognizeUnicodeChars, boolean translateSpecialEntities, boolean plainText) throws IOException {
        if (s != null) {
            int len2 = s.length();
            for (int i = 0; i < len2; ++i) {
                char ch = s.charAt(i);
                if (ch == '&') {
                    String entity;
                    Integer code;
                    String seq2;
                    int semiIndex;
                    if (recognizeUnicodeChars && i < len2 - 1 && s.charAt(i + 1) == '#') {
                        int charIndex;
                        String unicode = "";
                        for (charIndex = i + 2; charIndex < len2 && (Utils.isHexadecimalDigit(s.charAt(charIndex)) || s.charAt(charIndex) == 'x' || s.charAt(charIndex) == 'X'); ++charIndex) {
                            unicode = unicode + s.charAt(charIndex);
                        }
                        if (charIndex == len2 || !"".equals(unicode)) {
                            try {
                                char unicodeChar;
                                char c = unicodeChar = unicode.toLowerCase().startsWith("x") ? (char)Integer.parseInt(unicode.substring(1), 16) : (char)Integer.parseInt(unicode);
                                if ("&<>'\"".indexOf(unicodeChar) < 0) {
                                    int replaceChunkSize = charIndex < len2 && s.charAt(charIndex) == ';' ? unicode.length() + 1 : unicode.length();
                                    result2.append(String.valueOf(unicodeChar));
                                    i += replaceChunkSize + 1;
                                    continue;
                                }
                                i = charIndex;
                                result2.append("&#" + unicode + ";");
                            }
                            catch (NumberFormatException e2) {
                                i = charIndex;
                                result2.append("&amp;#" + unicode + ";");
                            }
                            continue;
                        }
                        result2.append("&amp;");
                        continue;
                    }
                    if (translateSpecialEntities && (semiIndex = (seq2 = s.substring(i, i + Math.min(10, len2 - i))).indexOf(59)) > 0 && (code = SpecialEntities.entities.get(entity = seq2.substring(1, semiIndex))) != null) {
                        char unicodeChar;
                        int entityLen = entity.length();
                        if (recognizeUnicodeChars && "&<>'\"".indexOf(unicodeChar = (char)code.intValue()) < 0) {
                            result2.append(String.valueOf(unicodeChar));
                            i += entityLen + 1;
                            continue;
                        }
                        result2.append("&#");
                        result2.append(Integer.toString(code));
                        result2.append(";");
                        i += entityLen + 1;
                        continue;
                    }
                    if (advanced) {
                        String sub2 = s.substring(i);
                        if (sub2.startsWith("&amp;")) {
                            result2.append("&#38;");
                            i += 4;
                            continue;
                        }
                        if (sub2.startsWith("&apos;")) {
                            result2.append("&#39;");
                            i += 5;
                            continue;
                        }
                        if (sub2.startsWith("&gt;")) {
                            result2.append("&#62;");
                            i += 3;
                            continue;
                        }
                        if (sub2.startsWith("&lt;")) {
                            result2.append("&#60;");
                            i += 3;
                            continue;
                        }
                        if (sub2.startsWith("&quot;")) {
                            result2.append("&#34;");
                            i += 5;
                            continue;
                        }
                        if (sub2.startsWith("&nbsp;")) {
                            result2.append("&#160;");
                            i += 5;
                            continue;
                        }
                        result2.append("&#38;");
                        continue;
                    }
                    if (plainText) {
                        String sub3 = s.substring(i);
                        if (sub3.startsWith("&amp;")) {
                            result2.append("&");
                            i += 4;
                            continue;
                        }
                        if (sub3.startsWith("&#38;")) {
                            result2.append("&");
                            i += 4;
                            continue;
                        }
                        if (sub3.startsWith("&apos;")) {
                            result2.append("'");
                            i += 5;
                            continue;
                        }
                        if (sub3.startsWith("&#39;")) {
                            result2.append("'");
                            i += 4;
                            continue;
                        }
                        if (sub3.startsWith("&gt;")) {
                            result2.append(">");
                            i += 3;
                            continue;
                        }
                        if (sub3.startsWith("&#62;")) {
                            result2.append(">");
                            i += 4;
                            continue;
                        }
                        if (sub3.startsWith("&lt;")) {
                            result2.append("<");
                            i += 3;
                            continue;
                        }
                        if (sub3.startsWith("&#60;")) {
                            result2.append("<");
                            i += 4;
                            continue;
                        }
                        if (sub3.startsWith("&quot;")) {
                            result2.append("\"");
                            i += 5;
                            continue;
                        }
                        if (sub3.startsWith("&#34;")) {
                            result2.append("\"");
                            i += 4;
                            continue;
                        }
                        if (sub3.startsWith("&nbsp;")) {
                            result2.append(" ");
                            i += 5;
                            continue;
                        }
                        if (sub3.startsWith("&#160;")) {
                            result2.append(" ");
                            i += 5;
                            continue;
                        }
                        result2.append("&");
                        continue;
                    }
                    result2.append("&amp;");
                    continue;
                }
                if (plainText) {
                    result2.append(ch);
                    continue;
                }
                if (ch == '\'') {
                    result2.append("&#39;");
                    continue;
                }
                if (ch == '>') {
                    result2.append("&#62;");
                    continue;
                }
                if (ch == '<') {
                    result2.append("&#60;");
                    continue;
                }
                if (ch == '\"') {
                    result2.append("&#34;");
                    continue;
                }
                result2.append(ch);
            }
        }
    }

    public static String escapeXmlChars(String s) {
        if (s != null) {
            int len2 = s.length();
            StringBuilder result2 = new StringBuilder(len2 + len2 / 10);
            for (int i = 0; i < len2; ++i) {
                char ch = s.charAt(i);
                if (ch == '\'') {
                    result2.append("&apos;");
                    continue;
                }
                if (ch == '>') {
                    result2.append("&gt;");
                    continue;
                }
                if (ch == '<') {
                    result2.append("&lt;");
                    continue;
                }
                if (ch == '\"') {
                    result2.append("&quot;");
                    continue;
                }
                result2.append(ch);
            }
            return result2.toString();
        }
        return null;
    }

    public static void appendAmpersandEscapedAttribute(StringBuilder writer, String attributeName, Map<String, String> tagAtttributes) {
        String attributeValue = tagAtttributes.get(attributeName);
        if (attributeValue != null) {
            if (writer.length() > 0) {
                writer.append("&amp;");
            }
            writer.append(attributeName);
            writer.append("=");
            try {
                writer.append(URLEncoder.encode(attributeValue, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void appendEscapedAttribute(Appendable writer, String attributeName, Map<String, String> tagAtttributes) throws IOException {
        String attributeValue = tagAtttributes.get(attributeName);
        if (attributeValue != null) {
            Utils.escapeXmlToBuffer(attributeValue, writer, false, false, false);
        }
    }

    public static String evaluateTemplate(String template, Map<String, String> variables) {
        if (template == null) {
            return template;
        }
        StringBuffer result2 = new StringBuffer();
        int startIndex = template.indexOf(VAR_START);
        int endIndex = -1;
        while (startIndex >= 0 && startIndex < template.length()) {
            result2.append(template.substring(endIndex + 1, startIndex));
            endIndex = template.indexOf(VAR_END, startIndex);
            if (endIndex > startIndex) {
                String varName = template.substring(startIndex + VAR_START.length(), endIndex);
                String resultObj = variables != null ? variables.get(varName.toLowerCase()) : "";
                result2.append(resultObj == null ? "" : resultObj.toString());
            }
            startIndex = template.indexOf(VAR_START, Math.max(endIndex + VAR_END.length(), startIndex + 1));
        }
        result2.append(template.substring(endIndex + 1));
        return result2.toString();
    }
}

