/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.code;

import info.bliki.wiki.tags.code.AbstractCPPBasedCodeFilter;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import java.util.HashMap;

public class SQLCodeFilter
extends AbstractCPPBasedCodeFilter
implements SourceCodeFormatter {
    private static final String[] KEYWORDS = new String[]{"alter", "and", "blob", "boolean", "character", "clob", "column", "comment", "constraint", "create", "default", "delete", "drop", "false", "from", "in", "insert", "integer", "is", "key", "lob", "not", "null", "on", "or", "procedure", "references", "select", "set", "table", "timestamp", "true", "update", "varchar", "where"};
    private static HashMap<String, String> KEYWORD_SET = new HashMap();

    @Override
    public HashMap<String, String> getKeywordSet() {
        return KEYWORD_SET;
    }

    @Override
    public HashMap<String, String> getObjectSet() {
        return null;
    }

    @Override
    public String filter(String input) {
        char[] source = input.toCharArray();
        int currentPosition = 0;
        int identStart = 0;
        char currentChar = ' ';
        HashMap<String, String> keywordsSet = this.getKeywordSet();
        HashMap<String, String> objectsSet = this.getObjectSet();
        StringBuilder result2 = new StringBuilder(input.length() + input.length() / 4);
        boolean identFound = false;
        try {
            while (true) {
                if ((currentChar = source[currentPosition++]) >= 'A' && currentChar <= 'Z' || currentChar == '_' || currentChar >= 'a' && currentChar <= 'z') {
                    identStart = currentPosition - 1;
                    identFound = true;
                    while (currentChar >= 'a' && currentChar <= 'z' || currentChar >= 'A' && currentChar <= 'Z' || currentChar == '_') {
                        currentChar = source[currentPosition++];
                    }
                    currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, objectsSet, result2);
                    identFound = false;
                    continue;
                }
                if (currentChar == '\"') {
                    result2.append("<span style=\"color:#2A00FF; \">");
                    SQLCodeFilter.appendChar(result2, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        SQLCodeFilter.appendChar(result2, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            SQLCodeFilter.appendChar(result2, currentChar);
                            continue;
                        }
                        if (currentChar != 34) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                if (currentChar == '\'') {
                    result2.append("<span style=\"color:#2A00FF; \">");
                    SQLCodeFilter.appendChar(result2, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        SQLCodeFilter.appendChar(result2, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            SQLCodeFilter.appendChar(result2, currentChar);
                            continue;
                        }
                        if (currentChar != 39) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                if (currentChar == '\n' && currentPosition < input.length() - 1 && source[currentPosition] == '-' && source[currentPosition + 1] == '-') {
                    result2.append("<span style=\"color:#3F7F5F; \">");
                    SQLCodeFilter.appendChar(result2, currentChar);
                    SQLCodeFilter.appendChar(result2, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        SQLCodeFilter.appendChar(result2, currentChar);
                        if (currentChar != 10) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                SQLCodeFilter.appendChar(result2, currentChar);
            }
        }
        catch (IndexOutOfBoundsException e2) {
            if (identFound) {
                currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, null, result2);
            }
            return result2.toString();
        }
    }

    @Override
    public boolean isKeywordCaseSensitive() {
        return false;
    }

    static {
        for (String k : KEYWORDS) {
            SQLCodeFilter.createHashMap(KEYWORD_SET, k);
        }
    }
}

