/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.auction.APIManager;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.RepositoryReloadEvent;
import io.github.moulberry.notenoughupdates.miscgui.GuiItemRecipe;
import io.github.moulberry.notenoughupdates.miscgui.KatSitterOverlay;
import io.github.moulberry.notenoughupdates.options.customtypes.NEUDebugFlag;
import io.github.moulberry.notenoughupdates.recipes.CraftingOverlay;
import io.github.moulberry.notenoughupdates.recipes.CraftingRecipe;
import io.github.moulberry.notenoughupdates.recipes.Ingredient;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.recipes.RecipeHistory;
import io.github.moulberry.notenoughupdates.util.ApiUtil;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.UrsaClient;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;

public class NEUManager {
    private final NotEnoughUpdates neu;
    public final Gson gson;
    public final APIManager auctionManager;
    private final TreeMap<String, JsonObject> itemMap = new TreeMap();
    private boolean hasBeenLoadedBefore = false;
    public final TreeMap<String, HashMap<String, List<Integer>>> titleWordMap = new TreeMap();
    private final TreeMap<String, HashMap<String, List<Integer>>> loreWordMap = new TreeMap();
    public final KeyBinding keybindGive = new KeyBinding("Add item to inventory (Creative-only)", 38, "NotEnoughUpdates");
    public final KeyBinding keybindFavourite = new KeyBinding("Set item as favourite", 33, "NotEnoughUpdates");
    public final KeyBinding keybindViewUsages = new KeyBinding("Show usages for item", 22, "NotEnoughUpdates");
    public final KeyBinding keybindViewRecipe = new KeyBinding("Show recipe for item", 19, "NotEnoughUpdates");
    public final KeyBinding keybindPreviousRecipe = new KeyBinding("Show previous recipe", 26, "NotEnoughUpdates");
    public final KeyBinding keybindNextRecipe = new KeyBinding("Show next recipe", 27, "NotEnoughUpdates");
    public final KeyBinding keybindToggleDisplay = new KeyBinding("Toggle NEU overlay", 0, "NotEnoughUpdates");
    public final KeyBinding keybindClosePanes = new KeyBinding("Close NEU panes", 0, "NotEnoughUpdates");
    public final KeyBinding keybindItemSelect = new KeyBinding("Select Item", -98, "NotEnoughUpdates");
    public final KeyBinding[] keybinds = new KeyBinding[]{this.keybindGive, this.keybindFavourite, this.keybindViewUsages, this.keybindViewRecipe, this.keybindPreviousRecipe, this.keybindNextRecipe, this.keybindToggleDisplay, this.keybindClosePanes, this.keybindItemSelect};
    public String viewItemAttemptID = null;
    public long viewItemAttemptTime = 0L;
    public final ApiUtil apiUtils = new ApiUtil();
    public final UrsaClient ursaClient = new UrsaClient(this.apiUtils);
    private final Map<String, ItemStack> itemstackCache = new HashMap<String, ItemStack>();
    private final Set<NeuRecipe> recipes = new HashSet<NeuRecipe>();
    private final HashMap<String, Set<NeuRecipe>> recipesMap = new HashMap();
    private final HashMap<String, Set<NeuRecipe>> usagesMap = new HashMap();
    private final Map<String, String> displayNameCache = new HashMap<String, String>();
    public String latestRepoCommit = null;
    public File configLocation;
    public File repoLocation;
    public KatSitterOverlay katSitterOverlay;
    public CraftingOverlay craftingOverlay;
    private static boolean repoDownloadFailed = false;
    public boolean onBackupRepo = false;
    long lastKeybind = -1L;

    public NEUManager(NotEnoughUpdates neu, File configLocation) {
        this.neu = neu;
        this.configLocation = configLocation;
        this.auctionManager = new APIManager(this);
        this.craftingOverlay = new CraftingOverlay(this);
        this.katSitterOverlay = new KatSitterOverlay();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.repoLocation = new File(configLocation, "repo");
        this.repoLocation.mkdir();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject getJsonFromFile(File file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            JsonObject json;
            JsonObject jsonObject = json = this.gson.fromJson((Reader)reader, JsonObject.class);
            return jsonObject;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public void resetRepo() {
        try {
            Utils.recursiveDelete(new File(this.configLocation, "repo"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new File(this.configLocation, "currentCommit.json").delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CompletableFuture<Boolean> fetchRepository() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject currentCommitJSON = this.getJsonFromFile(new File(this.configLocation, "currentCommit.json"));
                this.latestRepoCommit = null;
                try (InputStreamReader inReader = new InputStreamReader(new URL(this.neu.config.apiData.getCommitApiUrl()).openStream());){
                    JsonObject commits = this.gson.fromJson((Reader)inReader, JsonObject.class);
                    this.latestRepoCommit = commits.get("sha").getAsString();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                if (this.latestRepoCommit == null || this.latestRepoCommit.isEmpty()) {
                    repoDownloadFailed = true;
                    return false;
                }
                if (new File(this.configLocation, "repo").exists() && new File(this.configLocation, "repo/items").exists() && currentCommitJSON != null && currentCommitJSON.get("sha").getAsString().equals(this.latestRepoCommit)) {
                    return false;
                }
                this.repoLocation.mkdirs();
                File itemsZip = new File(this.repoLocation, "neu-items-master.zip");
                try {
                    itemsZip.createNewFile();
                }
                catch (IOException e3) {
                    return false;
                }
                URL url = new URL(this.neu.config.apiData.getDownloadUrl(this.latestRepoCommit));
                URLConnection urlConnection = url.openConnection();
                urlConnection.setConnectTimeout(15000);
                urlConnection.setReadTimeout(30000);
                Utils.recursiveDelete(this.repoLocation);
                this.repoLocation.mkdirs();
                try (InputStream is = urlConnection.getInputStream();){
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)itemsZip);
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                    System.err.println("Failed to download NEU Repo! Please report this issue to the mod creator");
                    repoDownloadFailed = true;
                    return false;
                }
                NEUManager.unzipIgnoreFirstFolder(itemsZip.getAbsolutePath(), this.repoLocation.getAbsolutePath());
                if (currentCommitJSON == null || !currentCommitJSON.get("sha").getAsString().equals(this.latestRepoCommit)) {
                    JsonObject newCurrentCommitJSON = new JsonObject();
                    newCurrentCommitJSON.addProperty("sha", this.latestRepoCommit);
                    try {
                        this.writeJson(newCurrentCommitJSON, new File(this.configLocation, "currentCommit.json"));
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e5) {
                e5.printStackTrace();
            }
            return true;
        });
    }

    public void loadItemInformation() {
        if (NotEnoughUpdates.INSTANCE.config.apiData.autoupdate_new) {
            ((CompletableFuture)this.fetchRepository().thenRun(() -> {
                if (repoDownloadFailed) {
                    System.out.println("switching over to the backup repo");
                    this.switchToBackupRepo();
                }
            })).thenRun(this::reloadRepository);
        } else {
            this.reloadRepository();
        }
    }

    public void switchToBackupRepo() {
        Path destination = new File(this.repoLocation, "neu-items-master.zip").toPath();
        this.onBackupRepo = true;
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("assets/notenoughupdates/repo.zip");){
            if (inputStream == null) {
                System.out.println("Failed to copy backup repo");
                return;
            }
            Files.copy(inputStream, destination, StandardCopyOption.REPLACE_EXISTING);
            NEUManager.unzipIgnoreFirstFolder(destination.toAbsolutePath().toString(), this.repoLocation.getAbsolutePath());
            JsonObject newCurrentCommitJSON = new JsonObject();
            newCurrentCommitJSON.addProperty("sha", "backuprepo");
            try {
                this.writeJson(newCurrentCommitJSON, new File(this.configLocation, "currentCommit.json"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("Successfully switched to backup repo");
        }
        catch (IOException e2) {
            e2.printStackTrace();
            System.out.println("Failed to load backup repo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItem(String internalName) {
        block22: {
            this.removeItemFromCache(internalName);
            try {
                TreeMap<String, HashMap<String, List<Integer>>> treeMap;
                JsonObject recipe;
                NeuRecipe neuRecipe;
                JsonObject json = this.getJsonFromFile(this.getItemFileForInternalName(internalName));
                if (json == null) {
                    return;
                }
                if (json.get("itemid") == null) {
                    return;
                }
                String itemid = json.get("itemid").getAsString();
                Item mcitem = Item.func_111206_d((String)itemid);
                if (mcitem != null) {
                    itemid = mcitem.getRegistryName();
                }
                json.addProperty("itemid", itemid);
                this.itemMap.put(internalName, json);
                if (json.has("recipe") && (neuRecipe = NeuRecipe.parseRecipe(this, recipe = json.getAsJsonObject("recipe"), json)) != null) {
                    this.registerNeuRecipe(neuRecipe);
                }
                if (json.has("recipes")) {
                    for (JsonElement element : json.getAsJsonArray("recipes")) {
                        JsonObject recipe2 = element.getAsJsonObject();
                        NeuRecipe neuRecipe2 = NeuRecipe.parseRecipe(this, recipe2, json);
                        if (neuRecipe2 == null) continue;
                        this.registerNeuRecipe(neuRecipe2);
                    }
                }
                if (json.has("displayname")) {
                    treeMap = this.titleWordMap;
                    synchronized (treeMap) {
                        int wordIndex = 0;
                        for (String string : json.get("displayname").getAsString().split(" ")) {
                            String string2 = NEUManager.cleanForTitleMapSearch(string);
                            if (!this.titleWordMap.containsKey(string2)) {
                                this.titleWordMap.put(string2, new HashMap());
                            }
                            if (!this.titleWordMap.get(string2).containsKey(internalName)) {
                                this.titleWordMap.get(string2).put(internalName, new ArrayList());
                            }
                            this.titleWordMap.get(string2).get(internalName).add(wordIndex);
                            ++wordIndex;
                        }
                    }
                }
                if (!json.has("lore")) break block22;
                treeMap = this.loreWordMap;
                synchronized (treeMap) {
                    int wordIndex = 0;
                    for (JsonElement element : json.get("lore").getAsJsonArray()) {
                        for (String str : element.getAsString().split(" ")) {
                            if (!this.loreWordMap.containsKey(str = NEUManager.cleanForTitleMapSearch(str))) {
                                this.loreWordMap.put(str, new HashMap());
                            }
                            if (!this.loreWordMap.get(str).containsKey(internalName)) {
                                this.loreWordMap.get(str).put(internalName, new ArrayList());
                            }
                            this.loreWordMap.get(str).get(internalName).add(wordIndex);
                            ++wordIndex;
                        }
                    }
                }
            }
            catch (Exception e2) {
                System.out.println("internalName is : " + internalName);
                e2.printStackTrace();
            }
        }
    }

    public void registerNeuRecipe(NeuRecipe recipe) {
        this.recipes.add(recipe);
        for (Ingredient output : recipe.getOutputs()) {
            this.recipesMap.computeIfAbsent(output.getInternalItemId(), ignored -> new HashSet()).add(recipe);
        }
        for (Ingredient input : recipe.getIngredients()) {
            this.usagesMap.computeIfAbsent(input.getInternalItemId(), ignored -> new HashSet()).add(recipe);
        }
        for (Ingredient catalystItem : recipe.getCatalystItems()) {
            this.recipesMap.computeIfAbsent(catalystItem.getInternalItemId(), ignored -> new HashSet()).add(recipe);
            this.usagesMap.computeIfAbsent(catalystItem.getInternalItemId(), ignored -> new HashSet()).add(recipe);
        }
    }

    public Set<NeuRecipe> getRecipesFor(String internalName) {
        return this.recipesMap.getOrDefault(internalName, Collections.emptySet());
    }

    public List<NeuRecipe> getAvailableRecipesFor(String internalname) {
        return this.getRecipesFor(internalname).stream().filter(NeuRecipe::isAvailable).collect(Collectors.toList());
    }

    public HashMap<String, Set<NeuRecipe>> getAllRecipes() {
        return this.recipesMap;
    }

    public Set<NeuRecipe> getUsagesFor(String internalName) {
        return this.usagesMap.getOrDefault(internalName, Collections.emptySet());
    }

    public List<NeuRecipe> getAvailableUsagesFor(String internalname) {
        return this.getUsagesFor(internalname).stream().filter(NeuRecipe::isAvailable).collect(Collectors.toList());
    }

    private String searchDebug(String[] searchArray, ArrayList<DebugMatch> debugMatches) {
        String ANSI_RED = "\u001b[31m";
        String ANSI_RESET = "\u001b[0m";
        String ANSI_YELLOW = "\u001b[33m";
        StringBuilder debugBuilder = new StringBuilder();
        for (int i = 0; i < searchArray.length; ++i) {
            int fi = i;
            Object[] matches = debugMatches.stream().filter(d -> d.index == fi).toArray();
            if (matches.length > 0) {
                debugBuilder.append("\u001b[33m[").append(((DebugMatch)matches[0]).match).append("]");
                debugBuilder.append("\u001b[31m[").append(searchArray[i]).append("]").append("\u001b[0m").append(" ");
                continue;
            }
            debugBuilder.append(searchArray[i]).append(" ");
        }
        return debugBuilder.toString();
    }

    public boolean multiSearchString(String match2, String query) {
        boolean totalMatches = false;
        StringBuilder query2 = new StringBuilder();
        int lastOp = 124;
        for (int n : query.toCharArray()) {
            if (n == 124 || n == 38) {
                boolean matches = this.searchString(match2, query2.toString());
                totalMatches = lastOp == 124 ? totalMatches || matches : totalMatches && matches;
                query2 = new StringBuilder();
                lastOp = n;
                continue;
            }
            query2.append((char)n);
        }
        boolean matches = this.searchString(match2, query2.toString());
        totalMatches = lastOp == 124 ? totalMatches || matches : totalMatches && matches;
        return totalMatches;
    }

    public boolean searchString(String toSearch, String query) {
        String ANSI_RESET = "\u001b[0m";
        String ANSI_YELLOW = "\u001b[33m";
        int lastStringMatch = -1;
        ArrayList<DebugMatch> debugMatches = new ArrayList<DebugMatch>();
        toSearch = NEUManager.cleanForTitleMapSearch(toSearch).toLowerCase(Locale.ROOT);
        query = NEUManager.cleanForTitleMapSearch(query).toLowerCase(Locale.ROOT);
        String[] splitToSearch = toSearch.split(" ");
        String[] queryArray = query.split(" ");
        String currentSearch = queryArray[0];
        int queryIndex = 0;
        boolean matchedLastQueryItem = false;
        for (int k = 0; k < splitToSearch.length; ++k) {
            if (queryIndex - 1 != -1 && queryArray.length - queryIndex > splitToSearch.length - k) continue;
            if (splitToSearch[k].startsWith(currentSearch)) {
                if ((lastStringMatch != -1 ? lastStringMatch : k - 1) != k - 1) continue;
                debugMatches.add(new DebugMatch(k, currentSearch));
                lastStringMatch = k;
                if (queryIndex + 1 != queryArray.length) {
                    currentSearch = queryArray[++queryIndex];
                    continue;
                }
                matchedLastQueryItem = true;
                continue;
            }
            if (queryIndex == 0) continue;
            queryIndex = 0;
            currentSearch = queryArray[queryIndex];
            lastStringMatch = -1;
        }
        if (matchedLastQueryItem) {
            if (NEUDebugFlag.SEARCH.isSet()) {
                NotEnoughUpdates.LOGGER.info("Found match for \"\u001b[33m" + query + "\u001b[0m" + "\":\n\t" + this.searchDebug(splitToSearch, debugMatches));
            }
        } else if (NEUDebugFlag.SEARCH.isSet() && lastStringMatch != -1) {
            NotEnoughUpdates.LOGGER.info("Found partial match for \"\u001b[33m" + query + "\u001b[0m" + "\":\n\t" + this.searchDebug(splitToSearch, debugMatches));
        }
        return matchedLastQueryItem;
    }

    public boolean doesStackMatchSearch(ItemStack stack, String query) {
        NBTTagCompound display;
        NBTTagCompound tag;
        if (query.startsWith("title:")) {
            query = query.substring(6);
            return this.multiSearchString(stack.func_82833_r(), query);
        }
        if (query.startsWith("desc:")) {
            NBTTagCompound display2;
            query = query.substring(5);
            String lore = "";
            NBTTagCompound tag2 = stack.func_77978_p();
            if (tag2 != null && (display2 = tag2.func_74775_l("display")).func_150297_b("Lore", 9)) {
                NBTTagList list = display2.func_150295_c("Lore", 8);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    lore = lore + list.func_150307_f(i) + " ";
                }
            }
            return this.multiSearchString(lore, query);
        }
        if (query.startsWith("id:")) {
            query = query.substring(3);
            String internalName = this.getInternalNameForItem(stack);
            return query.equalsIgnoreCase(internalName);
        }
        boolean result2 = false;
        if (!query.trim().contains(" ")) {
            StringBuilder sb = new StringBuilder();
            for (char c : query.toCharArray()) {
                sb.append(c).append(" ");
            }
            result2 = result2 || this.multiSearchString(stack.func_82833_r(), sb.toString());
        }
        result2 = result2 || this.multiSearchString(stack.func_82833_r(), query);
        String lore = "";
        if (stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER) {
            lore = String.format("#%06x ", ((ItemArmor)stack.func_77973_b()).func_82814_b(stack));
        }
        if ((tag = stack.func_77978_p()) != null && (display = tag.func_74775_l("display")).func_150297_b("Lore", 9)) {
            NBTTagList list = display.func_150295_c("Lore", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                lore = lore + list.func_150307_f(i) + " ";
            }
        }
        result2 = result2 || this.multiSearchString(lore, query);
        return result2;
    }

    public Set<String> search(String query, boolean multi) {
        if (multi) {
            HashSet<String> result2 = new HashSet<String>();
            StringBuilder query2 = new StringBuilder();
            int lastOp = 124;
            for (int n : query.toCharArray()) {
                if (n == 124 || n == 38) {
                    if (lastOp == 124) {
                        result2.addAll(this.search(query2.toString()));
                    } else if (lastOp == 38) {
                        result2.retainAll(this.search(query2.toString()));
                    }
                    query2 = new StringBuilder();
                    lastOp = n;
                    continue;
                }
                query2.append((char)n);
            }
            if (lastOp == 124) {
                result2.addAll(this.search(query2.toString()));
            } else if (lastOp == 38) {
                result2.retainAll(this.search(query2.toString()));
            }
            return result2;
        }
        return this.search(query);
    }

    public Set<String> search(String query) {
        boolean negate = (query = query.trim()).startsWith("!");
        if (negate) {
            query = query.substring(1);
        }
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        if (query.startsWith("title:")) {
            query = query.substring(6);
            results.addAll(new TreeSet<String>(this.search(query, this.titleWordMap)));
        } else if (query.startsWith("desc:")) {
            query = query.substring(5);
            results.addAll(new TreeSet<String>(this.search(query, this.loreWordMap)));
        } else if (query.startsWith("id:")) {
            query = query.substring(3);
            results.addAll(new TreeSet<String>(this.subMapWithKeysThatAreSuffixes(query.toUpperCase(Locale.ROOT), this.itemMap).keySet()));
        } else {
            if (!query.trim().contains(" ")) {
                StringBuilder sb = new StringBuilder();
                for (char c : query.toCharArray()) {
                    sb.append(c).append(" ");
                }
                results.addAll(new TreeSet<String>(this.search(sb.toString(), this.titleWordMap)));
            }
            results.addAll(new TreeSet<String>(this.search(query, this.titleWordMap)));
            results.addAll(new TreeSet<String>(this.search(query, this.loreWordMap)));
        }
        if (!negate) {
            return results;
        }
        HashSet<String> negatedResults = new HashSet<String>();
        Object object = this.itemMap.keySet().iterator();
        while (object.hasNext()) {
            String internalname = (String)object.next();
            negatedResults.add(internalname);
        }
        negatedResults.removeAll(results);
        return negatedResults;
    }

    public Set<String> search(String query, TreeMap<String, HashMap<String, List<Integer>>> wordMap) {
        HashMap matches = null;
        query = NEUManager.cleanForTitleMapSearch(query).toLowerCase(Locale.ROOT);
        for (String queryWord : query.split(" ")) {
            HashMap matchesToKeep = new HashMap();
            for (HashMap<String, List<Integer>> wordMatches : this.subMapWithKeysThatAreSuffixes(queryWord, wordMap).values()) {
                if (wordMatches == null || wordMatches.isEmpty()) continue;
                if (matches == null) {
                    for (String internalname : wordMatches.keySet()) {
                        if (!matchesToKeep.containsKey(internalname)) {
                            matchesToKeep.put(internalname, new ArrayList());
                        }
                        ((List)matchesToKeep.get(internalname)).addAll((Collection)wordMatches.get(internalname));
                    }
                    continue;
                }
                for (String internalname : matches.keySet()) {
                    if (!wordMatches.containsKey(internalname)) continue;
                    for (Integer newIndex : wordMatches.get(internalname)) {
                        if (!((List)matches.get(internalname)).contains(newIndex - 1)) continue;
                        if (!matchesToKeep.containsKey(internalname)) {
                            matchesToKeep.put(internalname, new ArrayList());
                        }
                        ((List)matchesToKeep.get(internalname)).add(newIndex);
                    }
                }
            }
            if (matchesToKeep.isEmpty()) {
                return new HashSet<String>();
            }
            matches = matchesToKeep;
        }
        return matches.keySet();
    }

    public <T> Map<String, T> subMapWithKeysThatAreSuffixes(String prefix, NavigableMap<String, T> map2) {
        if ("".equals(prefix)) {
            return map2;
        }
        String lastKey = this.createLexicographicallyNextStringOfTheSameLength(prefix);
        return map2.subMap(prefix, true, lastKey, false);
    }

    public String createLexicographicallyNextStringOfTheSameLength(String input) {
        int lastCharPosition = input.length() - 1;
        String inputWithoutLastChar = input.substring(0, lastCharPosition);
        char lastChar = input.charAt(lastCharPosition);
        char incrementedLastChar = (char)(lastChar + '\u0001');
        return inputWithoutLastChar + incrementedLastChar;
    }

    public static String getUUIDFromNBT(NBTTagCompound tag) {
        NBTTagCompound ea;
        String uuid = null;
        if (tag != null && tag.func_150297_b("ExtraAttributes", 10) && (ea = tag.func_74775_l("ExtraAttributes")).func_150297_b("uuid", 8)) {
            uuid = ea.func_74779_i("uuid");
        }
        return uuid;
    }

    public String getSkullValueFromNBT(NBTTagCompound tag) {
        if (tag != null && tag.func_150297_b("SkullOwner", 10)) {
            NBTTagCompound ea = tag.func_74775_l("SkullOwner");
            NBTTagCompound ea3 = tag.func_74775_l("display");
            if (ea.func_150297_b("Properties", 10)) {
                NBTTagCompound ea2 = ea;
                ea = ea.func_74775_l("Properties");
                ea = ea.func_150295_c("textures", 10).func_150305_b(0);
                String name = ea3.func_74779_i("Name").replaceAll(" M{0,4}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})$", "");
                return "put(\"ID\", Utils.createSkull(EnumChatFormatting.AQUA + \"" + name + "\" ,\"" + ea2.func_74779_i("Id") + "\", \"" + ea.func_74779_i("Value") + "\"));";
            }
        }
        return null;
    }

    public String[] getLoreFromNBT(NBTTagCompound tag) {
        return ItemUtils.getLore(tag).toArray(new String[0]);
    }

    public JsonObject getJsonFromNBT(NBTTagCompound tag) {
        return this.getJsonFromNBTEntry(tag.func_150295_c("i", 10).func_150305_b(0));
    }

    public JsonObject getJsonFromNBTEntry(NBTTagCompound tag) {
        String internalname;
        if (tag.func_150296_c().size() == 0) {
            return null;
        }
        int id = tag.func_74765_d("id");
        short damage = tag.func_74765_d("Damage");
        short count = tag.func_74765_d("Count");
        tag = tag.func_74775_l("tag");
        if (id == 141) {
            id = 391;
        }
        if ((internalname = this.createItemResolutionQuery().withItemNBT(tag).resolveInternalName()) == null) {
            return null;
        }
        NBTTagCompound display = tag.func_74775_l("display");
        String[] lore = this.getLoreFromNBT(tag);
        Item itemMc = Item.func_150899_d((int)id);
        String itemid = "null";
        if (itemMc != null) {
            itemid = itemMc.getRegistryName();
        }
        String displayName = display.func_74779_i("Name");
        JsonObject item = new JsonObject();
        item.addProperty("internalname", internalname);
        item.addProperty("itemid", itemid);
        item.addProperty("displayname", displayName);
        if (tag != null && tag.func_150297_b("ExtraAttributes", 10)) {
            NBTTagCompound ea = tag.func_74775_l("ExtraAttributes");
            byte[] bytes = null;
            for (String key : ea.func_150296_c()) {
                if (!key.endsWith("backpack_data") && !key.equals("new_year_cake_bag_data")) continue;
                bytes = ea.func_74770_j(key);
                break;
            }
            if (bytes != null) {
                JsonArray bytesArr = new JsonArray();
                for (byte b : bytes) {
                    bytesArr.add(new JsonPrimitive(b));
                }
                item.add("item_contents", bytesArr);
            }
            if (ea.func_74764_b("dungeon_item_level")) {
                item.addProperty("dungeon_item_level", ea.func_74762_e("dungeon_item_level"));
            }
        }
        if (lore != null && lore.length > 0) {
            JsonArray jsonLore = new JsonArray();
            for (String line : lore) {
                jsonLore.add(new JsonPrimitive(line));
            }
            item.add("lore", jsonLore);
        }
        item.addProperty("damage", damage);
        if (count > 1) {
            item.addProperty("count", count);
        }
        item.addProperty("nbttag", tag.toString());
        return item;
    }

    public static String cleanForTitleMapSearch(String str) {
        return str.replaceAll("(\u00a7.)|[^#0-9a-zA-Z ]", "").toLowerCase(Locale.ROOT).trim();
    }

    public void showRecipe(JsonObject item) {
        Optional<NeuRecipe> recipe;
        ContainerChest container = null;
        if (Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof ContainerChest) {
            container = (ContainerChest)Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        }
        String internalName = item.get("internalname").getAsString();
        Set<NeuRecipe> recipesFor = this.getRecipesFor(internalName);
        if (container != null && container.func_85151_d().func_145748_c_().func_150260_c().equals("Craft Item") && (recipe = recipesFor.stream().filter(it -> it instanceof CraftingRecipe).findAny()).isPresent()) {
            this.craftingOverlay.setShownRecipe((CraftingRecipe)recipe.get());
            return;
        }
        if (!item.has("clickcommand")) {
            return;
        }
        String clickcommand = item.get("clickcommand").getAsString();
        switch (clickcommand.intern()) {
            case "viewrecipe": {
                this.displayGuiItemRecipe(internalName);
                break;
            }
            case "viewpotion": {
                String potionName = internalName.split(";")[0];
                potionName = potionName.replace("POTION_", "");
                this.neu.sendChatMessage("/viewpotion " + potionName.toLowerCase(Locale.ROOT));
                break;
            }
            default: {
                this.displayGuiItemRecipe(internalName);
            }
        }
    }

    public void showRecipe(String internalName) {
        this.showRecipe(this.getItemInformation().get(internalName));
    }

    public JsonObject getJsonForItem(ItemStack stack) {
        NBTTagCompound display;
        NBTTagCompound tag = stack.func_77978_p() == null ? new NBTTagCompound() : stack.func_77978_p();
        String[] lore = new String[]{};
        if (tag.func_150297_b("display", 10) && (display = tag.func_74775_l("display")).func_150297_b("Lore", 9)) {
            NBTTagList list = display.func_150295_c("Lore", 8);
            lore = new String[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                lore[i] = list.func_150307_f(i);
            }
        }
        if (stack.func_82833_r().endsWith(" Recipes")) {
            stack.func_151001_c(stack.func_82833_r().substring(0, stack.func_82833_r().length() - 8));
        }
        if (lore.length > 0 && (lore[lore.length - 1].contains("Click to view recipes!") || lore[lore.length - 1].contains("Click to view recipe!"))) {
            String[] lore2 = new String[lore.length - 2];
            System.arraycopy(lore, 0, lore2, 0, lore.length - 2);
            lore = lore2;
        }
        JsonObject json = new JsonObject();
        json.addProperty("itemid", stack.func_77973_b().getRegistryName());
        json.addProperty("displayname", stack.func_82833_r());
        json.addProperty("nbttag", tag.toString());
        json.addProperty("damage", stack.func_77952_i());
        JsonArray jsonlore = new JsonArray();
        for (String line : lore) {
            jsonlore.add(new JsonPrimitive(line));
        }
        json.add("lore", jsonlore);
        return json;
    }

    public String getSkullValueForItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        NBTTagCompound tag = stack.func_77978_p();
        return this.getSkullValueFromNBT(tag);
    }

    public ItemResolutionQuery createItemResolutionQuery() {
        return new ItemResolutionQuery(this);
    }

    @Deprecated
    public String getInternalNameForItem(ItemStack stack) {
        return this.createItemResolutionQuery().withItemStack(stack).resolveInternalName();
    }

    public static String getUUIDForItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        NBTTagCompound tag = stack.func_77978_p();
        return NEUManager.getUUIDFromNBT(tag);
    }

    public File getItemFileForInternalName(String internalName) {
        return new File(new File(this.repoLocation, "items"), internalName + ".json");
    }

    public void writeItemToFile(ItemStack stack) {
        String internalname = this.getInternalNameForItem(stack);
        if (internalname == null) {
            return;
        }
        JsonObject json = this.getJsonForItem(stack);
        json.addProperty("internalname", internalname);
        json.addProperty("clickcommand", "");
        json.addProperty("modver", "2.6.0");
        try {
            this.writeJson(json, this.getItemFileForInternalName(internalname));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.loadItem(internalname);
    }

    public boolean displayGuiItemUsagesKeybind(String internalName) {
        if (System.currentTimeMillis() - this.lastKeybind < 500L) {
            return false;
        }
        this.lastKeybind = System.currentTimeMillis();
        return this.displayGuiItemUsages(internalName);
    }

    public boolean displayGuiItemUsages(String internalName) {
        if (!this.usagesMap.containsKey(internalName)) {
            return false;
        }
        List<NeuRecipe> usages = this.getAvailableUsagesFor(internalName);
        if (usages.isEmpty()) {
            return false;
        }
        NotEnoughUpdates.INSTANCE.openGui = new GuiItemRecipe(usages, this);
        RecipeHistory.add(NotEnoughUpdates.INSTANCE.openGui);
        return true;
    }

    public boolean displayGuiItemRecipeKeybind(String internalName) {
        if (System.currentTimeMillis() - this.lastKeybind < 500L) {
            return false;
        }
        this.lastKeybind = System.currentTimeMillis();
        return this.displayGuiItemRecipe(internalName);
    }

    public boolean displayGuiItemRecipe(String internalName) {
        if (!this.recipesMap.containsKey(internalName)) {
            return false;
        }
        List<NeuRecipe> recipes = this.getAvailableRecipesFor(internalName);
        if (recipes.isEmpty()) {
            return false;
        }
        NotEnoughUpdates.INSTANCE.openGui = new GuiItemRecipe(recipes, this);
        RecipeHistory.add(NotEnoughUpdates.INSTANCE.openGui);
        return true;
    }

    public boolean failViewItem(String text) {
        if (this.viewItemAttemptID != null && !this.viewItemAttemptID.isEmpty() && System.currentTimeMillis() - this.viewItemAttemptTime < 500L) {
            return this.displayGuiItemRecipe(this.viewItemAttemptID);
        }
        return false;
    }

    public CompletableFuture<File> getWebFile(String url) {
        return CompletableFuture.supplyAsync(() -> {
            File f = new File(this.configLocation, "tmp/" + Base64.getEncoder().encodeToString(url.getBytes()) + ".html");
            if (f.exists()) {
                return f;
            }
            try {
                f.getParentFile().mkdirs();
                f.createNewFile();
                f.deleteOnExit();
            }
            catch (IOException e2) {
                return null;
            }
            try {
                int bytesRead;
                HttpsURLConnection con = (HttpsURLConnection)new URL(url + "?action=raw&templates=expand").openConnection();
                con.setRequestMethod("GET");
                con.setRequestProperty("User-Agent", "NotEnoughUpdates");
                BufferedInputStream inStream = new BufferedInputStream(con.getInputStream());
                FileOutputStream fileOutputStream = new FileOutputStream(f);
                byte[] dataBuffer = new byte[1024];
                while ((bytesRead = inStream.read(dataBuffer, 0, 1024)) != -1) {
                    fileOutputStream.write(dataBuffer, 0, bytesRead);
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
                return null;
            }
            return f;
        });
    }

    private static void unzipIgnoreFirstFolder(String zipFilePath, String destDir) {
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        try {
            FileInputStream fis = new FileInputStream(zipFilePath);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (!ze.isDirectory()) {
                    int len2;
                    String fileName = ze.getName();
                    fileName = fileName.substring(fileName.split("/")[0].length() + 1);
                    File newFile = new File(destDir + File.separator + fileName);
                    new File(newFile.getParent()).mkdirs();
                    if (!NEUManager.isInTree(dir, newFile)) {
                        throw new RuntimeException("Not Enough Updates detected an invalid zip file. This is a potential security risk, please report this in the Moulberry discord.");
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len2 = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len2);
                    }
                    fos.close();
                }
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            fis.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static boolean isInTree(File rootDirectory, File file) throws IOException {
        rootDirectory = rootDirectory.getCanonicalFile();
        for (file = file.getCanonicalFile(); file != null; file = file.getParentFile()) {
            if (!file.equals(rootDirectory)) continue;
            return true;
        }
        return false;
    }

    public static void unzip(InputStream src, File dest) {
        byte[] buffer = new byte[1024];
        try {
            ZipInputStream zis = new ZipInputStream(src);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (!ze.isDirectory()) {
                    int len2;
                    String fileName = ze.getName();
                    File newFile = new File(dest, fileName);
                    if (!NEUManager.isInTree(dest, newFile)) {
                        throw new RuntimeException("Not Enough Updates detected an invalid zip file. This is a potential security risk, please report this in the Moulberry discord.");
                    }
                    new File(newFile.getParent()).mkdirs();
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len2 = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len2);
                    }
                    fos.close();
                }
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public JsonObject createItemJson(String internalname, String itemid, String displayName, String[] lore, String crafttext, String infoType, String[] info, String clickcommand, int damage, NBTTagCompound nbttag) {
        return this.createItemJson(new JsonObject(), internalname, itemid, displayName, lore, crafttext, infoType, info, clickcommand, damage, nbttag);
    }

    public JsonObject createItemJson(JsonObject base, String internalname, String itemid, String displayName, String[] lore, String crafttext, String infoType, String[] info, String clickcommand, int damage, NBTTagCompound nbttag) {
        if (internalname == null || internalname.isEmpty()) {
            return null;
        }
        JsonObject json = this.gson.fromJson(this.gson.toJson((Object)base, (Type)((Object)JsonObject.class)), JsonObject.class);
        json.addProperty("internalname", internalname);
        json.addProperty("itemid", itemid);
        json.addProperty("displayname", displayName);
        json.addProperty("crafttext", crafttext);
        json.addProperty("clickcommand", clickcommand);
        json.addProperty("damage", damage);
        nbttag.func_74768_a("HideFlags", 254);
        NBTTagCompound display = nbttag.func_74775_l("display");
        nbttag.func_74782_a("display", (NBTBase)display);
        display.func_74778_a("Name", displayName);
        NBTTagList loreList = new NBTTagList();
        for (String loreLine : lore) {
            loreList.func_74742_a((NBTBase)new NBTTagString(loreLine));
        }
        display.func_74782_a("Lore", (NBTBase)loreList);
        NBTTagCompound extraAttributes = nbttag.func_74775_l("ExtraAttributes");
        nbttag.func_74782_a("ExtraAttributes", (NBTBase)extraAttributes);
        extraAttributes.func_74778_a("id", internalname);
        json.addProperty("nbttag", nbttag.toString());
        json.addProperty("modver", "2.6.0");
        json.addProperty("infoType", infoType);
        if (info != null && info.length > 0) {
            JsonArray jsoninfo = new JsonArray();
            String[] stringArray = info;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String line = stringArray[i];
                jsoninfo.add(new JsonPrimitive(line));
            }
            json.add("info", jsoninfo);
        }
        JsonArray jsonlore = new JsonArray();
        for (String line : lore) {
            jsonlore.add(new JsonPrimitive(line));
        }
        json.add("lore", jsonlore);
        return json;
    }

    public boolean writeItemJson(JsonObject base, String internalname, String itemid, String displayName, String[] lore, String crafttext, String infoType, String[] info, String clickcommand, int damage, NBTTagCompound nbttag) {
        JsonObject json = this.createItemJson(base, internalname, itemid, displayName, lore, crafttext, infoType, info, clickcommand, damage, nbttag);
        if (json == null) {
            return false;
        }
        try {
            this.writeJsonDefaultDir(json, internalname + ".json");
        }
        catch (IOException e2) {
            return false;
        }
        this.loadItem(internalname);
        return true;
    }

    public void writeJson(JsonObject json, File file) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            writer.write(this.gson.toJson(json));
        }
    }

    public void writeJsonDefaultDir(JsonObject json, String filename) throws IOException {
        File file = new File(new File(this.repoLocation, "items"), filename);
        this.writeJson(json, file);
    }

    public JsonObject readJsonDefaultDir(String filename) throws IOException {
        File f = new File(new File(this.repoLocation, "items"), filename);
        if (f.exists() && f.isFile() && f.canRead()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);){
                JsonObject jsonObject = this.gson.fromJson((Reader)reader, JsonObject.class);
                return jsonObject;
            }
        }
        return null;
    }

    public TreeMap<String, JsonObject> getItemInformation() {
        return this.itemMap;
    }

    public String removeUnusedDecimal(double num) {
        if (num % 1.0 == 0.0) {
            return String.valueOf((int)num);
        }
        return String.valueOf(num);
    }

    public HashMap<String, String> getPetLoreReplacements(String petname, String tier, int level) {
        HashMap<String, String> replacements;
        block19: {
            JsonObject petInfo;
            JsonObject petnums = null;
            if (petname != null && tier != null) {
                petnums = Constants.PETNUMS;
            }
            replacements = new HashMap<String, String>();
            if (level < 1) {
                if (Constants.PETS != null && Constants.PETS.has("custom_pet_leveling") && Constants.PETS.getAsJsonObject("custom_pet_leveling").has(petname) && Constants.PETS.getAsJsonObject("custom_pet_leveling").getAsJsonObject(petname).has("max_level")) {
                    int maxLvl = Constants.PETS.getAsJsonObject("custom_pet_leveling").getAsJsonObject(petname).get("max_level").getAsInt();
                    replacements.put("LVL", "1\u27a1" + maxLvl);
                } else {
                    replacements.put("LVL", "1\u27a1100");
                }
            } else {
                replacements.put("LVL", "" + level);
            }
            if (petnums == null || !petnums.has(petname) || !(petInfo = petnums.get(petname).getAsJsonObject()).has(tier)) break block19;
            JsonObject petInfoTier = petInfo.get(tier).getAsJsonObject();
            if (petInfoTier == null || !petInfoTier.has("1") || !petInfoTier.has("100")) {
                return replacements;
            }
            JsonObject min2 = petInfoTier.get("1").getAsJsonObject();
            JsonObject max2 = petInfoTier.get("100").getAsJsonObject();
            if (level < 1) {
                int type2;
                String[] stringArray;
                JsonArray otherNumsMin = min2.get("otherNums").getAsJsonArray();
                JsonArray otherNumsMax = max2.get("otherNums").getAsJsonArray();
                boolean addZero = false;
                if (petInfoTier.has("stats_levelling_curve") && (stringArray = petInfoTier.get("stats_levelling_curve").getAsString().split(":")).length == 3 && (type2 = Integer.parseInt(stringArray[2])) == 1) {
                    addZero = true;
                }
                for (int i = 0; i < otherNumsMax.size(); ++i) {
                    replacements.put("" + i, (addZero ? "0\u27a1" : "") + StringUtils.formatNumber(otherNumsMin.get(i).getAsDouble()) + "\u27a1" + StringUtils.formatNumber(otherNumsMax.get(i).getAsDouble()));
                }
                for (Map.Entry<String, JsonElement> entry : max2.get("statNums").getAsJsonObject().entrySet()) {
                    double statMax = entry.getValue().getAsDouble();
                    double statMin = min2.get("statNums").getAsJsonObject().get(entry.getKey()).getAsDouble();
                    String statStr = (statMin > 0.0 ? "+" : "") + StringUtils.formatNumber(statMin) + "\u27a1" + StringUtils.formatNumber(statMax);
                    statStr = (addZero ? "0\u27a1" : "") + statStr;
                    replacements.put(entry.getKey(), statStr);
                }
            } else {
                String[] stringArray;
                int minStatsLevel = 0;
                int maxStatsLevel = 100;
                int statsLevelingType = -1;
                int statsLevel = level;
                if (petInfoTier.has("stats_levelling_curve") && (stringArray = petInfoTier.get("stats_levelling_curve").getAsString().split(":")).length == 3) {
                    minStatsLevel = Integer.parseInt(stringArray[0]);
                    maxStatsLevel = Integer.parseInt(stringArray[1]);
                    statsLevelingType = Integer.parseInt(stringArray[2]);
                    switch (statsLevelingType) {
                        case 0: 
                        case 1: {
                            statsLevel = level < minStatsLevel ? 1 : (level < maxStatsLevel ? level - minStatsLevel + 1 : maxStatsLevel - minStatsLevel + 1);
                        }
                    }
                }
                float minMix = (float)(maxStatsLevel - (minStatsLevel - (statsLevelingType == -1 ? 0 : 1)) - statsLevel) / 99.0f;
                float maxMix = (float)(statsLevel - 1) / 99.0f;
                JsonArray otherNumsMin = min2.get("otherNums").getAsJsonArray();
                JsonArray otherNumsMax = max2.get("otherNums").getAsJsonArray();
                for (int i = 0; i < otherNumsMax.size(); ++i) {
                    float val = otherNumsMin.get(i).getAsFloat() * minMix + otherNumsMax.get(i).getAsFloat() * maxMix;
                    if (statsLevelingType == 1 && level < minStatsLevel) {
                        replacements.put("" + i, "0");
                        continue;
                    }
                    replacements.put("" + i, this.removeUnusedDecimal(Math.floor(val * 10.0f) / 10.0));
                }
                for (Map.Entry<String, JsonElement> entry : max2.get("statNums").getAsJsonObject().entrySet()) {
                    if (statsLevelingType == 1 && level < minStatsLevel) {
                        replacements.put(entry.getKey(), "0");
                        continue;
                    }
                    float statMax = entry.getValue().getAsFloat();
                    float statMin = min2.get("statNums").getAsJsonObject().get(entry.getKey()).getAsFloat();
                    float val = statMin * minMix + statMax * maxMix;
                    String statStr = (statMin > 0.0f ? "+" : "") + this.removeUnusedDecimal(Math.floor(val * 10.0f) / 10.0);
                    replacements.put(entry.getKey(), statStr);
                }
            }
        }
        return replacements;
    }

    public HashMap<String, String> getPetLoreReplacements(NBTTagCompound tag, int level) {
        NBTTagCompound ea;
        String petname = null;
        String tier = null;
        if (tag != null && tag.func_74764_b("ExtraAttributes") && (ea = tag.func_74775_l("ExtraAttributes")).func_74764_b("petInfo")) {
            String heldItem;
            String petInfoStr = ea.func_74779_i("petInfo");
            JsonObject petInfo = this.gson.fromJson(petInfoStr, JsonObject.class);
            petname = petInfo.get("type").getAsString();
            tier = petInfo.get("tier").getAsString();
            if (petInfo.has("heldItem") && (heldItem = petInfo.get("heldItem").getAsString()).equals("PET_ITEM_TIER_BOOST")) {
                switch (tier) {
                    case "COMMON": {
                        tier = "UNCOMMON";
                        break;
                    }
                    case "UNCOMMON": {
                        tier = "RARE";
                        break;
                    }
                    case "RARE": {
                        tier = "EPIC";
                        break;
                    }
                    case "EPIC": {
                        tier = "LEGENDARY";
                        break;
                    }
                    case "LEGENDARY": {
                        tier = "MYTHIC";
                    }
                }
            }
        }
        return this.getPetLoreReplacements(petname, tier, level);
    }

    public NBTTagList processLore(JsonArray lore, HashMap<String, String> replacements) {
        NBTTagList nbtLore = new NBTTagList();
        for (JsonElement line : lore) {
            String lineStr = line.getAsString();
            if (lineStr.contains("Click to view recipes!") || lineStr.contains("Click to view recipe!")) continue;
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                lineStr = lineStr.replace("{" + entry.getKey() + "}", entry.getValue());
            }
            nbtLore.func_74742_a((NBTBase)new NBTTagString(lineStr));
        }
        return nbtLore;
    }

    public ItemStack jsonToStack(JsonObject json) {
        return this.jsonToStack(json, true);
    }

    public ItemStack jsonToStack(JsonObject json, boolean useCache) {
        return this.jsonToStack(json, useCache, false);
    }

    public ItemStack jsonToStack(JsonObject json, boolean useCache, boolean useReplacements) {
        return this.jsonToStack(json, useCache, useReplacements, true);
    }

    public ItemStack jsonToStack(JsonObject json, boolean useCache, boolean useReplacements, boolean copyStack) {
        ItemStack stack;
        if (useReplacements) {
            useCache = false;
        }
        if (json == null) {
            return new ItemStack(Items.field_151159_an, 1, 10);
        }
        String internalname = json.get("internalname").getAsString();
        if ("_".equals(internalname)) {
            useCache = false;
        }
        if (useCache && (stack = this.itemstackCache.get(internalname)) != null) {
            if (copyStack) {
                return stack.func_77946_l();
            }
            return stack;
        }
        stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(json.get("itemid").getAsString())));
        if (json.has("count")) {
            stack.field_77994_a = json.get("count").getAsInt();
        }
        if (stack.func_77973_b() == null) {
            stack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150348_b), 0, 255);
        } else {
            if (json.has("damage")) {
                stack.func_77964_b(json.get("damage").getAsInt());
            }
            if (json.has("nbttag")) {
                try {
                    NBTTagCompound tag = JsonToNBT.func_180713_a((String)json.get("nbttag").getAsString());
                    stack.func_77982_d(tag);
                }
                catch (NBTException tag) {
                    // empty catch block
                }
            }
            HashMap<Object, Object> replacements = new HashMap();
            if (useReplacements) {
                replacements = this.getPetLoreReplacements(stack.func_77978_p(), -1);
                String displayName = json.get("displayname").getAsString();
                for (Map.Entry<Object, Object> entry : replacements.entrySet()) {
                    displayName = displayName.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                }
                stack.func_151001_c(displayName);
            }
            if (json.has("lore")) {
                NBTTagCompound display = new NBTTagCompound();
                if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("display")) {
                    display = stack.func_77978_p().func_74775_l("display");
                }
                display.func_74782_a("Lore", (NBTBase)this.processLore(json.get("lore").getAsJsonArray(), replacements));
                NBTTagCompound tag = stack.func_77978_p() != null ? stack.func_77978_p() : new NBTTagCompound();
                tag.func_74782_a("display", (NBTBase)display);
                stack.func_77982_d(tag);
            }
        }
        if (useCache) {
            this.itemstackCache.put(internalname, stack);
        }
        if (copyStack) {
            return stack.func_77946_l();
        }
        return stack;
    }

    public CompletableFuture<List<String>> userFacingRepositoryReload() {
        String lastCommit = NotEnoughUpdates.INSTANCE.manager.latestRepoCommit;
        NotEnoughUpdates.INSTANCE.manager.resetRepo();
        return ((CompletableFuture)((CompletableFuture)NotEnoughUpdates.INSTANCE.manager.fetchRepository().thenCompose(ignored -> NotEnoughUpdates.INSTANCE.manager.reloadRepository())).thenApply(ignored -> {
            String newCommitHash = NotEnoughUpdates.INSTANCE.manager.latestRepoCommit;
            String newCommitShortHash = newCommitHash == null ? "MISSING" : newCommitHash.substring(0, 7);
            return Arrays.asList("\u00a7aRepository reloaded.", lastCommit == null ? "\u00a7eYou downloaded the repository version \u00a7b" + newCommitShortHash + "\u00a7e." : "\u00a7eYou updated your repository from \u00a7b" + lastCommit.substring(0, 7) + "\u00a7e to \u00a7b" + newCommitShortHash + "\u00a7e.");
        })).exceptionally(ex -> {
            ex.printStackTrace();
            System.out.println("switching over to the backup repo");
            this.switchToBackupRepo();
            return Arrays.asList("\u00a7cRepository not fully reloaded.", "\u00a7cThere was an error reloading your repository.", "\u00a7cThis might be caused by an outdated version of neu", "\u00a7c(or by not using the prerelease repository if you are using a prerelease of neu).", "\u00a7aYour repository will still work, but is in a suboptimal state.", "\u00a7eJoin \u00a7b" + Utils.getDiscordInvite() + " \u00a7efor help.");
        });
    }

    public CompletableFuture<Void> reloadRepository() {
        CompletableFuture<Void> comp = new CompletableFuture<Void>();
        Minecraft.func_71410_x().func_152344_a(() -> {
            try {
                File items2 = new File(this.repoLocation, "items");
                if (items2.exists()) {
                    this.recipes.clear();
                    this.recipesMap.clear();
                    this.usagesMap.clear();
                    this.itemMap.clear();
                    File[] itemFiles = new File(this.repoLocation, "items").listFiles();
                    if (itemFiles != null) {
                        for (File f : itemFiles) {
                            String internalname = f.getName().substring(0, f.getName().length() - 5);
                            this.loadItem(internalname);
                        }
                    }
                }
                new RepositoryReloadEvent(this.repoLocation, !this.hasBeenLoadedBefore).post();
                this.hasBeenLoadedBefore = true;
                comp.complete(null);
                this.displayNameCache.clear();
            }
            catch (Exception e2) {
                comp.completeExceptionally(e2);
            }
        });
        return comp;
    }

    public ItemStack createItem(String internalName) {
        return this.createItemResolutionQuery().withKnownInternalName(internalName).resolveToItemStack();
    }

    public boolean isValidInternalName(String internalName) {
        return this.itemMap.containsKey(internalName);
    }

    public String getDisplayName(String internalName) {
        JsonObject jsonObject;
        if (this.displayNameCache.containsKey(internalName)) {
            return this.displayNameCache.get(internalName);
        }
        String displayName = null;
        TreeMap<String, JsonObject> itemInformation = NotEnoughUpdates.INSTANCE.manager.getItemInformation();
        if (itemInformation.containsKey(internalName) && (jsonObject = itemInformation.get(internalName)).has("displayname")) {
            displayName = jsonObject.get("displayname").getAsString();
        }
        if (displayName == null) {
            displayName = internalName;
            Utils.showOutdatedRepoNotification(internalName);
            if (NotEnoughUpdates.INSTANCE.config.hidden.dev) {
                Utils.addChatMessage("\u00a7c[NEU] Found no display name in repo for '" + internalName + "'!");
            }
        }
        this.displayNameCache.put(internalName, displayName);
        return displayName;
    }

    public void removeItemFromCache(String internalName) {
        this.itemstackCache.remove(internalName);
        this.displayNameCache.remove(internalName);
    }

    private static class DebugMatch {
        int index;
        String match;

        DebugMatch(int index, String match2) {
            this.index = index;
            this.match = match2;
        }
    }
}

