/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.core.util;

import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ArrowPagesUtils {
    public static final int BUTTON_POSITION_RIGHT_OFFSET_X = 37;
    public static final int PAGE_STRING_OFFSET_X = 22;
    public static final int PAGE_STRING_OFFSET_Y = 6;
    public static final int BUTTON_WIDTH = 7;
    public static final int BUTTON_HEIGHT = 11;
    public static final ResourceLocation resourcePacksTexture = new ResourceLocation("textures/gui/resource_packs.png");

    public static void onDraw(int guiLeft, int guiTop, int[] topLeftButton, int currentPage, int totalPages) {
        if (totalPages < 2) {
            return;
        }
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int mouseX = Mouse.getX() * scaledWidth / Minecraft.func_71410_x().field_71443_c;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.func_71410_x().field_71440_d - 1;
        int buttonPositionLeftX = topLeftButton[0];
        int buttonPositionRightX = buttonPositionLeftX + 37;
        int pageStringX = buttonPositionLeftX + 22;
        int buttonPositionY = topLeftButton[1];
        int pageStringY = buttonPositionY + 6;
        boolean leftSelected = ArrowPagesUtils.isWithinRect(mouseX - guiLeft, mouseY - guiTop, buttonPositionLeftX, buttonPositionY, 7, 11);
        boolean rightSelected = ArrowPagesUtils.isWithinRect(mouseX - guiLeft, mouseY - guiTop, buttonPositionRightX, buttonPositionY, 7, 11);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourcePacksTexture);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (currentPage != 0) {
            Utils.drawTexturedRect(guiLeft + buttonPositionLeftX, guiTop + buttonPositionY, 7.0f, 11.0f, 0.1328125f, 0.1875f, leftSelected ? 0.14453125f : 0.01953125f, leftSelected ? 0.23046875f : 0.10546875f);
        }
        if (currentPage != totalPages - 1) {
            Utils.drawTexturedRect(guiLeft + buttonPositionRightX, guiTop + buttonPositionY, 7.0f, 11.0f, 0.0390625f, 0.09375f, rightSelected ? 0.14453125f : 0.01953125f, rightSelected ? 0.23046875f : 0.10546875f);
        }
        GL11.glBindTexture((int)3553, (int)0);
        String selectedPage = currentPage + 1 + "/" + totalPages;
        Utils.drawStringCenteredScaledMaxWidth(selectedPage, guiLeft + pageStringX, guiTop + pageStringY, false, 28, Color.BLACK.getRGB());
    }

    public static boolean onPageSwitchKey(int currentPage, int totalPages, Consumer<Integer> pageChange) {
        int keyPressed;
        int n = keyPressed = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
        if (Keyboard.getEventKeyState() && keyPressed == 203) {
            int newPage = currentPage - 1;
            pageChange.accept(MathHelper.func_76125_a((int)newPage, (int)0, (int)(totalPages - 1)));
            return true;
        }
        if (Keyboard.getEventKeyState() && keyPressed == 205) {
            int newPage = currentPage + 1;
            pageChange.accept(MathHelper.func_76125_a((int)newPage, (int)0, (int)(totalPages - 1)));
            return true;
        }
        return false;
    }

    public static boolean onPageSwitchMouse(int guiLeft, int guiTop, int[] topLeft, int currentPage, int totalPages, Consumer<Integer> pageChange) {
        int keyPressed;
        int n = keyPressed = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
        if (Keyboard.getEventKeyState() && keyPressed == 203) {
            int newPage = currentPage - 1;
            pageChange.accept(MathHelper.func_76125_a((int)newPage, (int)0, (int)(totalPages - 1)));
            return true;
        }
        if (Keyboard.getEventKeyState() && keyPressed == 205) {
            int newPage = currentPage + 1;
            pageChange.accept(MathHelper.func_76125_a((int)newPage, (int)0, (int)(totalPages - 1)));
            return true;
        }
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int mouseX = Mouse.getX() * scaledWidth / Minecraft.func_71410_x().field_71443_c;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.func_71410_x().field_71440_d - 1;
        int buttonPositionLeftX = topLeft[0];
        int buttonPositionRightX = buttonPositionLeftX + 37;
        int buttonPositionY = topLeft[1];
        if (ArrowPagesUtils.isWithinRect(mouseX - guiLeft, mouseY - guiTop, buttonPositionLeftX, buttonPositionY, 7, 11) && currentPage > 0) {
            int newPage = currentPage - 1;
            pageChange.accept(MathHelper.func_76125_a((int)newPage, (int)0, (int)(totalPages - 1)));
            Utils.playPressSound();
            return true;
        }
        if (ArrowPagesUtils.isWithinRect(mouseX - guiLeft, mouseY - guiTop, buttonPositionRightX, buttonPositionY, 7, 11) && currentPage < totalPages - 1) {
            int newPage = currentPage + 1;
            pageChange.accept(MathHelper.func_76125_a((int)newPage, (int)0, (int)(totalPages - 1)));
            Utils.playPressSound();
            return true;
        }
        return false;
    }

    public static boolean onPageSwitchScroll(int currentPage, int totalPages, Consumer<Integer> pageChange) {
        if (Mouse.getEventDWheel() > 0) {
            int newPage = currentPage - 1;
            pageChange.accept(MathHelper.func_76125_a((int)newPage, (int)0, (int)(totalPages - 1)));
            return true;
        }
        if (Mouse.getEventDWheel() < 0) {
            int newPage = currentPage + 1;
            pageChange.accept(MathHelper.func_76125_a((int)newPage, (int)0, (int)(totalPages - 1)));
            return true;
        }
        return false;
    }

    private static boolean isWithinRect(int x, int y, int topLeftX, int topLeftY, int width, int height) {
        return topLeftX <= x && x < topLeftX + width && topLeftY <= y && y < topLeftY + height;
    }
}

