/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig;

import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;

public abstract class Social {
    public static Social forLink(String name, ResourceLocation icon, String link) {
        try {
            return new URLSocial(name, new URI(link), icon);
        }
        catch (URISyntaxException e2) {
            throw new RuntimeException(e2);
        }
    }

    public abstract void onClick();

    public abstract List<String> getTooltip();

    public abstract ResourceLocation getIcon();

    private static class URLSocial
    extends Social {
        private final String name;
        private final URI url;
        private final ResourceLocation icon;

        private URLSocial(String name, URI url, ResourceLocation icon) {
            this.name = name;
            this.url = url;
            this.icon = icon;
        }

        @Override
        public void onClick() {
            try {
                Desktop.getDesktop().browse(this.url);
            }
            catch (Exception e2) {
                ChatComponentText text = new ChatComponentText("Click here to open " + this.name);
                text.func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, this.url.toString())));
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)text);
            }
        }

        @Override
        public List<String> getTooltip() {
            return Arrays.asList(this.name);
        }

        @Override
        public ResourceLocation getIcon() {
            return this.icon;
        }
    }
}

