/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.IFontRenderer;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.IItemStack;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.KeyboardConstants;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RenderContext {
    public void pushMatrix();

    public void popMatrix();

    public void translate(float var1, float var2, float var3);

    public void scale(float var1, float var2, float var3);

    public void color(float var1, float var2, float var3, float var4);

    public boolean isMouseButtonDown(int var1);

    public boolean isKeyboardKeyDown(int var1);

    default public boolean isShiftDown() {
        return this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getShiftLeft()) || this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getShiftRight());
    }

    default public boolean isCtrlDown() {
        return this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getCtrlLeft()) || this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getCtrlRight());
    }

    default public void drawStringScaledMaxWidth(@NotNull String text, @NotNull IFontRenderer fontRenderer, int x, int y, boolean shadow, int width, int color) {
        this.pushMatrix();
        this.translate(x, y, 0.0f);
        float scale = Math.min(1.0f, Math.max(0.1f, (float)width / (float)fontRenderer.getStringWidth(text)));
        this.scale(scale, scale, 1.0f);
        this.drawString(fontRenderer, text, 0, 0, color, shadow);
        this.popMatrix();
    }

    public int drawString(IFontRenderer var1, String var2, int var3, int var4, int var5, boolean var6);

    public void drawColoredRect(float var1, float var2, float var3, float var4, int var5);

    public void invertedRect(float var1, float var2, float var3, float var4);

    public void drawTexturedRect(float var1, float var2, float var3, float var4);

    public void renderDarkRect(int var1, int var2, int var3, int var4);

    public void pushScissor(int var1, int var2, int var3, int var4);

    public void popScissor();

    public void renderItemStack(@NotNull IItemStack var1, int var2, int var3, @Nullable String var4);

    public void scheduleDrawTooltip(@NotNull List<String> var1);

    public void doDrawTooltip();
}

