/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.editors;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.Config;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.GuiTextures;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.IMinecraft;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiOptionEditor;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.RenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.TextRenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.processor.ProcessedOption;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public class GuiOptionEditorButton
extends GuiOptionEditor {
    private final int runnableId;
    private String buttonText;
    private final Config config;
    private boolean isUsingRunnable;

    public GuiOptionEditorButton(ProcessedOption option, int runnableId, String buttonText, Config config) {
        super(option);
        this.runnableId = runnableId;
        this.config = config;
        this.buttonText = buttonText;
        boolean bl = this.isUsingRunnable = option.getType() == Runnable.class;
        if (this.buttonText == null) {
            this.buttonText = "";
        }
    }

    @Override
    public void render(int x, int y, int width) {
        super.render(x, y, width);
        int height = this.getHeight();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IMinecraft.instance.bindTexture(GuiTextures.BUTTON);
        RenderUtils.drawTexturedRect(x + width / 6 - 24, y + height - 7 - 14, 48.0f, 16.0f);
        TextRenderUtils.drawStringCenteredScaledMaxWidth(this.buttonText, Minecraft.func_71410_x().field_71466_p, x + width / 6, y + height - 7 - 6, false, 44, -13619152);
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        if (Mouse.getEventButtonState()) {
            int height = this.getHeight();
            if (mouseX > x + width / 6 - 24 && mouseX < x + width / 6 + 24 && mouseY > y + height - 7 - 14 && mouseY < y + height - 7 + 2) {
                if (this.isUsingRunnable) {
                    ((Runnable)this.option.get()).run();
                } else {
                    this.config.executeRunnable(this.runnableId);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean fulfillsSearch(String word) {
        return super.fulfillsSearch(word) || this.buttonText.toLowerCase(Locale.ROOT).contains(word);
    }

    @Override
    public boolean keyboardInput() {
        return false;
    }
}

