/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.infopanes;

import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NEUOverlay;
import io.github.moulberry.notenoughupdates.infopanes.InfoPane;
import io.github.moulberry.notenoughupdates.itemeditor.GuiElementTextField;
import io.github.moulberry.notenoughupdates.util.GuiTextures;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;

public class FlipperInfoPane
extends InfoPane {
    protected String title;
    protected String text;
    GuiElementTextField minPrice = new GuiElementTextField("0", 24);
    GuiElementTextField maxPrice = new GuiElementTextField("100000000", 24);
    GuiElementTextField priceDiff = new GuiElementTextField("1000000", 24);

    public FlipperInfoPane(NEUOverlay overlay, NEUManager manager, String title, String text) {
        super(overlay, manager);
        this.title = title;
        this.text = text;
        this.minPrice.setSize(60, 16);
        this.maxPrice.setSize(60, 16);
        this.priceDiff.setSize(60, 16);
    }

    @Override
    public void render(int width, int height, Color bg, Color fg, ScaledResolution scaledresolution, int mouseX, int mouseY) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int paneWidth = (int)((float)(width / 3) * this.overlay.getWidthMult());
        int rightSide = (int)((float)width * this.overlay.getInfoPaneOffsetFactor());
        int leftSide = rightSide - paneWidth;
        int titleLen = fr.func_78256_a(this.title);
        fr.func_78276_b(this.title, (leftSide + rightSide - titleLen) / 2, this.overlay.getBoxPadding() + 5, Color.WHITE.getRGB());
        int y = 0;
        y += this.renderParagraph(width, height, y, "Bazaar Flips", bg);
        y += 20;
        y += this.renderParagraph(width, height, y, "-- Strong Dragon Fragments", bg);
        y += this.renderParagraph(width, height, y, "-- Strong Dragon Fragments", bg);
        y += this.renderParagraph(width, height, y, "-- Strong Dragon Fragments", bg);
        y += this.renderParagraph(width, height, y, "-- Strong Dragon Fragments", bg);
        y += this.renderParagraph(width, height, y, "AH Flips", bg);
        int x = 10;
        fr.func_78276_b("Min Price: ", x, y += 10, Color.WHITE.getRGB());
        this.minPrice.render(x, y + 10);
        fr.func_78276_b("Max Price: ", x += 70, y, Color.WHITE.getRGB());
        this.maxPrice.render(x, y + 10);
        fr.func_78276_b("Price Diff: ", x += 70, y, Color.WHITE.getRGB());
        this.priceDiff.render(x, y + 10);
        fr.func_78276_b("Incl. Stackables: ", x += 70, y, Color.WHITE.getRGB());
        this.drawButton(x, y, false);
        FlipperInfoPane.func_73734_a((int)(leftSide + this.overlay.getBoxPadding() - 5), (int)(this.overlay.getBoxPadding() - 5), (int)(rightSide - this.overlay.getBoxPadding() + 5), (int)(height - this.overlay.getBoxPadding() + 5), (int)bg.getRGB());
    }

    private void drawButton(int x, int y, boolean enabled) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(enabled ? GuiTextures.on : GuiTextures.off);
        Utils.drawTexturedRect(x, y, 48.0f, 16.0f);
    }

    @Override
    public void mouseInput(int width, int height, int mouseX, int mouseY, boolean mouseDown) {
    }

    @Override
    public boolean keyboardInput() {
        return false;
    }

    private int renderParagraph(int width, int height, int startY, String text, Color bg) {
        int paneWidth = (int)((float)(width / 3) * this.overlay.getWidthMult());
        int rightSide = (int)((float)width * this.overlay.getInfoPaneOffsetFactor());
        int leftSide = rightSide - paneWidth;
        int yOff = 0;
        for (String line : text.split("\n")) {
            yOff += Utils.renderStringTrimWidth(line, false, leftSide + this.overlay.getBoxPadding() + 5, startY + this.overlay.getBoxPadding() + 10 + yOff, width * 1 / 3 - this.overlay.getBoxPadding() * 2 - 10, Color.WHITE.getRGB(), -1);
            yOff += 16;
        }
        return yOff;
    }
}

