/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.mbgui;

import java.io.Serializable;
import java.util.Locale;
import org.lwjgl.util.vector.Vector2f;

public class MBAnchorPoint
implements Serializable {
    public AnchorPoint anchorPoint;
    public Vector2f offset;
    public boolean inventoryRelative;

    public MBAnchorPoint(AnchorPoint anchorPoint, Vector2f offset) {
        this(anchorPoint, offset, false);
    }

    public MBAnchorPoint(AnchorPoint anchorPoint, Vector2f offset, boolean inventoryRelative) {
        this.anchorPoint = anchorPoint;
        this.offset = offset;
        this.inventoryRelative = inventoryRelative;
    }

    public static MBAnchorPoint createFromString(String str) {
        if (str == null || str.split(":").length != 4) {
            return null;
        }
        try {
            String[] split = str.split(":");
            AnchorPoint point = AnchorPoint.valueOf(split[0].toUpperCase(Locale.ROOT));
            Vector2f pos = new Vector2f(Float.parseFloat(split[1]), Float.parseFloat(split[2]));
            return new MBAnchorPoint(point, pos, Boolean.parseBoolean(split[3]));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String toString() {
        return this.anchorPoint.toString() + ":" + this.offset.x + ":" + this.offset.y + ":" + this.inventoryRelative;
    }

    public static enum AnchorPoint {
        TOPLEFT(0.0f, 0.0f),
        TOPMID(0.5f, 0.0f),
        TOPRIGHT(1.0f, 0.0f),
        MIDRIGHT(1.0f, 0.5f),
        BOTRIGHT(1.0f, 1.0f),
        BOTMID(0.5f, 1.0f),
        BOTLEFT(0.0f, 1.0f),
        MIDLEFT(0.0f, 0.5f),
        MIDMID(0.5f, 0.5f);

        public final float x;
        public final float y;

        private AnchorPoint(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

