/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.KeybindHelper;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.events.GuiContainerBackgroundDrawnEvent;
import io.github.moulberry.notenoughupdates.events.ReplaceItemEvent;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AbiphoneFavourites {
    private static final AbiphoneFavourites INSTANCE = new AbiphoneFavourites();
    private long lastClick = 0L;
    private boolean isInShowMenu = false;
    private final ItemStack ITEM_STACK_FAVOURITE_ONLY = Utils.createItemStack(Items.field_151045_i, "\u00a76Show only favourite contacts", "\u00a77Non favourite contacts are hidden.", "\u00a77Only favourite contacts can be called.", "\u00a78This is a NEU feature and not made by hypixel.", " ", "\u00a7eClick to show all contacts!");
    private final ItemStack ITEM_STACK_ALL = Utils.createItemStack(Items.field_151166_bC, "\u00a7aShow all contacts", "\u00a77Favourite contacts are marked \u00a76orange\u00a77.", "\u00a77All contacts can be called.", "\u00a78This is a NEU feature and not made by hypixel.", " ", "\u00a7eClick to show only favourite contacts!");

    public static AbiphoneFavourites getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (this.isWrongInventory()) {
            return;
        }
        List list = event.toolTip;
        if (list == null) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        ItemStack stack = event.itemStack;
        if (!this.isContact(stack)) {
            return;
        }
        String rawName = stack.func_82833_r();
        String name = StringUtils.cleanColour(rawName);
        if (this.isAbiphoneShowOnlyFavourites() && !this.getFavouriteContacts().contains(name)) {
            list.clear();
            return;
        }
        if (this.isAbiphoneShowOnlyFavourites()) {
            list.removeIf(s -> s.contains("\u00a78Right-click to remove!"));
            return;
        }
        int index = list.size() - 1;
        if (this.getFavouriteContacts().contains(name)) {
            list.set(0, rawName + " \u00a7f- \u00a76Favourite");
            list.add(index, "\u00a7eShift-click to remove from the favourites!");
        } else {
            list.add(index, "\u00a7eShift-click to add to the favourites!");
        }
        if (KeybindHelper.isKeyPressed(NotEnoughUpdates.INSTANCE.manager.keybindFavourite.func_151463_i()) && System.currentTimeMillis() > this.lastClick + 500L) {
            this.toggleFavouriteContact(rawName, name);
            this.lastClick = System.currentTimeMillis();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onStackClick(SlotClickEvent event) {
        if (this.isWrongInventory()) {
            return;
        }
        ItemStack stack = event.slot.func_75211_c();
        if (stack == null || stack.func_82833_r() == null) {
            return;
        }
        if (stack == this.ITEM_STACK_FAVOURITE_ONLY || stack == this.ITEM_STACK_ALL) {
            NEUConfig.HiddenProfileSpecific profileSpecific;
            if (System.currentTimeMillis() > this.lastClick + 200L && (profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific()) != null) {
                profileSpecific.abiphoneShowOnlyFavourites = !this.isAbiphoneShowOnlyFavourites();
                this.lastClick = System.currentTimeMillis();
            }
            event.setCanceled(true);
            return;
        }
        if (!this.isContact(stack)) {
            return;
        }
        int clickType = event.clickType;
        int clickedButton = event.clickedButton;
        if (clickType == 0 && clickedButton == 1 && !this.isAbiphoneShowOnlyFavourites()) {
            return;
        }
        String rawName = stack.func_82833_r();
        String name = StringUtils.cleanColour(rawName);
        if (clickType == 0 && clickedButton == 0 && (!this.isAbiphoneShowOnlyFavourites() || this.getFavouriteContacts().contains(name))) {
            return;
        }
        if (clickType == 1 && !this.isAbiphoneShowOnlyFavourites()) {
            this.toggleFavouriteContact(rawName, name);
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void replaceItem(ReplaceItemEvent event) {
        IChatComponent chatComponent = event.getInventory().func_145748_c_();
        if (chatComponent == null || this.isWrongInventory()) {
            return;
        }
        ItemStack original = event.getOriginal();
        if (original == null) {
            return;
        }
        if (original.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150397_co)) {
            return;
        }
        if (event.getSlotNumber() > 2 && event.getSlotNumber() < 6) {
            event.replaceWith(this.isAbiphoneShowOnlyFavourites() ? this.ITEM_STACK_FAVOURITE_ONLY : this.ITEM_STACK_ALL);
        }
    }

    private void toggleFavouriteContact(String rawName, String name) {
        if (this.getFavouriteContacts().contains(name)) {
            this.getFavouriteContacts().remove(name);
            Utils.addChatMessage("\u00a7e[NEU] Removed \u00a7r" + rawName + " \u00a7efrom your favourite contacts!");
        } else {
            this.getFavouriteContacts().add(name);
            Utils.addChatMessage("\u00a7e[NEU] Added \u00a7r" + rawName + " \u00a7eto your favourite contacts!");
        }
    }

    public boolean onRenderStack(ItemStack stack) {
        if (this.isWrongInventory()) {
            return false;
        }
        if (stack == null || stack.func_82833_r() == null) {
            return false;
        }
        if (!this.isContact(stack)) {
            return false;
        }
        String rawName = stack.func_82833_r();
        String name = StringUtils.cleanColour(rawName);
        return this.isAbiphoneShowOnlyFavourites() && !this.getFavouriteContacts().contains(name);
    }

    @SubscribeEvent
    public void onDrawBackground(GuiContainerBackgroundDrawnEvent event) {
        if (this.isWrongInventory()) {
            return;
        }
        GuiContainer container = event.getContainer();
        ItemStack checkForShowMenu = container.field_147002_h.func_75139_a(13).func_75211_c();
        this.isInShowMenu = checkForShowMenu != null && checkForShowMenu.func_82833_r().contains("Abiphone ");
        for (Slot slot : container.field_147002_h.field_75151_b) {
            ItemStack stack;
            if (slot == null || (stack = slot.func_75211_c()) == null || !this.isContact(stack)) continue;
            String rawName = stack.func_82833_r();
            String name = StringUtils.cleanColour(rawName);
            if (this.isAbiphoneShowOnlyFavourites() || !this.getFavouriteContacts().contains(name)) continue;
            RenderUtils.highlightSlot(slot, Color.ORANGE);
        }
    }

    private boolean isWrongInventory() {
        return !NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || !NotEnoughUpdates.INSTANCE.config.misc.abiphoneFavourites || Utils.getOpenChestName().equals("Abiphone Shop") || !Utils.getOpenChestName().startsWith("Abiphone ") && !Utils.getOpenChestName().equals("A\u24b7iphone") || this.isInShowMenu;
    }

    private boolean isContact(ItemStack stack) {
        for (String line : ItemUtils.getLore(stack)) {
            if (!line.equals("\u00a7eLeft-click to call!") && !line.equals("\u00a7eClick to call!")) continue;
            return true;
        }
        return false;
    }

    private List<String> getFavouriteContacts() {
        NEUConfig.HiddenProfileSpecific profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (profileSpecific != null) {
            return profileSpecific.abiphoneFavouriteContacts;
        }
        return new ArrayList<String>();
    }

    private boolean isAbiphoneShowOnlyFavourites() {
        NEUConfig.HiddenProfileSpecific profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (profileSpecific != null) {
            return profileSpecific.abiphoneShowOnlyFavourites;
        }
        return false;
    }
}

