/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.Vec3Comparable;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.options.customtypes.NEUDebugFlag;
import io.github.moulberry.notenoughupdates.util.NEUDebugLogger;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import io.github.moulberry.notenoughupdates.util.TitleUtil;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;

public class CrystalMetalDetectorSolver {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static Vec3Comparable prevPlayerPos;
    private static double prevDistToTreasure;
    private static HashSet<BlockPos> possibleBlocks;
    private static final HashMap<Vec3Comparable, Double> evaluatedPlayerPositions;
    private static boolean chestRecentlyFound;
    private static long chestLastFoundMillis;
    private static final HashSet<BlockPos> openedChestPositions;
    private static Vec3i minesCenter;
    private static boolean debugDoNotUseCenter;
    private static boolean visitKeeperMessagePrinted;
    private static final String KEEPER_OF_STRING = "Keeper of ";
    private static final String DIAMOND_STRING = "diamond";
    private static final String LAPIS_STRING = "lapis";
    private static final String EMERALD_STRING = "emerald";
    private static final String GOLD_STRING = "gold";
    private static final HashMap<String, Vec3i> keeperOffsets;
    private static final HashSet<Long> knownChestOffsets;
    static Predicate<BlockPos> treasureAllowedPredicate;
    static SolutionState currentState;
    static SolutionState previousState;

    public static void process(IChatComponent message) {
        if (!(SBInfo.getInstance().getLocation() != null && NotEnoughUpdates.INSTANCE.config.mining.metalDetectorEnabled && SBInfo.getInstance().getLocation().equals("crystal_hollows") && message.func_150260_c().contains("TREASURE: "))) {
            return;
        }
        boolean centerNewlyDiscovered = CrystalMetalDetectorSolver.locateMinesCenterIfNeeded();
        double distToTreasure = Double.parseDouble(message.func_150260_c().split("TREASURE: ")[1].split("m")[0].replaceAll("(?!\\.)\\D", ""));
        if (chestRecentlyFound) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - chestLastFoundMillis < 1000L && distToTreasure < 5.0) {
                return;
            }
            chestLastFoundMillis = currentTimeMillis;
            chestRecentlyFound = false;
        }
        SolutionState originalState = currentState;
        int originalCount = possibleBlocks.size();
        Vec3Comparable adjustedPlayerPos = CrystalMetalDetectorSolver.getPlayerPosAdjustedForEyeHeight();
        CrystalMetalDetectorSolver.findPossibleSolutions(distToTreasure, adjustedPlayerPos, centerNewlyDiscovered);
        if (currentState != originalState || originalCount != possibleBlocks.size()) {
            switch (currentState) {
                case FOUND_KNOWN: {
                    NEUDebugLogger.log(NEUDebugFlag.METAL, "Known location identified.");
                }
                case FOUND: {
                    Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Found solution.");
                    CrystalMetalDetectorSolver.metalDetectorTitle("Found Solution", NotEnoughUpdates.INSTANCE.config.mining.metalDetectorTicks, NotEnoughUpdates.INSTANCE.config.mining.metalDetectorFoundColor);
                    if (!NEUDebugFlag.METAL.isSet() || previousState != SolutionState.INVALID && previousState != SolutionState.FAILED) break;
                    NEUDebugLogger.log(NEUDebugFlag.METAL, EnumChatFormatting.AQUA + "Solution coordinates: " + EnumChatFormatting.WHITE + possibleBlocks.iterator().next().toString());
                    break;
                }
                case INVALID: {
                    Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Previous solution is invalid.");
                    CrystalMetalDetectorSolver.logDiagnosticData(false);
                    CrystalMetalDetectorSolver.resetSolution(false);
                    break;
                }
                case FAILED: {
                    Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Failed to find a solution.");
                    CrystalMetalDetectorSolver.metalDetectorTitle("Failed to find a solution!", NotEnoughUpdates.INSTANCE.config.mining.metalDetectorTicks, NotEnoughUpdates.INSTANCE.config.mining.metalDetectorFailedColor);
                    CrystalMetalDetectorSolver.logDiagnosticData(false);
                    CrystalMetalDetectorSolver.resetSolution(false);
                    break;
                }
                case MULTIPLE_KNOWN: {
                    NEUDebugLogger.log(NEUDebugFlag.METAL, "Multiple known locations identified:");
                }
                case MULTIPLE: {
                    Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Need another position to find solution. Possible blocks: " + possibleBlocks.size());
                    CrystalMetalDetectorSolver.metalDetectorTitle("Need another position!", NotEnoughUpdates.INSTANCE.config.mining.metalDetectorTicks, NotEnoughUpdates.INSTANCE.config.mining.metalDetectorMoveColor);
                    break;
                }
                default: {
                    throw new IllegalStateException("Metal detector is in invalid state");
                }
            }
        }
    }

    private static void metalDetectorTitle(String title, int ticks, String color) {
        if (NotEnoughUpdates.INSTANCE.config.mining.metalDetectorTitle) {
            TitleUtil.getInstance().createTitle(title, ticks, SpecialColour.specialToChromaRGB(color));
        }
    }

    static void findPossibleSolutions(double distToTreasure, Vec3Comparable playerPos, boolean centerNewlyDiscovered) {
        if (Math.abs(prevDistToTreasure - distToTreasure) < 0.2 && prevPlayerPos.func_72438_d(playerPos) <= 0.1 && !evaluatedPlayerPositions.containsKey(playerPos)) {
            evaluatedPlayerPositions.put(playerPos, distToTreasure);
            if (possibleBlocks.size() == 0) {
                int zOffset = (int)Math.floor(-distToTreasure);
                while ((double)zOffset <= Math.ceil(distToTreasure)) {
                    for (int y = 65; y <= 75; ++y) {
                        BlockPos pos;
                        double calculatedDist = 0.0;
                        int xOffset = 0;
                        while (calculatedDist < distToTreasure) {
                            pos = new BlockPos(Math.floor(playerPos.field_72450_a) + (double)xOffset, (double)y, Math.floor(playerPos.field_72449_c) + (double)zOffset);
                            calculatedDist = playerPos.func_72438_d(new Vec3Comparable(pos).addVector(0.0, 1.0, 0.0));
                            if (CrystalMetalDetectorSolver.round(calculatedDist, 1) == distToTreasure && treasureAllowedPredicate.check(pos)) {
                                possibleBlocks.add(pos);
                            }
                            ++xOffset;
                        }
                        xOffset = 0;
                        calculatedDist = 0.0;
                        while (calculatedDist < distToTreasure) {
                            pos = new BlockPos(Math.floor(playerPos.field_72450_a) - (double)xOffset, (double)y, Math.floor(playerPos.field_72449_c) + (double)zOffset);
                            calculatedDist = playerPos.func_72438_d(new Vec3Comparable(pos).addVector(0.0, 1.0, 0.0));
                            if (CrystalMetalDetectorSolver.round(calculatedDist, 1) == distToTreasure && treasureAllowedPredicate.check(pos)) {
                                possibleBlocks.add(pos);
                            }
                            ++xOffset;
                        }
                    }
                    ++zOffset;
                }
                CrystalMetalDetectorSolver.updateSolutionState();
            } else if (possibleBlocks.size() != 1) {
                HashSet<BlockPos> temp = new HashSet<BlockPos>();
                for (BlockPos pos : possibleBlocks) {
                    if (CrystalMetalDetectorSolver.round(playerPos.func_72438_d(new Vec3Comparable(pos).addVector(0.0, 1.0, 0.0)), 1) != distToTreasure) continue;
                    temp.add(pos);
                }
                possibleBlocks = temp;
                CrystalMetalDetectorSolver.updateSolutionState();
            } else {
                BlockPos pos = possibleBlocks.iterator().next();
                Vec3Comparable vec3Comparable = new Vec3Comparable(pos);
                if (Math.abs(distToTreasure - playerPos.func_72438_d(vec3Comparable)) > 5.0) {
                    currentState = SolutionState.INVALID;
                }
            }
        } else if (centerNewlyDiscovered && possibleBlocks.size() > 1) {
            CrystalMetalDetectorSolver.updateSolutionState();
        }
        prevPlayerPos = playerPos;
        prevDistToTreasure = distToTreasure;
    }

    public static void setDebugDoNotUseCenter(boolean val) {
        debugDoNotUseCenter = val;
    }

    private static String getFriendlyBlockPositions(Collection<BlockPos> positions) {
        if (!NEUDebugLogger.isFlagEnabled(NEUDebugFlag.METAL) || positions.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (BlockPos blockPos : positions) {
            sb.append("Absolute: ");
            sb.append(blockPos.toString());
            if (minesCenter != Vec3i.field_177959_e) {
                BlockPos relativeOffset = blockPos.func_177973_b(minesCenter);
                sb.append(", Relative: ");
                sb.append(relativeOffset.toString());
                sb.append(" (" + relativeOffset.func_177986_g() + ")");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String getFriendlyEvaluatedPositions() {
        if (!NEUDebugLogger.isFlagEnabled(NEUDebugFlag.METAL) || evaluatedPlayerPositions.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (Vec3Comparable vec : evaluatedPlayerPositions.keySet()) {
            sb.append("Absolute: " + vec.toString());
            if (minesCenter != Vec3i.field_177959_e) {
                BlockPos positionBlockPos = new BlockPos((Vec3)vec);
                BlockPos relativeOffset = positionBlockPos.func_177973_b(minesCenter);
                sb.append(", Relative: " + relativeOffset.toString() + " (" + relativeOffset.func_177986_g() + ")");
            }
            sb.append(" Distance: ");
            sb.append(evaluatedPlayerPositions.get(vec));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void resetSolution(Boolean chestFound) {
        if (chestFound.booleanValue()) {
            prevPlayerPos = null;
            prevDistToTreasure = 0.0;
            if (possibleBlocks.size() == 1) {
                openedChestPositions.add(possibleBlocks.iterator().next().getImmutable());
            }
        }
        chestRecentlyFound = chestFound;
        possibleBlocks.clear();
        evaluatedPlayerPositions.clear();
        previousState = currentState;
        currentState = SolutionState.NOT_STARTED;
    }

    public static void initWorld() {
        minesCenter = Vec3i.field_177959_e;
        visitKeeperMessagePrinted = false;
        openedChestPositions.clear();
        chestLastFoundMillis = 0L;
        prevDistToTreasure = 0.0;
        prevPlayerPos = null;
        currentState = SolutionState.NOT_STARTED;
        CrystalMetalDetectorSolver.resetSolution(false);
    }

    public static void render(float partialTicks) {
        int beaconRGB = 2087153;
        if (SBInfo.getInstance().getLocation() != null && SBInfo.getInstance().getLocation().equals("crystal_hollows") && SBInfo.getInstance().getScoreboardLocation().equals("Mines of Divan")) {
            if (possibleBlocks.size() == 1) {
                BlockPos block = possibleBlocks.iterator().next();
                RenderUtils.renderBeaconBeam(block.func_177982_a(0, 1, 0), beaconRGB, 1.0f, partialTicks);
                RenderUtils.renderWayPoint("Treasure", (Vec3i)possibleBlocks.iterator().next().func_177963_a(0.0, 2.5, 0.0), partialTicks);
                if (NotEnoughUpdates.INSTANCE.config.mining.metalDetectorLineToSolution) {
                    RenderUtils.renderLineToBlock(block.func_177982_a(0, 1, 0), 2087153, partialTicks);
                }
            } else if (possibleBlocks.size() > 1 && NotEnoughUpdates.INSTANCE.config.mining.metalDetectorShowPossible) {
                for (BlockPos block : possibleBlocks) {
                    RenderUtils.renderBeaconBeam(block.func_177982_a(0, 1, 0), beaconRGB, 1.0f, partialTicks);
                    RenderUtils.renderWayPoint("Possible Treasure Location", (Vec3i)block.func_177963_a(0.0, 2.5, 0.0), partialTicks);
                }
            }
        }
    }

    private static boolean locateMinesCenterIfNeeded() {
        if (minesCenter != Vec3i.field_177959_e) {
            return false;
        }
        List keeperEntities = CrystalMetalDetectorSolver.mc.field_71441_e.func_175644_a(EntityArmorStand.class, entity -> {
            if (!entity.func_145818_k_()) {
                return false;
            }
            return entity.func_95999_t().contains(KEEPER_OF_STRING);
        });
        if (keeperEntities.size() == 0) {
            if (!visitKeeperMessagePrinted) {
                Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Approach a Keeper while holding the metal detector to enable faster treasure hunting.");
                visitKeeperMessagePrinted = true;
            }
            return false;
        }
        EntityArmorStand keeperEntity = (EntityArmorStand)keeperEntities.get(0);
        String keeperName = keeperEntity.func_95999_t();
        NEUDebugLogger.log(NEUDebugFlag.METAL, "Locating center using Keeper: " + EnumChatFormatting.WHITE + keeperEntity);
        String keeperType = keeperName.substring(keeperName.indexOf(KEEPER_OF_STRING) + KEEPER_OF_STRING.length());
        minesCenter = keeperEntity.func_180425_c().func_177971_a(keeperOffsets.get(keeperType.toLowerCase(Locale.ROOT)));
        NEUDebugLogger.log(NEUDebugFlag.METAL, "Mines center: " + EnumChatFormatting.WHITE + minesCenter.toString());
        Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Faster treasure hunting is now enabled based on Keeper location.");
        return true;
    }

    public static void setMinesCenter(BlockPos center) {
        minesCenter = center;
    }

    private static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    private static void updateSolutionState() {
        previousState = currentState;
        if (possibleBlocks.size() == 0) {
            currentState = SolutionState.FAILED;
            return;
        }
        if (possibleBlocks.size() == 1) {
            currentState = SolutionState.FOUND;
            return;
        }
        if (minesCenter.equals((Object)BlockPos.field_177959_e) || debugDoNotUseCenter) {
            currentState = SolutionState.MULTIPLE;
            return;
        }
        HashSet temp = possibleBlocks.stream().filter(block -> knownChestOffsets.contains(block.func_177973_b(minesCenter).func_177986_g())).collect(Collectors.toCollection(HashSet::new));
        if (temp.size() == 0) {
            currentState = SolutionState.MULTIPLE;
            return;
        }
        if (temp.size() == 1) {
            possibleBlocks = temp;
            currentState = SolutionState.FOUND_KNOWN;
            return;
        }
        currentState = SolutionState.MULTIPLE_KNOWN;
    }

    public static BlockPos getSolution() {
        if (possibleBlocks.size() != 1) {
            return BlockPos.field_177992_a;
        }
        return (BlockPos)possibleBlocks.stream().iterator().next();
    }

    private static Vec3Comparable getPlayerPosAdjustedForEyeHeight() {
        return new Vec3Comparable(CrystalMetalDetectorSolver.mc.field_71439_g.field_70165_t, CrystalMetalDetectorSolver.mc.field_71439_g.field_70163_u + (double)(CrystalMetalDetectorSolver.mc.field_71439_g.func_70047_e() - CrystalMetalDetectorSolver.mc.field_71439_g.getDefaultEyeHeight()), CrystalMetalDetectorSolver.mc.field_71439_g.field_70161_v);
    }

    static boolean isKnownOffset(BlockPos pos) {
        return knownChestOffsets.contains(pos.func_177973_b(minesCenter).func_177986_g());
    }

    static boolean isAllowedBlockType(BlockPos pos) {
        return CrystalMetalDetectorSolver.mc.field_71441_e.func_180495_p(pos).func_177230_c().getRegistryName().equals("minecraft:gold_block") || CrystalMetalDetectorSolver.mc.field_71441_e.func_180495_p(pos).func_177230_c().getRegistryName().equals("minecraft:prismarine") || CrystalMetalDetectorSolver.mc.field_71441_e.func_180495_p(pos).func_177230_c().getRegistryName().equals("minecraft:chest") || CrystalMetalDetectorSolver.mc.field_71441_e.func_180495_p(pos).func_177230_c().getRegistryName().equals("minecraft:stained_glass") || CrystalMetalDetectorSolver.mc.field_71441_e.func_180495_p(pos).func_177230_c().getRegistryName().equals("minecraft:stained_glass_pane") || CrystalMetalDetectorSolver.mc.field_71441_e.func_180495_p(pos).func_177230_c().getRegistryName().equals("minecraft:wool") || CrystalMetalDetectorSolver.mc.field_71441_e.func_180495_p(pos).func_177230_c().getRegistryName().equals("minecraft:stained_hardened_clay");
    }

    static boolean isAirAbove(BlockPos pos) {
        return CrystalMetalDetectorSolver.mc.field_71441_e.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c().getRegistryName().equals("minecraft:air");
    }

    private static boolean treasureAllowed(BlockPos pos) {
        boolean airAbove = CrystalMetalDetectorSolver.isAirAbove(pos);
        boolean allowedBlockType = CrystalMetalDetectorSolver.isAllowedBlockType(pos);
        return CrystalMetalDetectorSolver.isKnownOffset(pos) || airAbove && allowedBlockType;
    }

    private static String getDiagnosticMessage() {
        StringBuilder diagsMessage = new StringBuilder();
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Mines Center: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(minesCenter.equals((Object)Vec3i.field_177959_e) ? "<NOT DISCOVERED>" : minesCenter.toString());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Current Solution State: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(currentState.name());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Previous Solution State: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(previousState.name());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Previous Player Position: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(prevPlayerPos == null ? "<NONE>" : prevPlayerPos.toString());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Previous Distance To Treasure: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(prevDistToTreasure == 0.0 ? "<NONE>" : Double.valueOf(prevDistToTreasure));
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Current Possible Blocks: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(possibleBlocks.size());
        diagsMessage.append(CrystalMetalDetectorSolver.getFriendlyBlockPositions(possibleBlocks));
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Evaluated player positions: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(evaluatedPlayerPositions.size());
        diagsMessage.append(CrystalMetalDetectorSolver.getFriendlyEvaluatedPositions());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Chest locations not on known list:\n");
        diagsMessage.append(EnumChatFormatting.WHITE);
        if (minesCenter != Vec3i.field_177959_e) {
            HashSet locationsNotOnKnownList = openedChestPositions.stream().filter(block -> !knownChestOffsets.contains(block.func_177973_b(minesCenter).func_177986_g())).map(block -> block.func_177973_b(minesCenter)).collect(Collectors.toCollection(HashSet::new));
            if (locationsNotOnKnownList.size() > 0) {
                for (BlockPos blockPos : locationsNotOnKnownList) {
                    diagsMessage.append(String.format("%dL,\t\t// x=%d, y=%d, z=%d", blockPos.func_177986_g(), blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
                }
            }
        } else {
            diagsMessage.append("<REQUIRES MINES CENTER>");
        }
        return diagsMessage.toString();
    }

    public static void logDiagnosticData(boolean outputAlways) {
        if (!SBInfo.getInstance().checkForSkyblockLocation()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.mining.metalDetectorEnabled) {
            Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Metal Detector Solver is not enabled.");
            return;
        }
        boolean metalDebugFlagSet = NotEnoughUpdates.INSTANCE.config.hidden.debugFlags.contains((Object)NEUDebugFlag.METAL);
        if (outputAlways || metalDebugFlagSet) {
            NEUDebugLogger.logAlways(CrystalMetalDetectorSolver.getDiagnosticMessage());
        }
    }

    static {
        possibleBlocks = new HashSet();
        evaluatedPlayerPositions = new HashMap();
        openedChestPositions = new HashSet();
        debugDoNotUseCenter = false;
        keeperOffsets = new HashMap<String, Vec3i>(){
            {
                this.put(CrystalMetalDetectorSolver.DIAMOND_STRING, new Vec3i(33, 0, 3));
                this.put(CrystalMetalDetectorSolver.LAPIS_STRING, new Vec3i(-33, 0, -3));
                this.put(CrystalMetalDetectorSolver.EMERALD_STRING, new Vec3i(-3, 0, 33));
                this.put(CrystalMetalDetectorSolver.GOLD_STRING, new Vec3i(3, 0, -33));
            }
        };
        knownChestOffsets = new HashSet<Long>(Arrays.asList(-10171958951910L, 10718829084646L, -10721714765806L, -10996458455018L, -1100920913904L, 11268584898530L, -11271269253148L, -11546281377832L, 11818542038999L, 0xAFFAFFFFFF0L, -1409286164L, 1922736062492L, 2197613969419L, 2197613969430L, -3024999153708L, 3571936395295L, 3572003504106L, 3572003504135L, 3572070612949L, -3574822076373L, -3574822076394L, -4399455797228L, -5224156626944L, 548346527764L, 5496081743901L, 5770959650816L, 5771093868518L, -6048790347736L, 6320849682418L, -6323668254708L, 6595593371674L, 6595660480473L, 6870471278619L, 7145349185553L, 8244995030996L, -8247679385612L, -8247679385640L, 8519872937959L, -8522557292584L, -9622068920278L, -9896946827278L, -9896946827286L));
        treasureAllowedPredicate = CrystalMetalDetectorSolver::treasureAllowed;
        currentState = SolutionState.NOT_STARTED;
        previousState = SolutionState.NOT_STARTED;
    }

    public static interface Predicate<BlockPos> {
        public boolean check(BlockPos var1);
    }

    static enum SolutionState {
        NOT_STARTED,
        MULTIPLE,
        MULTIPLE_KNOWN,
        FOUND,
        FOUND_KNOWN,
        FAILED,
        INVALID;

    }
}

