/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpingInteger;
import io.github.moulberry.notenoughupdates.itemeditor.GuiElementTextField;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.util.GuiTextures;
import io.github.moulberry.notenoughupdates.util.TemplateUtil;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class GuiEnchantColour
extends GuiScreen {
    public static final ResourceLocation custom_ench_colour = new ResourceLocation("notenoughupdates:custom_ench_colour.png");
    private static final String sharePrefix = "NEUEC/";
    private int guiLeft;
    private int guiTop;
    private final int xSize = 217;
    private int ySize = 0;
    private int ySizeSidebar = 0;
    private int guiTopSidebar;
    public static final Splitter splitter = Splitter.on((String)":").limit(5);
    private final HashMap<Integer, String> comparators = new HashMap();
    private final HashMap<Integer, String> modifiers = new HashMap();
    private final List<GuiElementTextField[]> guiElementTextFields = new ArrayList<GuiElementTextField[]>();
    private final LerpingInteger scroll = new LerpingInteger(0, 100);
    private final LerpingInteger scrollSideBar = new LerpingInteger(0, 100);
    public static int BOLD_MODIFIER = 1;
    public static int ITALIC_MODIFIER = 2;
    public static int OBFUSCATED_MODIFIER = 4;
    public static int UNDERLINE_MODIFIER = 8;
    public static int STRIKETHROUGH_MODIFIER = 16;
    private static final Pattern settingPattern = Pattern.compile(".*:[>=<]:[0-9]+:[a-zA-Z0-9]+(:[a-zA-Z0-9]+)?");
    private ItemStack maxedBook;
    private ItemStack maxedAttBook;
    private int maxedBookFound = 0;
    private int maxedAttBookFound = 0;

    private List<String> getEnchantColours() {
        return NotEnoughUpdates.INSTANCE.config.hidden.enchantColours;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        List<String> enchantColours = this.getEnchantColours();
        this.ySize = 53 + 25 * enchantColours.size();
        this.guiLeft = (this.field_146294_l - 217) / 2;
        if (this.ySize > this.field_146295_m) {
            if (this.scroll.getTarget() > 0) {
                this.scroll.setTarget(0);
            } else if (this.scroll.getTarget() < this.field_146295_m - this.ySize) {
                this.scroll.setTarget(this.field_146295_m - this.ySize);
            }
            this.scroll.tick();
            this.guiTop = this.scroll.getValue();
        } else {
            this.guiTop = (this.field_146295_m - this.ySize) / 2;
            this.scroll.setValue(0);
            this.scroll.resetTimer();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(custom_ench_colour);
        Utils.drawTexturedRect(this.guiLeft, this.guiTop, 217.0f, 21.0f, 0.0f, 1.0f, 0.0f, 0.26923078f, 9728);
        Utils.drawTexturedRect(this.guiLeft, this.guiTop + this.ySize - 32, 217.0f, 32.0f, 0.0f, 1.0f, 0.5897436f, 1.0f, 9728);
        this.field_146289_q.func_78276_b("Ench Name", this.guiLeft + 10, this.guiTop + 7, 0x404040);
        this.field_146289_q.func_78276_b("CMP", this.guiLeft + 86, this.guiTop + 7, 0x404040);
        this.field_146289_q.func_78276_b("LVL", this.guiLeft + 111, this.guiTop + 7, 0x404040);
        this.field_146289_q.func_78276_b("COL", this.guiLeft + 136, this.guiTop + 7, 0x404040);
        this.field_146289_q.func_78276_b("DEL", this.guiLeft + 161, this.guiTop + 7, 0x404040);
        Utils.drawStringCentered("Add Ench Colour", this.guiLeft + 108 + 1, this.guiTop + this.ySize - 20, false, 0x404040);
        int yIndex = 0;
        for (String str : enchantColours) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(custom_ench_colour);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.guiLeft, this.guiTop + 21 + yIndex * 25, 217.0f, 25.0f, 0.0f, 1.0f, 0.26923078f, 0.5897436f, 9728);
            List colourOps = splitter.splitToList((CharSequence)str);
            String enchantName = GuiEnchantColour.getColourOpIndex(colourOps, 0);
            String comparator = GuiEnchantColour.getColourOpIndex(colourOps, 1);
            String comparison = GuiEnchantColour.getColourOpIndex(colourOps, 2);
            String colourCode = GuiEnchantColour.getColourOpIndex(colourOps, 3);
            String modifier = GuiEnchantColour.getColourOpIndex(colourOps, 4);
            this.modifiers.put(yIndex, modifier);
            if (colourCode.length() > 1) {
                colourCode = String.valueOf(colourCode.toLowerCase(Locale.ROOT).charAt(0));
            }
            if (comparator.length() > 1) {
                comparator = String.valueOf(comparator.toLowerCase(Locale.ROOT).charAt(0));
            }
            Utils.drawStringCentered(comparator, this.guiLeft + 96, this.guiTop + 33 + 25 * yIndex, false, 0x404040);
            if (this.guiElementTextFields.size() <= yIndex) {
                this.guiElementTextFields.add(new GuiElementTextField[3]);
            }
            if (this.guiElementTextFields.get(yIndex)[0] == null) {
                this.guiElementTextFields.get((int)yIndex)[0] = new GuiElementTextField(enchantName, 32);
                this.guiElementTextFields.get(yIndex)[0].setSize(75, 20);
            }
            if (this.guiElementTextFields.get(yIndex)[1] == null) {
                this.guiElementTextFields.get((int)yIndex)[1] = new GuiElementTextField(comparison, 56);
                this.guiElementTextFields.get(yIndex)[1].setSize(20, 20);
            }
            if (this.guiElementTextFields.get(yIndex)[2] == null) {
                this.guiElementTextFields.get((int)yIndex)[2] = new GuiElementTextField(colourCode, 32);
                this.guiElementTextFields.get(yIndex)[2].setSize(20, 20);
            }
            this.guiElementTextFields.get(yIndex)[0].setText(enchantName);
            this.guiElementTextFields.get(yIndex)[1].setText(comparison);
            this.comparators.put(yIndex, comparator);
            this.guiElementTextFields.get(yIndex)[2].setText(colourCode);
            this.guiElementTextFields.get(yIndex)[0].render(this.guiLeft + 7, this.guiTop + 23 + 25 * yIndex);
            this.guiElementTextFields.get(yIndex)[1].render(this.guiLeft + 110, this.guiTop + 23 + 25 * yIndex);
            this.guiElementTextFields.get(yIndex)[2].render(this.guiLeft + 135, this.guiTop + 23 + 25 * yIndex);
            int modifierI = GuiEnchantColour.getIntModifier(modifier);
            if ((modifierI & BOLD_MODIFIER) != 0) {
                Minecraft.func_71410_x().field_71466_p.func_175065_a("\u00a7l\u2713", (float)(this.guiLeft + 181), (float)(this.guiTop + 23 + 25 * yIndex - 2), -14671840, true);
            }
            if ((modifierI & ITALIC_MODIFIER) != 0) {
                Minecraft.func_71410_x().field_71466_p.func_175065_a("\u00a7l\u2713", (float)(this.guiLeft + 181), (float)(this.guiTop + 23 + 25 * yIndex + 10), -14671840, true);
            }
            if ((modifierI & UNDERLINE_MODIFIER) != 0) {
                Minecraft.func_71410_x().field_71466_p.func_175065_a("\u00a7l\u2713", (float)(this.guiLeft + 196), (float)(this.guiTop + 23 + 25 * yIndex - 2), -14671840, true);
            }
            if ((modifierI & STRIKETHROUGH_MODIFIER) != 0) {
                Minecraft.func_71410_x().field_71466_p.func_175065_a("\u00a7l\u2713", (float)(this.guiLeft + 196), (float)(this.guiTop + 23 + 25 * yIndex + 10), -14671840, true);
            }
            ++yIndex;
        }
        this.renderSideBar(mouseX, mouseY, partialTicks);
        List tooltipToDisplay = null;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.help);
        Utils.drawTexturedRect(this.guiLeft + 217 + 3, this.guiTopSidebar - 18, 16.0f, 16.0f, 9728);
        if (this.maxedBookFound == 0) {
            try {
                if (NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("MAXED_ENCHANT_BOOK")).func_82837_s()) {
                    this.maxedBook = NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("MAXED_ENCHANT_BOOK"));
                    this.maxedBookFound = 1;
                } else {
                    this.maxedBookFound = 2;
                }
            }
            catch (Exception ignored) {
                this.maxedBookFound = 2;
            }
        }
        if (this.maxedBookFound == 1) {
            Utils.drawItemStack(this.maxedBook, this.guiLeft + 217 + 3, this.guiTopSidebar - 34);
        }
        if (this.maxedAttBookFound == 0) {
            try {
                if (NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("MAXED_ATTRIBUTE_SHARD")).func_82837_s()) {
                    this.maxedAttBook = NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("MAXED_ATTRIBUTE_SHARD"));
                    this.maxedAttBookFound = 1;
                } else {
                    this.maxedAttBookFound = 2;
                }
            }
            catch (Exception ignored) {
                this.maxedAttBookFound = 2;
            }
        }
        if (this.maxedAttBookFound == 1) {
            Utils.drawItemStack(this.maxedAttBook, this.guiLeft + 217 + 3, this.guiTopSidebar - 52);
        }
        if (mouseX >= this.guiLeft + 217 + 3 && mouseX < this.guiLeft + 217 + 39) {
            boolean renderingTooltip = false;
            if (mouseY >= this.guiTopSidebar - 34 && mouseY <= this.guiTopSidebar - 18 && this.maxedBookFound == 1) {
                tooltipToDisplay = this.maxedBook.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
                Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, this.field_146294_l, this.field_146295_m, -1);
                tooltipToDisplay = null;
                renderingTooltip = true;
            }
            if (mouseY >= this.guiTopSidebar - 52 && mouseY <= this.guiTopSidebar - 34 && this.maxedAttBookFound == 1 && !renderingTooltip) {
                tooltipToDisplay = this.maxedAttBook.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
                Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, this.field_146294_l, this.field_146295_m, -1);
                tooltipToDisplay = null;
                renderingTooltip = true;
            }
            if (mouseY >= this.guiTopSidebar - 18 && mouseY <= this.guiTopSidebar - 2 && !renderingTooltip) {
                tooltipToDisplay = Lists.newArrayList((Object[])new String[]{EnumChatFormatting.AQUA + "NEUEC Colouring Guide", EnumChatFormatting.GREEN + "", EnumChatFormatting.GREEN + "How to use the GUI", EnumChatFormatting.YELLOW + "Type the name of the enchant you want to colour in the left box", EnumChatFormatting.YELLOW + "Change the comparison: ", EnumChatFormatting.RED + "> " + EnumChatFormatting.YELLOW + "greater than a level ", EnumChatFormatting.RED + "= " + EnumChatFormatting.YELLOW + "equals the level ", EnumChatFormatting.RED + "< " + EnumChatFormatting.YELLOW + "less than a level", EnumChatFormatting.YELLOW + "Put the level of enchant you want to color in the middle box", EnumChatFormatting.YELLOW + "Put the color code you want to use here", EnumChatFormatting.GREEN + "", EnumChatFormatting.GREEN + "Available colour codes:", Utils.chromaString("z = Chroma"), EnumChatFormatting.DARK_BLUE + "1 = Dark Blue", EnumChatFormatting.DARK_GREEN + "2 = Dark Green", EnumChatFormatting.DARK_AQUA + "3 = Dark Aqua", EnumChatFormatting.DARK_RED + "4 = Dark Red", EnumChatFormatting.DARK_PURPLE + "5 = Dark Purple", EnumChatFormatting.GOLD + "6 = Gold", EnumChatFormatting.GRAY + "7 = Gray", EnumChatFormatting.DARK_GRAY + "8 = Dark Gray", EnumChatFormatting.BLUE + "9 = Blue", EnumChatFormatting.GREEN + "a = Green", EnumChatFormatting.AQUA + "b = Aqua", EnumChatFormatting.RED + "c = Red", EnumChatFormatting.LIGHT_PURPLE + "d = Purple", EnumChatFormatting.YELLOW + "e = Yellow", EnumChatFormatting.WHITE + "f = White", "\u00a7ZZ = SBA Chroma" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " (Requires SBA)", "", EnumChatFormatting.GREEN + "Available formatting:", EnumChatFormatting.GRAY + "" + EnumChatFormatting.BOLD + "B = " + EnumChatFormatting.BOLD + "Bold", EnumChatFormatting.GRAY + "" + EnumChatFormatting.STRIKETHROUGH + "S" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " = " + EnumChatFormatting.STRIKETHROUGH + "Strikethrough", EnumChatFormatting.GRAY + "" + EnumChatFormatting.UNDERLINE + "U" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " = " + EnumChatFormatting.UNDERLINE + "Underline", EnumChatFormatting.GRAY + "" + EnumChatFormatting.ITALIC + "I" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " = " + EnumChatFormatting.ITALIC + "Italic"});
                Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, this.field_146294_l, this.field_146295_m, -1);
                tooltipToDisplay = null;
            }
        }
    }

    private void renderSideBar(int mouseX, int mouseY, float partialTicks) {
        this.ySizeSidebar = 48;
        if (this.ySizeSidebar > this.field_146295_m) {
            if (this.scrollSideBar.getTarget() > 0) {
                this.scrollSideBar.setTarget(0);
            } else if (this.scrollSideBar.getTarget() < this.field_146295_m - this.ySizeSidebar) {
                this.scrollSideBar.setTarget(this.field_146295_m - this.ySizeSidebar);
            }
            this.scrollSideBar.tick();
            this.guiTopSidebar = this.scrollSideBar.getValue();
        } else {
            this.guiTopSidebar = (this.field_146295_m - this.ySizeSidebar) / 2;
            this.scrollSideBar.setValue(0);
            this.scrollSideBar.resetTimer();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(custom_ench_colour);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft + 217 + 3, this.guiTopSidebar + 2, 88.0f, 20.0f, 0.29493088f, 0.70046085f, 0.61538464f, 0.8717949f, 9728);
        Utils.drawTexturedRect(this.guiLeft + 217 + 3, this.guiTopSidebar + 2 + 24, 88.0f, 20.0f, 0.29493088f, 0.70046085f, 0.61538464f, 0.8717949f, 9728);
        Utils.drawTexturedRect(this.guiLeft + 217 + 3, this.guiTopSidebar + 2 + 48, 88.0f, 20.0f, 0.29493088f, 0.70046085f, 0.61538464f, 0.8717949f, 9728);
        Utils.drawStringCenteredScaledMaxWidth("Load preset", this.guiLeft + 217 + 4 + 44, this.guiTopSidebar + 8, false, 86, 0x404040);
        Utils.drawStringCenteredScaledMaxWidth("from Clipboard", this.guiLeft + 217 + 4 + 44, this.guiTopSidebar + 16, false, 86, 0x404040);
        Utils.drawStringCenteredScaledMaxWidth("Save preset", this.guiLeft + 217 + 4 + 44, this.guiTopSidebar + 8 + 24, false, 86, 0x404040);
        Utils.drawStringCenteredScaledMaxWidth("to Clipboard", this.guiLeft + 217 + 4 + 44, this.guiTopSidebar + 16 + 24, false, 86, 0x404040);
        Utils.drawStringCenteredScaledMaxWidth("Reset Config", this.guiLeft + 217 + 4 + 44, this.guiTopSidebar + 12 + 48, false, 86, 0x404040);
        if (!this.validShareContents()) {
            Gui.func_73734_a((int)(this.guiLeft + 217 + 3), (int)(this.guiTopSidebar + 2), (int)(this.guiLeft + 217 + 3 + 88), (int)(this.guiTopSidebar + 2 + 20), (int)Integer.MIN_VALUE);
        }
    }

    public void func_146281_b() {
        NotEnoughUpdates.INSTANCE.saveConfig();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        for (int yIndex = 0; yIndex < this.guiElementTextFields.size(); ++yIndex) {
            for (int i = 0; i < 3; ++i) {
                this.guiElementTextFields.get(yIndex)[i].keyTyped(typedChar, keyCode);
                if (!this.guiElementTextFields.get(yIndex)[i].getFocus()) continue;
                int addOffset = 0;
                if (keyCode == 200) {
                    --addOffset;
                } else if (keyCode == 208) {
                    ++addOffset;
                }
                NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.remove(yIndex);
                if (yIndex + addOffset < 0) {
                    addOffset = -yIndex;
                } else if (yIndex + addOffset > NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.size()) {
                    addOffset = NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.size() - yIndex;
                }
                NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.add(yIndex + addOffset, this.getEnchantOpString(this.guiElementTextFields.get(yIndex), this.comparators.get(yIndex), this.modifiers.get(yIndex)));
                if (addOffset != 0) {
                    GuiElementTextField[] guiElementTextFieldArray = this.guiElementTextFields.remove(yIndex);
                    this.guiElementTextFields.add(yIndex + addOffset, guiElementTextFieldArray);
                }
                return;
            }
        }
    }

    public String getEnchantOpString(GuiElementTextField[] tfs, String comparator, String modifiers) {
        StringBuilder enchantOp = new StringBuilder();
        enchantOp.append(tfs[0].getText());
        enchantOp.append(":");
        enchantOp.append(comparator);
        enchantOp.append(":");
        enchantOp.append(tfs[1].getText());
        enchantOp.append(":");
        enchantOp.append(tfs[2].getText());
        enchantOp.append(":");
        enchantOp.append(modifiers);
        return enchantOp.toString();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int dWheel = Mouse.getEventDWheel();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        if (mouseX > this.guiLeft && mouseX < this.guiLeft + 217) {
            if (dWheel < 0) {
                this.scroll.setTarget(this.scroll.getTarget() - 50);
                this.scroll.resetTimer();
            } else if (dWheel > 0) {
                this.scroll.setTarget(this.scroll.getTarget() + 50);
                this.scroll.resetTimer();
            }
        } else if (mouseX > this.guiLeft + 217 && mouseX < this.guiLeft + 217 + 100) {
            if (dWheel < 0) {
                this.scrollSideBar.setTarget(this.scrollSideBar.getTarget() - 50);
                this.scrollSideBar.resetTimer();
            } else if (dWheel > 0) {
                this.scrollSideBar.setTarget(this.scrollSideBar.getTarget() + 50);
                this.scrollSideBar.resetTimer();
            }
        }
    }

    public static int getIntModifier(String modifier) {
        try {
            return Integer.parseInt(modifier);
        }
        catch (NumberFormatException e2) {
            return 0;
        }
    }

    private boolean validShareContents() {
        String base64 = Utils.getClipboard();
        if (base64 == null) {
            return false;
        }
        return Objects.equals(TemplateUtil.getTemplatePrefix(base64), sharePrefix);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int yIndex = 0; yIndex < this.guiElementTextFields.size(); ++yIndex) {
            for (int i = 0; i < 3; ++i) {
                int x = this.guiLeft + 7;
                if (i == 1) {
                    x += 103;
                } else if (i == 2) {
                    x += 128;
                }
                if (mouseX > x && mouseX < x + this.guiElementTextFields.get(yIndex)[i].getWidth() && mouseY > this.guiTop + 23 + 25 * yIndex && mouseY < this.guiTop + 23 + 25 * yIndex + 20) {
                    this.guiElementTextFields.get(yIndex)[i].mouseClicked(mouseX, mouseY, mouseButton);
                    if (mouseButton != 1) continue;
                    NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.remove(yIndex);
                    NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.add(yIndex, this.getEnchantOpString(this.guiElementTextFields.get(yIndex), this.comparators.get(yIndex), this.modifiers.get(yIndex)));
                    continue;
                }
                this.guiElementTextFields.get(yIndex)[i].otherComponentClick();
            }
            this.comparators.putIfAbsent(yIndex, ">");
            this.modifiers.putIfAbsent(yIndex, "0");
            if (mouseX >= this.guiLeft + 180 && mouseX <= this.guiLeft + 210 && mouseY >= this.guiTop + 23 + 25 * yIndex && mouseY <= this.guiTop + 23 + 25 * yIndex + 20) {
                int modifierI = GuiEnchantColour.getIntModifier(this.modifiers.get(yIndex));
                int selectedModifier = -1;
                selectedModifier = mouseX < this.guiLeft + 195 ? (mouseY < this.guiTop + 23 + 25 * yIndex + 10 ? BOLD_MODIFIER : ITALIC_MODIFIER) : (mouseY < this.guiTop + 23 + 25 * yIndex + 10 ? UNDERLINE_MODIFIER : STRIKETHROUGH_MODIFIER);
                if (selectedModifier != -1) {
                    int modifierMasked = modifierI & selectedModifier;
                    int modifierMaskedInverted = selectedModifier - modifierMasked;
                    int modifierInverted = -1 - selectedModifier;
                    int finalModifier = modifierI & modifierInverted | modifierMaskedInverted;
                    this.modifiers.put(yIndex, "" + finalModifier);
                    NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.remove(yIndex);
                    NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.add(yIndex, this.getEnchantOpString(this.guiElementTextFields.get(yIndex), this.comparators.get(yIndex), this.modifiers.get(yIndex)));
                }
            }
            if (mouseY <= this.guiTop + 23 + 25 * yIndex || mouseY >= this.guiTop + 23 + 25 * yIndex + 20) continue;
            if (mouseX > this.guiLeft + 86 && mouseX < this.guiLeft + 86 + 20) {
                switch (this.comparators.get(yIndex)) {
                    case ">": {
                        this.comparators.put(yIndex, "=");
                        break;
                    }
                    case "=": {
                        this.comparators.put(yIndex, "<");
                        break;
                    }
                    default: {
                        this.comparators.put(yIndex, ">");
                    }
                }
                NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.remove(yIndex);
                NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.add(yIndex, this.getEnchantOpString(this.guiElementTextFields.get(yIndex), this.comparators.get(yIndex), this.modifiers.get(yIndex)));
                continue;
            }
            if (mouseX <= this.guiLeft + 160 || mouseX >= this.guiLeft + 160 + 20 || NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.size() <= 0) continue;
            NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.remove(yIndex);
            this.guiElementTextFields.remove(yIndex);
            this.comparators.remove(yIndex);
            this.modifiers.remove(yIndex);
        }
        if (mouseX >= this.guiLeft + 57 && mouseX <= this.guiLeft + 217 - 57 && mouseY >= this.guiTop + this.ySize - 30 && mouseY <= this.guiTop + this.ySize - 10) {
            NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.add("[a-zA-Z\\- ]+:>:5:9:0");
        }
        if (mouseX > this.guiLeft + 217 + 3 && mouseX < this.guiLeft + 217 + 3 + 88) {
            if (mouseY > this.guiTopSidebar + 2 && mouseY < this.guiTopSidebar + 20 + 2) {
                String base64 = Utils.getClipboard();
                if (base64 == null) {
                    return;
                }
                JsonArray presetArray = TemplateUtil.maybeDecodeTemplate(sharePrefix, base64, JsonArray.class);
                ArrayList<String> presetList = new ArrayList<String>();
                for (int i = 0; i < presetArray.size(); ++i) {
                    String test;
                    Matcher matcher;
                    if (!presetArray.get(i).isJsonPrimitive() || !(matcher = settingPattern.matcher(test = presetArray.get(i).getAsString())).matches()) continue;
                    presetList.add(presetArray.get(i).getAsString());
                }
                if (presetList.size() != 0) {
                    NotEnoughUpdates.INSTANCE.config.hidden.enchantColours = presetList;
                }
            } else if (mouseY > this.guiTopSidebar + 2 + 24 && mouseY < this.guiTopSidebar + 20 + 24 + 2) {
                ArrayList<String> result2 = NotEnoughUpdates.INSTANCE.config.hidden.enchantColours;
                JsonArray jsonArray = new JsonArray();
                for (String s : result2) {
                    jsonArray.add(new JsonPrimitive(s));
                }
                String base64String = TemplateUtil.encodeTemplate(sharePrefix, jsonArray);
                Utils.copyToClipboard(base64String);
            } else if (mouseY > this.guiTopSidebar + 2 + 48 && mouseY < this.guiTopSidebar + 20 + 2 + 48) {
                NotEnoughUpdates.INSTANCE.config.hidden.enchantColours = NEUConfig.createDefaultEnchantColours();
            }
        }
    }

    public static String getColourOpIndex(List<String> colourOps, int index) {
        if (colourOps.size() > index) {
            return colourOps.get(index);
        }
        switch (index) {
            case 0: {
                return "[a-zA-Z\\- ]+";
            }
            case 1: {
                return ">";
            }
            case 2: {
                return "5";
            }
            case 3: {
                return "9";
            }
            case 4: {
                return "0";
            }
        }
        return null;
    }
}

