/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.util.Calculator;
import java.math.BigDecimal;
import java.util.Optional;

public class NeuSearchCalculator {
    static String lastInput = "";
    static String lastResult = null;
    public static Calculator.VariableProvider PROVIDE_LOWEST_BIN = name -> {
        double bazaarOrBin = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarOrBin(name, false);
        if (bazaarOrBin < 0.0) {
            return Optional.empty();
        }
        return Optional.of(BigDecimal.valueOf(bazaarOrBin));
    };

    public static String format(String text) {
        String calculate = NeuSearchCalculator.calculateInSearchBar(text);
        return text + (calculate != null ? " \u00a7e= \u00a7a" + calculate : "");
    }

    private static String calculateInSearchBar(String input) {
        int calculationMode = NotEnoughUpdates.INSTANCE.config.misc.calculationMode;
        if (input.isEmpty() || calculationMode == 0 || calculationMode == 1 && !input.startsWith("!")) {
            return null;
        }
        String string = input = calculationMode == 1 ? input.substring(1) : input;
        if (!lastInput.equals(input)) {
            lastInput = input;
            try {
                BigDecimal calculate = Calculator.calculate(input, PROVIDE_LOWEST_BIN);
                lastResult = Calculator.getDecimalFormat().format(calculate);
            }
            catch (Calculator.CalculatorException ignored) {
                lastResult = null;
            }
        }
        return lastResult;
    }
}

